/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.gui.screen;

import asmodeuscore.api.space.ICelestialRegistry;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.utils.ACCompatibilityManager;
import asmodeuscore.core.utils.UtilsGC;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class AC_GuiCelestialSelection
extends GuiCelestialSelection {
    protected GuiCelestialSelection.EnumView viewState = GuiCelestialSelection.EnumView.PREVIEW;
    protected Random rand = new Random();
    private String galaxy = GalacticraftCore.planetOverworld.getParentSolarSystem().getUnlocalizedParentGalaxyName();
    private List<String> galaxylist = new ArrayList<String>();
    private List<SolarSystem> starlist = new ArrayList<SolarSystem>();
    private static ResourceLocation guiMain2 = new ResourceLocation("asmodeuscore", "textures/gui/celestialselection2.png");
    private static ResourceLocation guiImg = new ResourceLocation("asmodeuscore", "textures/gui/galaxymap_1.png");
    private double xImgOffset = 0.0;
    private double yImgOffset = 0.0;
    private Vector3 nebula_color = new Vector3((double)this.rand.nextFloat(), (double)this.rand.nextFloat(), (double)this.rand.nextFloat());
    private int nebula_img = this.rand.nextInt(2);
    private boolean enableGrid = true;

    public AC_GuiCelestialSelection(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations) {
        super(mapMode, possibleBodies, canCreateStations);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        BORDER_SIZE = this.field_146294_l / 65;
        BORDER_EDGE_SIZE = BORDER_SIZE / 4;
        this.refreshBodies();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
            this.xImgOffset += (double)this.translation.x;
            this.yImgOffset += (double)this.translation.y;
        }
        if (this.xImgOffset > 20.0) {
            this.xImgOffset = 20.0;
        }
        if (this.xImgOffset < -150.0) {
            this.xImgOffset = -150.0;
        }
        if (this.yImgOffset > 20.0) {
            this.yImgOffset = 20.0;
        }
        if (this.yImgOffset < -80.0) {
            this.yImgOffset = -80.0;
        }
    }

    public void func_73863_a(int mousePosX, int mousePosY, float partialTicks) {
        super.func_73863_a(mousePosX, mousePosY, partialTicks);
    }

    public void setBlackBackground() {
        super.setBlackBackground();
        if (AsmodeusConfig.enableImgOnGalaxyMap) {
            GL11.glPushMatrix();
            this.enableGrid = false;
            this.setImgBackground(guiImg);
            GL11.glPopMatrix();
        }
    }

    public void drawGrid(float gridSize, float gridScale) {
        if (this.enableGrid) {
            super.drawGrid(gridSize, gridScale);
        }
    }

    public void drawCircles() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        int count = 0;
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        for (CelestialBody body : this.bodiesToRender) {
            Vector3f systemOffset = new Vector3f(0.0f, 0.0f, 0.0f);
            if (body instanceof IChildBody) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((IChildBody)body).getParentPlanet());
            } else if (body instanceof Planet) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Planet)body).getParentSolarSystem().getMainStar());
            } else if (body instanceof Star) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
            } else if (body instanceof ICelestialRegistry && !(body instanceof IChildBody)) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((ICelestialRegistry)body).getParentSolarSystem().getMainStar());
            }
            float orbit_ext_x = body instanceof IExBody ? ((IExBody)body).getXOrbitEccentricity() : 1.0f;
            float orbit_ext_y = body instanceof IExBody ? ((IExBody)body).getYOrbitEccentricity() : 1.0f;
            float orbit_offset_x = body instanceof IExBody ? ((IExBody)body).getXOrbitOffset() : 0.0f;
            float orbit_offset_y = body instanceof IExBody ? ((IExBody)body).getYOrbitOffset() : 0.0f;
            float x = this.getScale(body);
            float y = 0.0f;
            float alpha = this.getAlpha(body);
            if (!(alpha > 0.0f)) continue;
            switch (count % 2) {
                case 0: {
                    GL11.glColor4f((float)0.0f, (float)0.2857143f, (float)0.64285713f, (float)(alpha / 2.4f));
                    break;
                }
                case 1: {
                    GL11.glColor4f((float)0.0f, (float)0.4f, (float)0.9f, (float)(alpha / 2.4f));
                }
            }
            if (body.equals((Object)this.selectedBody)) {
                GL11.glColor4f((float)0.0f, (float)0.4f, (float)0.9f, (float)1.0f);
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre(body, systemOffset);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            if (!preEvent.isCanceled()) {
                GL11.glTranslatef((float)systemOffset.x, (float)systemOffset.y, (float)systemOffset.z);
                GL11.glBegin((int)2);
                for (int i = 0; i < 90; ++i) {
                    GL11.glVertex2f((float)((x + orbit_offset_x) * (orbit_ext_x > 0.0f ? orbit_ext_x : 1.0f)), (float)((y + orbit_offset_y) * (orbit_ext_y > 0.0f ? orbit_ext_y : 1.0f)));
                    float temp = x;
                    x = cos * x - sin * y;
                    y = sin * temp + cos * y;
                }
                GL11.glEnd();
                GL11.glTranslatef((float)(-systemOffset.x), (float)(-systemOffset.y), (float)(-systemOffset.z));
                ++count;
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Post postEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post(body);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
        }
        GL11.glLineWidth((float)1.0f);
        if (this.selectedBody instanceof Star) {
            this.drawAgeCircle();
        }
    }

    public void drawButtons(int mousePosX, int mousePosY) {
        super.drawButtons(mousePosX, mousePosY);
        int LHS = BORDER_SIZE + BORDER_EDGE_SIZE;
        int RHS = this.field_146294_l - LHS;
        int TOP = LHS;
        int BOT = this.field_146295_m - LHS;
        if (this.selectedBody != null) {
            this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            int sliderPos = this.zoomTooltipPos;
            if (this.zoomTooltipPos != 125) {
                this.zoomTooltipPos = sliderPos = (int)Math.min(this.ticksSinceSelectionF * 8.0f, 125.0f);
            }
            int menuTopLeft = LHS + 100;
            int posX = RHS - sliderPos;
            this.drawTexturedModalRect(posX - 7, menuTopLeft + 13, 133, 120, 0, 79, 264, 182, true, false);
            this.drawTexturedModalRect(posX - 7, menuTopLeft + 153, 133, 17, 0, 472, 266, 40, true, false);
        }
    }

    private void drawAgeCircle() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        CelestialBody body = this.selectedBody;
        Vector3f systemOffset = new Vector3f(0.0f, 0.0f, 0.0f);
        systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
        float x = 1000.0f;
        float y = 0.0f;
        GL11.glTranslatef((float)systemOffset.x, (float)systemOffset.y, (float)systemOffset.z);
        for (int count_rings = 1; count_rings < 5; ++count_rings) {
            x = 1000 * count_rings;
            GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.5f);
            GL11.glBegin((int)2);
            for (int i = 0; i < 90; ++i) {
                GL11.glVertex2f((float)(x * 1.0f), (float)(y * 1.0f));
                float temp = x;
                x = cos * x - sin * y;
                y = sin * temp + cos * y;
            }
            GL11.glEnd();
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b((int)(x / 1000.0f) * 5 + " l.y.", (int)x, (int)y, 0xFFFFFF);
            GL11.glDisable((int)3553);
            GlStateManager.func_179121_F();
        }
        GL11.glTranslatef((float)(-systemOffset.x), (float)(-systemOffset.y), (float)(-systemOffset.z));
        GL11.glLineWidth((float)1.0f);
    }

    private void setImgBackground(ResourceLocation galaxy) {
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glTranslated((double)-40.0, (double)-40.0, (double)0.0);
        GL11.glTranslated((double)this.xImgOffset, (double)this.yImgOffset, (double)0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(galaxy);
        int width = Display.getWidth();
        int height = Display.getHeight();
        this.drawTexturedModalRect(0.0f, 0.0f, width, height, 0.0f, 0.0f, width * 2, height * 2, false, false, 1024.0f, 1024.0f);
        ResourceLocation guiImg_2 = new ResourceLocation("asmodeuscore", "textures/gui/galaxymap_nebula_" + this.nebula_img + ".png");
        this.field_146297_k.field_71446_o.func_110577_a(guiImg_2);
        GL11.glTranslated((double)(this.xImgOffset * 1.5), (double)(this.yImgOffset * 1.5), (double)0.0);
        GL11.glColor4f((float)0.5f, (float)0.4f, (float)this.nebula_color.floatZ(), (float)0.5f);
        this.drawTexturedModalRect(0.0f, 0.0f, width, height, 0.0f, 0.0f, 1024.0f, 1024.0f, false, false, 1024.0f, 1024.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected Vector3f getCelestialBodyPosition(CelestialBody cBody) {
        if (cBody == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (cBody instanceof Star) {
            if (cBody.getUnlocalizedName().equalsIgnoreCase("star.sol")) {
                return new Vector3f();
            }
            return ((Star)cBody).getParentSolarSystem().getMapPosition().toVector3f();
        }
        float timeScale = cBody instanceof Planet ? 200.0f : 2.0f;
        float orbit_ext_x = cBody instanceof IExBody ? ((IExBody)cBody).getXOrbitEccentricity() : 1.0f;
        float orbit_ext_y = cBody instanceof IExBody ? ((IExBody)cBody).getYOrbitEccentricity() : 1.0f;
        float orbit_offset_x = cBody instanceof IExBody ? ((IExBody)cBody).getXOrbitOffset() : 0.0f;
        float orbit_offset_y = cBody instanceof IExBody ? ((IExBody)cBody).getYOrbitOffset() : 0.0f;
        float distanceFromCenter = this.getScale(cBody);
        float x = (float)Math.sin(this.ticksTotalF / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter;
        float y = (float)Math.cos(this.ticksTotalF / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter;
        Vector3f cBodyPos = new Vector3f((x + orbit_offset_x) * (orbit_ext_x > 0.0f ? orbit_ext_x : 1.0f), (y + orbit_offset_y) * (orbit_ext_y > 0.0f ? orbit_ext_y : 1.0f), 0.0f);
        if (cBody instanceof Planet) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((Planet)cBody).getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        if (cBody instanceof IChildBody) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((IChildBody)cBody).getParentPlanet());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        if (cBody instanceof ICelestialRegistry) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((ICelestialRegistry)cBody).getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        return cBodyPos;
    }

    protected float getScale(CelestialBody celestialBody) {
        float scale = 0.2f;
        if (celestialBody instanceof Planet) {
            scale = 25.0f;
        }
        if (celestialBody instanceof ICelestialRegistry && !((ICelestialRegistry)celestialBody instanceof IChildBody)) {
            scale = 25.0f;
        }
        return 3.0f * celestialBody.getRelativeDistanceFromCenter().unScaledDistance * scale;
    }

    private void refreshBodies() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.bodiesToRender.clear();
        this.galaxylist.clear();
        this.starlist.clear();
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            if (!this.galaxylist.contains(solarSystem.getUnlocalizedParentGalaxyName())) {
                this.galaxylist.add(solarSystem.getUnlocalizedParentGalaxyName());
            }
            if (!solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                if (!UtilsGC.hasUnlocks(player, solarSystem)) continue;
                if (solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) {
                    this.starlist.add(solarSystem);
                }
                this.bodiesToRender.add(solarSystem.getMainStar());
                continue;
            }
            if (solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) {
                this.starlist.add(solarSystem);
            }
            this.bodiesToRender.add(solarSystem.getMainStar());
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (!planet.getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                if (!UtilsGC.isReasearched(player, (CelestialBody)planet)) continue;
                this.bodiesToRender.add(planet);
                continue;
            }
            this.bodiesToRender.add(planet);
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (!moon.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                if (!UtilsGC.isReasearched(player, (CelestialBody)moon.getParentPlanet()) || !UtilsGC.isReasearched(player, (CelestialBody)moon)) continue;
                this.bodiesToRender.add(moon);
                continue;
            }
            this.bodiesToRender.add(moon);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (!satellite.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                if (!UtilsGC.isReasearched(player, (CelestialBody)satellite.getParentPlanet())) continue;
                this.bodiesToRender.add(satellite);
                continue;
            }
            this.bodiesToRender.add(satellite);
        }
        for (Map map : BodiesRegistry.getBodies()) {
            for (CelestialBody body : map.values()) {
                if (!(body instanceof ICelestialRegistry)) continue;
                if (body instanceof IChildBody) {
                    if (!((IChildBody)body).getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy) || !((ICelestialRegistry)body).canRegistry()) continue;
                    this.bodiesToRender.add(body);
                    continue;
                }
                if (!((ICelestialRegistry)body).getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy) || !((ICelestialRegistry)body).canRegistry()) continue;
                this.bodiesToRender.add(body);
            }
        }
        Collections.sort(this.starlist, new Comparator<SolarSystem>(){

            @Override
            public int compare(SolarSystem lhs, SolarSystem rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
    }

    protected List<CelestialBody> getChildren(Object object) {
        return this.getChildren(object, 0, 0, false);
    }

    protected List<CelestialBody> getChildren(Object object, int start, int size) {
        return this.getChildren(object, start, size, false);
    }

    protected List<CelestialBody> getChildren(Object object, int start, int size, boolean check) {
        List<CelestialBody> bodies;
        ArrayList bodyList = Lists.newArrayList();
        SpaceData.refreshGalaxies();
        if (object instanceof Planet) {
            List moons = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                for (Object moon : moons) {
                    if (!UtilsGC.isReasearched(this.field_146297_k.field_71439_g, (CelestialBody)moon)) continue;
                    bodyList.add(moon);
                }
            } else {
                bodyList.addAll(moons);
            }
            bodies = SpaceData.getMoonsForPlanet((Planet)object);
            for (CelestialBody body : bodies) {
                if (!(body instanceof ICelestialRegistry) || !(body instanceof IChildBody)) continue;
                bodyList.add(body);
            }
        } else if (object instanceof SolarSystem) {
            List planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                for (Object planet : planets) {
                    if (!UtilsGC.isReasearched(this.field_146297_k.field_71439_g, (CelestialBody)planet)) continue;
                    bodyList.add(planet);
                }
            } else {
                bodyList.addAll(planets);
            }
            bodies = SpaceData.getBodiesForSolarSystem((SolarSystem)object);
            for (CelestialBody body : bodies) {
                if (!(body instanceof ICelestialRegistry) || body instanceof IChildBody) continue;
                bodyList.add(body);
            }
        }
        Collections.sort(bodyList);
        if (check) {
            ArrayList doneList = Lists.newArrayList();
            int startPos = start;
            int getSize = size;
            if (startPos >= bodyList.size()) {
                startPos = 0;
            }
            if (getSize >= bodyList.size()) {
                getSize = bodyList.size();
            }
            for (int i = 0; i < getSize; ++i) {
                doneList.add(i, bodyList.get(i + startPos));
            }
            return doneList;
        }
        return bodyList;
    }
}

