/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.grid;

import buildcraft.api.mj.IMjReceiver;
import cofh.redstoneflux.api.IEnergyReceiver;
import ic2.api.energy.tile.IEnergySink;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.energy.IStrictEnergyAcceptor;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.grid.NetworkFinder;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLLog;

public class EnergyNetwork
implements IElectricityNetwork {
    private boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded() && !EnergyConfigHandler.disableMekanismOutput;
    private boolean isRF1Loaded = EnergyConfigHandler.isRFAPIv1Loaded() && !EnergyConfigHandler.disableRFOutput;
    private boolean isRF2Loaded = EnergyConfigHandler.isRFAPIv2Loaded() && !EnergyConfigHandler.disableRFOutput;
    private boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded() && !EnergyConfigHandler.disableIC2Output;
    private boolean isFELoaded = !EnergyConfigHandler.disableFEOutput;
    private boolean isBCLoaded = EnergyConfigHandler.isBuildcraftLoaded() && !EnergyConfigHandler.disableBuildCraftOutput;
    public static int tickCount = 0;
    private int tickDone = -1;
    private float totalRequested = 0.0f;
    private float totalStorageExcess = 0.0f;
    private float totalEnergy = 0.0f;
    private float totalSent = 0.0f;
    private boolean doneScheduled = false;
    private boolean spamstop = false;
    private boolean loopPrevention = false;
    public int networkTierGC = 1;
    private int producersTierGC = 1;
    private List<Object> connectedAcceptors = new LinkedList<Object>();
    private List<EnumFacing> connectedDirections = new LinkedList<EnumFacing>();
    private Set<Object> availableAcceptors = new HashSet<Object>();
    private Map<Object, EnumFacing> availableconnectedDirections = new HashMap<Object, EnumFacing>();
    private Map<Object, Float> energyRequests = new HashMap<Object, Float>();
    private List<TileEntity> ignoreAcceptors = new LinkedList<TileEntity>();
    private final Set<IConductor> conductors = new HashSet<IConductor>();
    private static final float ENERGY_STORAGE_LEVEL = 200.0f;

    @Override
    public Set<IConductor> getTransmitters() {
        return this.conductors;
    }

    @Override
    public float getRequest(TileEntity ... ignoreTiles) {
        if (tickCount != this.tickDone) {
            this.ignoreAcceptors.clear();
            this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
            this.doTickStartCalc();
        }
        return this.totalRequested - this.totalEnergy - this.totalSent;
    }

    @Override
    public float produce(float energy, boolean doReceive, int producerTier, TileEntity ... ignoreTiles) {
        if (this.loopPrevention) {
            return energy;
        }
        if (energy > 0.0f) {
            if (tickCount != this.tickDone) {
                this.tickDone = tickCount;
                this.ignoreAcceptors.clear();
                this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
                this.producersTierGC = 1;
                this.doTickStartCalc();
            } else {
                this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
            }
            if (!this.doneScheduled && this.totalRequested > 0.0f) {
                TickHandlerServer.scheduleNetworkTick(this);
                this.doneScheduled = true;
            }
            float totalEnergyLast = this.totalEnergy;
            if (doReceive) {
                this.totalEnergy += Math.min(energy, this.totalRequested - totalEnergyLast);
                if (producerTier > this.producersTierGC) {
                    this.producersTierGC = producerTier;
                }
            }
            if (this.totalRequested >= totalEnergyLast + energy) {
                return 0.0f;
            }
            if (totalEnergyLast >= this.totalRequested) {
                return energy;
            }
            return totalEnergyLast + energy - this.totalRequested;
        }
        return energy;
    }

    public void tickEnd() {
        this.doneScheduled = false;
        this.loopPrevention = true;
        if (this.totalEnergy > 0.0f) {
            this.doTickStartCalc();
            if (this.totalRequested > 0.0f) {
                this.totalSent = this.doProduce();
                this.totalEnergy = this.totalSent < this.totalEnergy ? (this.totalEnergy -= this.totalSent) : 0.0f;
            } else {
                this.totalEnergy = 0.0f;
            }
        } else {
            this.totalEnergy = 0.0f;
        }
        this.loopPrevention = false;
    }

    private void doTickStartCalc() {
        this.tickDone = tickCount;
        this.totalSent = 0.0f;
        this.refreshAcceptors();
        if (!EnergyUtil.initialisedIC2Methods) {
            EnergyUtil.initialiseIC2Methods();
        }
        if (this.conductors.size() == 0) {
            return;
        }
        this.loopPrevention = true;
        this.availableAcceptors.clear();
        this.availableconnectedDirections.clear();
        this.energyRequests.clear();
        this.totalRequested = 0.0f;
        this.totalStorageExcess = 0.0f;
        if (!this.connectedAcceptors.isEmpty()) {
            Iterator<EnumFacing> acceptorDirection = this.connectedDirections.iterator();
            for (Object acceptor : this.connectedAcceptors) {
                IEnergyStorage forgeEnergy;
                EnumFacing sideFrom = acceptorDirection.next();
                if (this.ignoreAcceptors.contains(acceptor) || this.availableAcceptors.contains(acceptor)) continue;
                float e = 0.0f;
                if (acceptor instanceof IElectrical) {
                    e = ((IElectrical)acceptor).getRequest(sideFrom);
                } else if (this.isMekLoaded && acceptor instanceof IStrictEnergyAcceptor) {
                    e = (float)(((IStrictEnergyAcceptor)acceptor).acceptEnergy(sideFrom, 1000000.0, true) / (double)EnergyConfigHandler.TO_MEKANISM_RATIO);
                } else if (this.isIC2Loaded && acceptor instanceof IEnergySink) {
                    double result;
                    block17: {
                        result = 0.0;
                        try {
                            result = (Double)EnergyUtil.demandedEnergyIC2.invoke(acceptor, new Object[0]);
                        }
                        catch (Exception ex) {
                            if (!ConfigManagerCore.enableDebug) break block17;
                            ex.printStackTrace();
                        }
                    }
                    result = Math.min(result, (double)this.networkTierGC * 128.0);
                    e = (float)result / EnergyConfigHandler.TO_IC2_RATIO;
                } else if (this.isBCLoaded && acceptor instanceof IMjReceiver) {
                    long bcDemand = ((IMjReceiver)acceptor).getPowerRequested();
                    bcDemand = Math.min(bcDemand, (long)(this.networkTierGC * this.networkTierGC) * 16000000L);
                    e = (float)bcDemand / EnergyConfigHandler.TO_BC_RATIO;
                } else if (this.isRF2Loaded && acceptor instanceof IEnergyReceiver) {
                    e = (float)((IEnergyReceiver)acceptor).receiveEnergy(sideFrom, Integer.MAX_VALUE, true) / EnergyConfigHandler.TO_RF_RATIO;
                } else if (this.isFELoaded && acceptor instanceof IEnergyStorage && (forgeEnergy = (IEnergyStorage)acceptor).canReceive()) {
                    e = (float)forgeEnergy.receiveEnergy(Integer.MAX_VALUE, true) / EnergyConfigHandler.TO_RF_RATIO;
                }
                if (!(e > 0.0f)) continue;
                this.availableAcceptors.add(acceptor);
                this.availableconnectedDirections.put(acceptor, sideFrom);
                this.energyRequests.put(acceptor, Float.valueOf(e));
                this.totalRequested += e;
                if (!(e > 200.0f)) continue;
                this.totalStorageExcess += e - 200.0f;
            }
        }
        this.loopPrevention = false;
    }

    private float doProduce() {
        float returnvalue;
        float sent;
        block31: {
            sent = 0.0f;
            if (!this.availableAcceptors.isEmpty()) {
                float energyNeeded = this.totalRequested;
                float energyAvailable = this.totalEnergy;
                float reducor = 1.0f;
                float energyStorageReducor = 1.0f;
                if (energyNeeded > energyAvailable) {
                    if ((energyNeeded -= this.totalStorageExcess) > energyAvailable) {
                        energyStorageReducor = 0.0f;
                        reducor = energyAvailable / energyNeeded;
                    } else {
                        energyStorageReducor = (energyAvailable - energyNeeded) / this.totalStorageExcess;
                    }
                }
                int tierProduced = Math.min(this.producersTierGC, this.networkTierGC);
                Object debugTE = null;
                try {
                    Iterator<Object> iterator = this.availableAcceptors.iterator();
                    while (iterator.hasNext()) {
                        float sentToAcceptor;
                        Object tileEntity;
                        debugTE = tileEntity = iterator.next();
                        if (sent >= energyAvailable) break;
                        float currentSending = this.energyRequests.get(tileEntity).floatValue();
                        if (currentSending > 200.0f) {
                            currentSending = 200.0f + (currentSending - 200.0f) * energyStorageReducor;
                        }
                        if ((currentSending *= reducor) > energyAvailable - sent) {
                            currentSending = energyAvailable - sent;
                        }
                        EnumFacing sideFrom = this.availableconnectedDirections.get(tileEntity);
                        if (tileEntity instanceof IElectrical) {
                            sentToAcceptor = ((IElectrical)tileEntity).receiveElectricity(sideFrom, currentSending, tierProduced, true);
                        } else if (this.isMekLoaded && tileEntity instanceof IStrictEnergyAcceptor) {
                            sentToAcceptor = (float)((IStrictEnergyAcceptor)tileEntity).acceptEnergy(sideFrom, (double)(currentSending * EnergyConfigHandler.TO_MEKANISM_RATIO), false) / EnergyConfigHandler.TO_MEKANISM_RATIO;
                        } else if (this.isIC2Loaded && tileEntity instanceof IEnergySink) {
                            double energySendingIC2 = currentSending * EnergyConfigHandler.TO_IC2_RATIO;
                            if (energySendingIC2 >= 1.0) {
                                double result;
                                block32: {
                                    result = 0.0;
                                    try {
                                        result = EnergyUtil.voltageParameterIC2 ? ((Double)EnergyUtil.injectEnergyIC2.invoke(tileEntity, sideFrom.func_176734_d(), energySendingIC2, 120.0)).doubleValue() : ((Double)EnergyUtil.injectEnergyIC2.invoke(tileEntity, sideFrom.func_176734_d(), energySendingIC2)).doubleValue();
                                    }
                                    catch (Exception ex) {
                                        if (!ConfigManagerCore.enableDebug) break block32;
                                        ex.printStackTrace();
                                    }
                                }
                                sentToAcceptor = currentSending - (float)result / EnergyConfigHandler.TO_IC2_RATIO;
                                if (sentToAcceptor < 0.0f) {
                                    sentToAcceptor = 0.0f;
                                }
                            } else {
                                sentToAcceptor = 0.0f;
                            }
                        } else if (this.isBCLoaded && tileEntity instanceof IMjReceiver) {
                            long toSendBC = (long)(currentSending * EnergyConfigHandler.TO_BC_RATIO);
                            sentToAcceptor = (float)(toSendBC - ((IMjReceiver)tileEntity).receivePower(toSendBC, false)) / EnergyConfigHandler.TO_BC_RATIO;
                        } else if (this.isRF2Loaded && tileEntity instanceof IEnergyReceiver) {
                            int currentSendinginRF = currentSending >= 2.1474836E9f / EnergyConfigHandler.TO_RF_RATIO ? Integer.MAX_VALUE : (int)(currentSending * EnergyConfigHandler.TO_RF_RATIO);
                            sentToAcceptor = (float)((IEnergyReceiver)tileEntity).receiveEnergy(sideFrom, currentSendinginRF, false) / EnergyConfigHandler.TO_RF_RATIO;
                        } else if (this.isFELoaded && tileEntity instanceof IEnergyStorage) {
                            int currentSendinginRF = currentSending >= 2.1474836E9f / EnergyConfigHandler.TO_RF_RATIO ? Integer.MAX_VALUE : (int)(currentSending * EnergyConfigHandler.TO_RF_RATIO);
                            sentToAcceptor = (float)((IEnergyStorage)tileEntity).receiveEnergy(currentSendinginRF, false) / EnergyConfigHandler.TO_RF_RATIO;
                        } else {
                            sentToAcceptor = 0.0f;
                        }
                        if (sentToAcceptor / currentSending > 1.002f && sentToAcceptor > 0.01f) {
                            if (!this.spamstop) {
                                FMLLog.info((String)("Energy network: acceptor took too much energy, offered " + currentSending + ", took " + sentToAcceptor + ". " + tileEntity.toString()), (Object[])new Object[0]);
                                this.spamstop = true;
                            }
                            sentToAcceptor = currentSending;
                        }
                        sent += sentToAcceptor;
                    }
                }
                catch (Exception e) {
                    GCLog.error("DEBUG Energy network loop issue, please report this", new Object[0]);
                    if (!(debugTE instanceof TileEntity)) break block31;
                    GCLog.error("Problem was likely caused by tile in dim " + GCCoreUtil.getDimensionID(((TileEntity)debugTE).func_145831_w()) + " at " + ((TileEntity)debugTE).func_174877_v() + " Type:" + debugTE.getClass().getSimpleName(), new Object[0]);
                }
            }
        }
        if (tickCount % 200 == 0) {
            this.spamstop = false;
        }
        if ((returnvalue = sent) > this.totalEnergy) {
            returnvalue = this.totalEnergy;
        }
        if (returnvalue < 0.0f) {
            returnvalue = 0.0f;
        }
        return returnvalue;
    }

    public void refreshWithChecks() {
        int tierfound = Integer.MAX_VALUE;
        Iterator<IConductor> it = this.conductors.iterator();
        while (it.hasNext()) {
            IConductor conductor = it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            TileEntity tile = (TileEntity)conductor;
            World world = tile.func_145831_w();
            if (tile.func_145837_r() || world == null || !world.func_175667_e(tile.func_174877_v())) {
                it.remove();
                continue;
            }
            if (conductor != world.func_175625_s(tile.func_174877_v())) {
                it.remove();
                continue;
            }
            if (conductor.getTierGC() < tierfound) {
                tierfound = conductor.getTierGC();
            }
            if (conductor.getNetwork() == this) continue;
            conductor.setNetwork(this);
            conductor.onNetworkChanged();
        }
        if (tierfound == Integer.MAX_VALUE) {
            tierfound = 1;
        }
        this.networkTierGC = tierfound;
    }

    @Override
    public void refresh() {
        int tierfound = Integer.MAX_VALUE;
        Iterator<IConductor> it = this.conductors.iterator();
        while (it.hasNext()) {
            IConductor conductor = it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            TileEntity tile = (TileEntity)conductor;
            World world = tile.func_145831_w();
            if (tile.func_145837_r() || world == null) {
                it.remove();
                continue;
            }
            if (conductor.getTierGC() < tierfound) {
                tierfound = conductor.getTierGC();
            }
            if (conductor.getNetwork() == this) continue;
            conductor.setNetwork(this);
            conductor.onNetworkChanged();
        }
        if (tierfound == Integer.MAX_VALUE) {
            tierfound = 1;
        }
        this.networkTierGC = tierfound;
    }

    private void refreshAcceptors() {
        this.connectedAcceptors.clear();
        this.connectedDirections.clear();
        this.refreshWithChecks();
        try {
            LinkedList<IConductor> conductorsCopy = new LinkedList<IConductor>();
            conductorsCopy.addAll(this.conductors);
            for (IConductor conductor : conductorsCopy) {
                EnergyUtil.setAdjacentPowerConnections((TileEntity)conductor, this.connectedAcceptors, this.connectedDirections);
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"GC Aluminium Wire: Error when testing whether another mod's tileEntity can accept energy.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public IElectricityNetwork merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            Set<IConductor> thisNetwork = this.conductors;
            Set thatNetwork = network.getTransmitters();
            if (thisNetwork.size() >= thatNetwork.size()) {
                thisNetwork.addAll(thatNetwork);
                this.refresh();
                if (network instanceof EnergyNetwork) {
                    ((EnergyNetwork)network).destroy();
                }
                return this;
            }
            thatNetwork.addAll(thisNetwork);
            network.refresh();
            this.destroy();
            return network;
        }
        return this;
    }

    private void destroy() {
        this.conductors.clear();
        this.connectedAcceptors.clear();
        this.availableAcceptors.clear();
        this.totalEnergy = 0.0f;
        this.totalRequested = 0.0f;
        TickHandlerServer.removeNetworkTick(this);
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.getTransmitters().remove(splitPoint);
            splitPoint.setNetwork(null);
            if (this.getTransmitters().size() > 1) {
                World world = ((TileEntity)splitPoint).func_145831_w();
                if (this.getTransmitters().size() > 0) {
                    TileEntity[] nextToSplit = new TileEntity[6];
                    boolean[] toDo = new boolean[]{true, true, true, true, true, true};
                    BlockPos pos = ((TileEntity)splitPoint).func_174877_v();
                    for (int j = 0; j < 6; ++j) {
                        TileEntity tileEntity;
                        switch (j) {
                            case 0: {
                                tileEntity = world.func_175625_s(pos.func_177977_b());
                                break;
                            }
                            case 1: {
                                tileEntity = world.func_175625_s(pos.func_177984_a());
                                break;
                            }
                            case 2: {
                                tileEntity = world.func_175625_s(pos.func_177978_c());
                                break;
                            }
                            case 3: {
                                tileEntity = world.func_175625_s(pos.func_177968_d());
                                break;
                            }
                            case 4: {
                                tileEntity = world.func_175625_s(pos.func_177976_e());
                                break;
                            }
                            case 5: {
                                tileEntity = world.func_175625_s(pos.func_177974_f());
                                break;
                            }
                            default: {
                                tileEntity = null;
                            }
                        }
                        if (tileEntity instanceof IConductor && ((IConductor)tileEntity).canConnect(EnumFacing.func_82600_a((int)(j ^ 1)), NetworkType.POWER)) {
                            nextToSplit[j] = tileEntity;
                            continue;
                        }
                        toDo[j] = false;
                    }
                    for (int i1 = 0; i1 < 6; ++i1) {
                        if (!toDo[i1]) continue;
                        TileEntity connectedBlockA = nextToSplit[i1];
                        NetworkFinder finder = new NetworkFinder(world, new BlockVec3(connectedBlockA), new BlockVec3(pos));
                        List<IConductor> partNetwork = finder.exploreNetwork();
                        for (int i2 = i1 + 1; i2 < 6; ++i2) {
                            TileEntity connectedBlockB = nextToSplit[i2];
                            if (!toDo[i2] || !partNetwork.contains(connectedBlockB)) continue;
                            toDo[i2] = false;
                        }
                        EnergyNetwork newNetwork = new EnergyNetwork();
                        newNetwork.getTransmitters().addAll(partNetwork);
                        newNetwork.refreshWithChecks();
                    }
                    this.destroy();
                }
            } else if (this.getTransmitters().size() == 0) {
                this.destroy();
            }
        }
    }

    public String toString() {
        return "EnergyNetwork[" + this.hashCode() + "|Wires:" + this.getTransmitters().size() + "|Acceptors:" + this.connectedAcceptors.size() + "]";
    }
}

