/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.EnumMap;
import micdoodle8.mods.galacticraft.core.network.GalacticraftPacketHandler;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.network.PacketDynamicInventory;
import micdoodle8.mods.galacticraft.core.network.PacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.PacketFluidNetworkUpdate;
import micdoodle8.mods.galacticraft.core.network.PacketRotateRocket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class GalacticraftChannelHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;

    private GalacticraftChannelHandler() {
        this.addDiscriminator(0, PacketSimple.class);
        this.addDiscriminator(1, PacketRotateRocket.class);
        this.addDiscriminator(2, PacketDynamic.class);
        this.addDiscriminator(3, PacketFluidNetworkUpdate.class);
        this.addDiscriminator(4, PacketEntityUpdate.class);
        this.addDiscriminator(5, PacketDynamicInventory.class);
    }

    public static GalacticraftChannelHandler init() {
        GalacticraftChannelHandler channelHandler = new GalacticraftChannelHandler();
        channelHandler.channels = NetworkRegistry.INSTANCE.newChannel("galacticraftcore", new ChannelHandler[]{channelHandler, new GalacticraftPacketHandler()});
        return channelHandler;
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket msg, ByteBuf target) throws Exception {
        msg.encodeInto(target);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket msg) {
        try {
            msg.decodeInto(source);
        }
        catch (IndexOutOfBoundsException ex) {
            FMLLog.severe((String)("Incomplete Galacticraft entity packet: dimension " + msg.getDimensionID()), (Object[])new Object[0]);
        }
    }

    public void sendToAll(IPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendTo(IPacket message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToAllAround(IPacket message, NetworkRegistry.TargetPoint point) {
        try {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
        catch (Exception e) {
            GCLog.error("Forge error when sending network packet to nearby players - this is not a Galacticraft bug, does another mod make fake players?", new Object[0]);
            e.printStackTrace();
        }
    }

    public void sendToDimension(IPacket message, int dimensionID) {
        try {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionID);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
        catch (Exception e) {
            GCLog.error("Forge error when sending network packet to all players in dimension - this is not a Galacticraft bug, does another mod make fake players?", new Object[0]);
            e.printStackTrace();
        }
    }

    public void sendToServer(IPacket message) {
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return;
        }
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeOutbound(new Object[]{message});
    }
}

