/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenMinableMeta
extends WorldGenMinable {
    private final Block minableBlockId;
    private final int numberOfBlocks;
    private final int metadata;
    private boolean usingMetadata = false;
    private final Block fillerID;
    private final int fillerMetadata;

    public WorldGenMinableMeta(Block placeBlock, int blockCount, int placeMeta, boolean metaActive, Block replaceBlock, int replaceMeta) {
        super(placeBlock.func_176203_a(placeMeta), blockCount, (Predicate)BlockMatcher.func_177642_a((Block)replaceBlock));
        this.minableBlockId = placeBlock;
        this.numberOfBlocks = blockCount;
        this.metadata = placeMeta;
        this.usingMetadata = metaActive;
        this.fillerID = replaceBlock;
        this.fillerMetadata = replaceMeta;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        float f = rand.nextFloat() * (float)Math.PI;
        float sinFvalue = MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
        float cosFvalue = MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
        float chunkCentreX = position.func_177958_n() + 8;
        float chunkCentreZ = position.func_177952_p() + 8;
        double clumpXa = chunkCentreX + sinFvalue;
        double clumpXb = (double)(chunkCentreX - sinFvalue) - clumpXa;
        double clumpZa = chunkCentreZ + cosFvalue;
        double clumpZb = (double)(chunkCentreZ - cosFvalue) - clumpZa;
        double clumpYa = position.func_177956_o() + rand.nextInt(3) - 2;
        double clumpYb = (double)(position.func_177956_o() + rand.nextInt(3) - 2) - clumpYa;
        IBlockState oreState = this.minableBlockId.func_176203_a(this.usingMetadata ? this.metadata : 0);
        float concentricRadius = this.numberOfBlocks;
        double size = (rand.nextDouble() * (double)this.numberOfBlocks + 1.0) / 16.0;
        for (int i = 0; i < this.numberOfBlocks; ++i) {
            double sizeXZ;
            float f1 = (float)i / concentricRadius;
            double centreX = clumpXa + clumpXb * (double)f1;
            double centreY = clumpYa + clumpYb * (double)f1;
            double centreZ = clumpZa + clumpZb * (double)f1;
            double sizeY = sizeXZ = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * size + 1.0) / 2.0;
            int xmin = MathHelper.func_76128_c((double)(centreX - sizeXZ));
            int xmax = MathHelper.func_76128_c((double)(centreX + sizeXZ));
            int ymin = MathHelper.func_76128_c((double)(centreY - sizeY));
            int ymax = MathHelper.func_76128_c((double)(centreY + sizeY));
            int zmin = MathHelper.func_76128_c((double)(centreZ - sizeXZ));
            int zmax = MathHelper.func_76128_c((double)(centreZ + sizeXZ));
            centreX -= 0.5;
            centreY -= 0.5;
            centreZ -= 0.5;
            for (int x = xmin; x <= xmax; ++x) {
                double dx = ((double)x - centreX) / sizeXZ;
                if (!(dx * dx < 1.0)) continue;
                for (int y = ymin; y <= ymax; ++y) {
                    double dy = ((double)y - centreY) / sizeY;
                    double xySquared = dx * dx + dy * dy;
                    if (!(xySquared < 1.0)) continue;
                    for (int z = zmin; z <= zmax; ++z) {
                        BlockPos blockpos;
                        IBlockState state;
                        double dz = ((double)z - centreZ) / sizeXZ;
                        if (!(xySquared + dz * dz < 1.0) || (state = worldIn.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c() != this.fillerID || state.func_177230_c().func_176201_c(state) != this.fillerMetadata) continue;
                        worldIn.func_180501_a(blockpos, oreState, 2);
                    }
                }
            }
        }
        return true;
    }
}

