/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.fluid.NetworkHelper;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidItems;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemAtmosphericValve;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMarsT2;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityMethaneSynthesizer
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IFluidHandlerWrapper {
    private final int tankCapacity = 4000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank gasTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank gasTank2 = new FluidTank(this.tankCapacity / 2);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank = new FluidTank(this.tankCapacity / 2);
    public int processTimeRequired = 3;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = -8;
    private int hasCO2 = -1;
    private boolean noCoal = true;
    private int coalPartial = 0;

    public TileEntityMethaneSynthesizer() {
        super("tile.mars_machine.5.name");
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 45.0f);
        this.setTierGC(2);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (EnergyUtil.checkMekGasHandler(capability)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        if (EnergyUtil.checkMekGasHandler(capability)) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.hasCO2 == -1) {
            this.hasCO2 = this.getAirProducts();
        }
        if (!this.field_145850_b.field_72995_K) {
            IBlockState stateAbove;
            Block blockAbove;
            ItemStack inputCanister;
            if (this.hasCO2 == 0 && this.gasTank2.getFluidAmount() > 0) {
                this.gasTank2.drain(this.gasTank2.getFluidAmount(), true);
            }
            if (!(inputCanister = (ItemStack)this.getInventory().get(2)).func_190926_b() && inputCanister.func_77973_b() instanceof ItemAtmosphericValve && this.hasCO2 > 0 && this.gasTank2.getFluidAmount() < this.gasTank2.getCapacity() && (blockAbove = (stateAbove = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a())).func_177230_c()).func_149688_o(stateAbove) == Material.field_151579_a && blockAbove != GCBlocks.breatheableAir && blockAbove != GCBlocks.brightBreatheableAir && !OxygenUtil.inOxygenBubble((World)this.field_145850_b, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 1.0), (double)((double)this.func_174877_v().func_177952_p() + 0.5))) {
                FluidStack gcAtmosphere = FluidRegistry.getFluidStack((String)"carbondioxide", (int)4);
                this.gasTank2.fill(gcAtmosphere, true);
            }
            this.checkFluidTankTransfer(4, this.liquidTank);
            if (this.hasEnoughEnergyToRun && this.canProcess()) {
                if (this.tierGC == 2) {
                    this.processTimeRequired = Math.max(1, 4 - this.poweredByTierGC);
                }
                if (this.processTicks <= 0) {
                    this.processTicks = this.processTimeRequired;
                } else if (--this.processTicks <= 0) {
                    this.doLiquefaction();
                    this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                }
            } else if (this.processTicks > 0) {
                this.processTicks = 0;
            } else if (--this.processTicks <= -8) {
                this.processTicks = -8;
            }
            this.produceOutput(this.getHydrogenInputDirection().func_176734_d());
        }
    }

    private void produceOutput() {
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        if (FluidUtil.isValidContainer((ItemStack)((ItemStack)this.getInventory().get(slot)))) {
            FluidStack liquid = tank.getFluid();
            if (liquid != null) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (NonNullList)this.getInventory(), (int)slot, (Item)AsteroidItems.methaneCanister);
            }
        } else if (!((ItemStack)this.getInventory().get(slot)).func_190926_b() && ((ItemStack)this.getInventory().get(slot)).func_77973_b() instanceof ItemAtmosphericValve) {
            tank.drain(4, true);
        }
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getFluid() != null ? this.gasTank.getFluid().amount * i / this.gasTank.getCapacity() : 0;
    }

    public int getScaledGasLevel2(int i) {
        return this.gasTank2.getFluid() != null ? this.gasTank2.getFluid().amount * i / this.gasTank2.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.liquidTank.getFluid() != null ? this.liquidTank.getFluid().amount * i / this.liquidTank.getCapacity() : 0;
    }

    public boolean canProcess() {
        if (this.gasTank.getFluid() == null || this.gasTank.getFluid().amount <= 0 || this.getDisabled(0)) {
            return false;
        }
        boolean bl = this.noCoal = ((ItemStack)this.getInventory().get(3)).func_190926_b() || ((ItemStack)this.getInventory().get(3)).func_77973_b() != MarsItems.carbonFragments;
        if (this.noCoal && this.coalPartial == 0 && (this.gasTank2.getFluid() == null || this.gasTank2.getFluidAmount() <= 0)) {
            return false;
        }
        return this.liquidTank.getFluidAmount() < this.liquidTank.getCapacity();
    }

    public int getAirProducts() {
        WorldProvider WP = this.field_145850_b.field_73011_w;
        if (WP instanceof IGalacticraftWorldProvider) {
            ArrayList atmos = ((IGalacticraftWorldProvider)WP).getCelestialBody().atmosphere.composition;
            if (atmos.size() > 0 && atmos.get(0) == EnumAtmosphericGas.CO2) {
                return 1;
            }
            if (atmos.size() > 1 && atmos.get(1) == EnumAtmosphericGas.CO2) {
                return 1;
            }
            if (atmos.size() > 2 && atmos.get(2) == EnumAtmosphericGas.CO2) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public void doLiquefaction() {
        if (this.noCoal && this.coalPartial == 0) {
            if (this.gasTank2.getFluid() == null || this.gasTank2.drain((int)1, (boolean)true).amount < 1) {
                return;
            }
        } else {
            if (this.coalPartial == 0) {
                this.func_70298_a(3, 1);
            }
            ++this.coalPartial;
            if (this.coalPartial == 40) {
                this.coalPartial = 0;
            }
        }
        this.gasTank.drain(this.placeIntoFluidTanks(2) * 8, true);
    }

    private int placeIntoFluidTanks(int amountToDrain) {
        int fuelSpace = this.liquidTank.getCapacity() - this.liquidTank.getFluidAmount();
        if (fuelSpace > 0) {
            if (amountToDrain > fuelSpace) {
                amountToDrain = fuelSpace;
            }
            this.liquidTank.fill(FluidRegistry.getFluidStack((String)"methane", (int)amountToDrain), true);
        } else {
            amountToDrain = 0;
        }
        return amountToDrain;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        if (nbt.func_74764_b("gasTank")) {
            this.gasTank.readFromNBT(nbt.func_74775_l("gasTank"));
        }
        if (nbt.func_74764_b("gasTank2")) {
            this.gasTank2.readFromNBT(nbt.func_74775_l("gasTank2"));
        }
        if (nbt.func_74764_b("liquidTank")) {
            this.liquidTank.readFromNBT(nbt.func_74775_l("liquidTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        if (this.gasTank.getFluid() != null) {
            nbt.func_74782_a("gasTank", (NBTBase)this.gasTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.gasTank2.getFluid() != null) {
            nbt.func_74782_a("gasTank2", (NBTBase)this.gasTank2.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank.getFluid() != null) {
            nbt.func_74782_a("liquidTank", (NBTBase)this.liquidTank.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemstack);
                }
                case 3: {
                    return itemstack.func_77973_b() == MarsItems.carbonFragments;
                }
                case 4: {
                    return FluidUtil.isPartialContainer((ItemStack)itemstack, (Item)AsteroidItems.methaneCanister);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty((ItemStack)itemstack) || !this.shouldPullEnergy();
                }
                case 4: {
                    return FluidUtil.isFullContainer((ItemStack)itemstack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: {
                return false;
            }
            case 2: {
                return itemstack.func_77973_b() instanceof ItemAtmosphericValve;
            }
            case 3: {
                return itemstack.func_77973_b() == MarsItems.carbonFragments;
            }
            case 4: {
                return FluidUtil.isValidContainer((ItemStack)itemstack);
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public double getPacketRange() {
        return 320.0;
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getHydrogenInputDirection().func_176734_d()) {
            return this.liquidTank.getFluid() != null && this.liquidTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getHydrogenInputDirection().func_176734_d() && resource != null && resource.isFluidEqual(this.liquidTank.getFluid())) {
            return this.liquidTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getHydrogenInputDirection().func_176734_d()) {
            return this.liquidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getHydrogenInputDirection()) {
            return fluid == null || "hydrogen".equals(fluid.getName());
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid()) && this.gasTank.getFluidAmount() < this.gasTank.getCapacity()) {
            used = this.gasTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == this.getHydrogenInputDirection()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.gasTank)};
        } else if (from == this.getHydrogenInputDirection().func_176734_d()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank)};
        }
        return tankInfo;
    }

    public int func_145832_p() {
        return this.func_145838_q().func_176201_c(this.field_145850_b.func_180495_p(this.func_174877_v()));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (!stack.getGas().getName().equals("hydrogen")) {
            return 0;
        }
        int used = 0;
        if (this.gasTank.getFluidAmount() < this.gasTank.getCapacity()) {
            used = this.gasTank.fill(FluidRegistry.getFluidStack((String)"hydrogen", (int)stack.amount), doTransfer);
        }
        return used;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public GasStack drawGas(EnumFacing side, int amount) {
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return type.getName().equals("hydrogen") && side.equals((Object)this.getHydrogenInputDirection());
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="mekanism")
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.ITubeConnection", modID="mekanism")
    public boolean canTubeConnect(EnumFacing side) {
        return side.equals((Object)this.getHydrogenInputDirection());
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            return direction == this.getHydrogenInputDirection() || direction == this.getHydrogenInputDirection().func_176734_d();
        }
        return false;
    }

    public int getHydrogenRequest(EnumFacing direction) {
        return this.receiveHydrogen(direction, 1000000.0f, false);
    }

    public boolean shouldPullHydrogen() {
        return this.gasTank.getFluidAmount() < this.gasTank.getCapacity();
    }

    public int receiveHydrogen(EnumFacing from, float receive, boolean doReceive) {
        if (from == this.getHydrogenInputDirection() && this.shouldPullHydrogen()) {
            FluidStack fluidToFill = FluidRegistry.getFluidStack((String)"hydrogen", (int)((int)receive));
            return this.gasTank.fill(fluidToFill, doReceive);
        }
        return 0;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachineMarsT2) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachineMarsT2.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getHydrogenInputDirection() {
        return this.getFront().func_176746_e();
    }

    private boolean produceOutput(EnumFacing outputDirection) {
        int gasRequested;
        TileEntity outputTile;
        FluidNetwork outputNetwork;
        int provide = this.getMethaneProvide();
        if (provide > 0 && (outputNetwork = NetworkHelper.getFluidNetworkFromTile((TileEntity)(outputTile = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, outputDirection)), (EnumFacing)outputDirection)) != null && (gasRequested = outputNetwork.getRequest()) > 0) {
            int usedGas = outputNetwork.emitToBuffer(new FluidStack(AsteroidsModule.fluidMethaneGas, Math.min(gasRequested, provide)), true);
            this.liquidTank.drain(usedGas, true);
            return true;
        }
        return false;
    }

    private int getMethaneProvide() {
        return Math.min(500, this.liquidTank.getFluidAmount());
    }
}

