/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonStart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class Piece
extends StructureComponent {
    protected DungeonConfiguration configuration;

    public Piece() {
    }

    public Piece(DungeonConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        this.configuration.writeToNBT(tagCompound);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        if (this.configuration == null) {
            this.configuration = new DungeonConfiguration();
            this.configuration.readFromNBT(tagCompound);
        }
    }

    protected StructureBoundingBox getExtension(EnumFacing direction, int length, int width) {
        int blockZ;
        int blockX;
        int sizeZ;
        int sizeX;
        switch (direction) {
            case NORTH: {
                sizeX = width;
                sizeZ = length;
                blockX = this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - sizeX / 2;
                blockZ = this.field_74887_e.field_78896_c - sizeZ;
                break;
            }
            case EAST: {
                sizeX = length;
                sizeZ = width;
                blockX = this.field_74887_e.field_78893_d;
                blockZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - sizeZ / 2;
                break;
            }
            case SOUTH: {
                sizeX = width;
                sizeZ = length;
                blockX = this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - sizeX / 2;
                blockZ = this.field_74887_e.field_78892_f;
                break;
            }
            default: {
                sizeX = length;
                sizeZ = width;
                blockX = this.field_74887_e.field_78897_a - sizeX;
                blockZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - sizeZ / 2;
            }
        }
        return new StructureBoundingBox(blockX, this.configuration.getYPosition(), blockZ, blockX + sizeX, this.configuration.getYPosition() + this.configuration.getHallwayHeight(), blockZ + sizeZ);
    }

    public Piece getNextPiece(DungeonStart startPiece, Random rand) {
        return null;
    }

    protected void func_175811_a(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (this.field_186168_b != Mirror.NONE) {
            blockstateIn = blockstateIn.func_185902_a(this.field_186168_b);
        }
        if (this.field_186169_c != Rotation.NONE) {
            blockstateIn = blockstateIn.func_185907_a(this.field_186169_c);
        }
        worldIn.func_180501_a(blockpos, blockstateIn, 2);
    }
}

