/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.model.item;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.powersuits.client.event.ModelBakeEventHandler;
import net.machinemuse.powersuits.client.helper.ModelHelper;
import net.machinemuse.powersuits.client.helper.ModelTransformCalibration;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.powersuits.client.render.modelspec.PartSpecBase;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.IModularItemBase;
import net.machinemuse.powersuits.utils.nbt.MPSNBTUtils;
import net.machinemuse.powersuits.utils.nbt.NBTTagAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelPowerFist
implements IBakedModel {
    static ItemCameraTransforms.TransformType modelcameraTransformType;
    static ItemStack itemStack;
    static Item item;
    static Colour colour;
    static World world;
    static EntityLivingBase entity;
    static boolean isFiring;
    static IBakedModel iconModel;
    NBTTagCompound renderTag = new NBTTagCompound();
    ModelTransformCalibration calibration;
    NBTTagCompound renderSpec;

    public ModelPowerFist(IBakedModel bakedModelIn) {
        IBakedModel iBakedModel;
        if (bakedModelIn instanceof ModelPowerFist) {
            ModelPowerFist cfr_ignored_0 = (ModelPowerFist)bakedModelIn;
            iBakedModel = iconModel;
        } else {
            iBakedModel = bakedModelIn;
        }
        iconModel = iBakedModel;
        this.calibration = new ModelTransformCalibration();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        modelcameraTransformType = cameraTransformType;
        switch (cameraTransformType) {
            case FIRST_PERSON_LEFT_HAND: 
            case THIRD_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                return Pair.of((Object)this, (Object)TRSRTransformation.blockCornerToCenter((TRSRTransformation)TRSRTransformation.identity()).getMatrix());
            }
        }
        return iconModel.handlePerspective(cameraTransformType);
    }

    public boolean func_177555_b() {
        return iconModel.func_177555_b();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return iconModel.func_177554_e();
    }

    public boolean func_177556_c() {
        if (iconModel == null) {
            iconModel = ModelBakeEventHandler.powerFistIconModel;
        }
        return iconModel.func_177556_c();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        switch (modelcameraTransformType) {
            case GUI: 
            case FIXED: 
            case NONE: {
                return iconModel.func_188616_a(state, side, rand);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int[] colours = this.renderSpec.func_74759_k("colours");
        for (NBTTagCompound nbt : NBTTagAccessor.getValues(this.renderSpec)) {
            PartSpecBase partSpec = ModelRegistry.getInstance().getPart(nbt);
            if (!(partSpec instanceof ModelPartSpec) || !partSpec.getBinding().getTarget().name().toUpperCase().equals(modelcameraTransformType.equals((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) || modelcameraTransformType.equals((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) ? "LEFTHAND" : "RIGHTHAND")) continue;
            TRSRTransformation transform = ((ModelSpec)partSpec.spec).getTransform(modelcameraTransformType);
            String itemState = partSpec.getBinding().getItemState();
            int ix = partSpec.getColourIndex(nbt);
            Colour partColor = ix < colours.length && ix >= 0 ? new Colour(colours[ix]) : Colour.WHITE;
            boolean glow = ((ModelPartSpec)partSpec).getGlow(nbt);
            if ((isFiring || !itemState.equals("all") && !itemState.equals("normal")) && (!isFiring || !itemState.equals("all") && !itemState.equals("firing"))) continue;
            builder.addAll(ModelHelper.getColouredQuadsWithGlowAndTransform(((ModelPartSpec)partSpec).getQuads(), partColor, transform, glow));
        }
        return builder.build();
    }

    public ItemOverrideList func_188617_f() {
        return new PowerFistItemOverrideList();
    }

    static {
        isFiring = false;
    }

    public class PowerFistItemOverrideList
    extends ItemOverrideList {
        public PowerFistItemOverrideList() {
            super(Collections.EMPTY_LIST);
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stackIn, World worldIn, EntityLivingBase entityIn) {
            itemStack = stackIn;
            ModelPowerFist.this.renderSpec = MPSNBTUtils.getMuseRenderTag(stackIn);
            world = worldIn;
            entity = entityIn;
            item = itemStack.func_77973_b();
            colour = ((IModularItemBase)item).getColorFromItemStack(itemStack);
            isFiring = entityIn instanceof EntityPlayer ? !itemStack.func_190926_b() && itemStack == entityIn.func_184614_ca() && entityIn.func_184587_cr() && ModuleManager.INSTANCE.itemHasActiveModule(itemStack, "plasmaCannon") : false;
            return originalModel;
        }
    }
}

