/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import io.netty.buffer.ByteBuf;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.network.MuseByteBufferUtils;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.nbt.MuseNBTUtils;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MusePacketInstallModuleRequest
implements IMessage {
    EntityPlayer player;
    int itemSlot;
    String moduleName;

    public MusePacketInstallModuleRequest() {
    }

    public MusePacketInstallModuleRequest(EntityPlayer player, int itemSlot, String moduleName) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.moduleName = moduleName;
    }

    public void fromBytes(ByteBuf buf) {
        this.itemSlot = buf.readInt();
        this.moduleName = MuseByteBufferUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemSlot);
        MuseByteBufferUtils.writeUTF8String((ByteBuf)buf, (String)this.moduleName);
    }

    public static class Handler
    implements IMessageHandler<MusePacketInstallModuleRequest, IMessage> {
        public IMessage onMessage(MusePacketInstallModuleRequest message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    int itemSlot = message.itemSlot;
                    String moduleName = message.moduleName;
                    ItemStack stack = player.field_71071_by.func_70301_a(itemSlot);
                    if (moduleName != null) {
                        InventoryPlayer inventory = player.field_71071_by;
                        IPowerModule moduleType = ModuleManager.INSTANCE.getModule(moduleName);
                        if (moduleType == null || !moduleType.isAllowed()) {
                            player.func_145747_a((ITextComponent)new TextComponentString("Server has disallowed this module. Sorry!"));
                        } else {
                            NonNullList<ItemStack> cost = ModuleManager.INSTANCE.getInstallCost(moduleName);
                            if (!ModuleManager.INSTANCE.itemHasModule(stack, moduleName) && MuseItemUtils.hasInInventory(cost, player.field_71071_by) || player.field_71075_bZ.field_75098_d) {
                                MuseNBTUtils.removeMuseValuesTag(stack);
                                ModuleManager.INSTANCE.itemAddModule(stack, moduleType);
                                for (ItemStack stackInCost : cost) {
                                    ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, MPSConfig.rfValueOfComponent(stackInCost));
                                }
                                if (!player.field_71075_bZ.field_75098_d) {
                                    MuseItemUtils.deleteFromInventory(cost, inventory);
                                }
                                player.field_71069_bz.func_75142_b();
                            }
                        }
                    }
                });
            }
            return null;
        }
    }
}

