/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import javax.annotation.Nonnull;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.heat.MuseHeatUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class DimensionalRiftModule
extends PowerModuleBase
implements IRightClickModule {
    final int theOverworld = 0;
    final int theNether = -1;
    final int theEnd = 1;

    public DimensionalRiftModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
        this.addBasePropertyDouble("heatGeneration", 55.0);
        this.addBasePropertyDouble("energyCon", 200000.0);
        this.defaultTag.func_74757_a("Active", false);
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    @Override
    public String getDataName() {
        return "dimRiftGen";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!playerIn.func_184218_aH() && !playerIn.func_184207_aI() && playerIn.func_184222_aU() && playerIn instanceof EntityPlayerMP) {
            BlockPos coords;
            EntityPlayerMP player = (EntityPlayerMP)playerIn;
            BlockPos blockPos = coords = playerIn.field_71081_bT != null ? playerIn.field_71081_bT : playerIn.field_70170_p.func_175694_M();
            while (worldIn.func_180495_p(new BlockPos(coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p())).func_177230_c() != Blocks.field_150350_a && worldIn.func_180495_p(coords.func_177984_a()) != Blocks.field_150350_a) {
                coords = coords.func_177984_a();
            }
            playerIn.changeDimension(0, (ITeleporter)new CommandTeleporter(coords));
            int energyConsumption = (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "energyCon");
            int playerEnergy = ElectricItemUtils.getPlayerEnergy(playerIn);
            if (playerEnergy >= energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, this.getEnergyUsage(itemStackIn));
                MuseHeatUtils.heatPlayer((EntityPlayer)player, ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "heatGeneration"));
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "energyCon");
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.dimRiftGen;
    }

    private static class CommandTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        private CommandTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            entity.func_174828_a(this.targetPos, yaw, entity.field_70125_A);
        }
    }
}

