/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.geom;

import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.EnumHelper;

public enum Offset {
    NONE(0, 0, 0),
    UP(EnumFacing.UP),
    DOWN(EnumFacing.DOWN),
    EAST(EnumFacing.EAST),
    WEST(EnumFacing.WEST),
    SOUTH(EnumFacing.SOUTH),
    NORTH(EnumFacing.NORTH),
    EAST_UP(EnumFacing.EAST, EnumFacing.UP),
    WEST_UP(EnumFacing.WEST, EnumFacing.UP),
    SOUTH_UP(EnumFacing.SOUTH, EnumFacing.UP),
    NORTH_UP(EnumFacing.NORTH, EnumFacing.UP),
    EAST_DOWN(EnumFacing.EAST, EnumFacing.DOWN),
    WEST_DOWN(EnumFacing.WEST, EnumFacing.DOWN),
    SOUTH_DOWN(EnumFacing.SOUTH, EnumFacing.DOWN),
    NORTH_DOWN(EnumFacing.NORTH, EnumFacing.DOWN),
    NORTH_EAST(EnumFacing.NORTH, EnumFacing.EAST),
    NORTH_WEST(EnumFacing.NORTH, EnumFacing.WEST),
    SOUTH_EAST(EnumFacing.SOUTH, EnumFacing.EAST),
    SOUTH_WEST(EnumFacing.SOUTH, EnumFacing.WEST);

    public final int xOffset;
    public final int yOffset;
    public final int zOffset;

    private Offset(EnumFacing dir) {
        this.xOffset = dir.func_82601_c();
        this.yOffset = dir.func_96559_d();
        this.zOffset = dir.func_82599_e();
    }

    private Offset(EnumFacing dir, EnumFacing yDir) {
        this.xOffset = dir.func_82601_c() + yDir.func_82601_c();
        this.yOffset = dir.func_96559_d() + yDir.func_96559_d();
        this.zOffset = dir.func_82599_e() + yDir.func_82599_e();
    }

    private Offset(int xOffset, int yOffset, int zOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public static Offset addOffset(String name, int xOffset, int yOffset, int zOffset) {
        for (Offset offset : Offset.values()) {
            if (offset.xOffset != xOffset || offset.yOffset != yOffset || offset.zOffset != zOffset) continue;
            return null;
        }
        return (Offset)EnumHelper.addEnum(Offset.class, (String)name, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{xOffset, yOffset, zOffset});
    }

    public Offset next() {
        return Offset.values().length > this.ordinal() + 1 ? Offset.values()[this.ordinal() + 1] : null;
    }

    public static Offset first() {
        return Offset.values()[0];
    }
}

