/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.widget.GhostSlot;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public interface IHaveGhostTargets<T extends GuiContainerBase> {
    default public List<? extends IGhostIngredientHandler.Target<?>> getGhostTargets() {
        if (!(this instanceof GuiContainerBase)) {
            throw new IllegalStateException("IHaveGhostTargets must be implemented by GuiContainerBase subclasses, or provide a custom implementation.");
        }
        final GuiContainerBase gui = (GuiContainerBase)this;
        return gui.getGhostSlotHandler().getGhostSlots().stream().filter(this::isSlotTarget).map(s -> new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return new Rectangle(s.getX() + gui.getGuiLeft(), s.getY() + gui.getGuiTop(), 16, 16);
            }

            public void accept(Object ingredient) {
                System.out.println(ingredient);
                if (ingredient instanceof ItemStack) {
                    s.putStack((ItemStack)ingredient, 1);
                } else if (ingredient instanceof FluidStack && s instanceof IFluidGhostSlot) {
                    ((IFluidGhostSlot)s).putFluidStack((FluidStack)ingredient);
                } else if (ingredient instanceof Fluid && s instanceof IFluidGhostSlot) {
                    ((IFluidGhostSlot)s).putFluid((Fluid)ingredient);
                }
            }
        }).collect(Collectors.toList());
    }

    default public boolean isSlotTarget(GhostSlot slot) {
        return true;
    }

    public static interface IFluidGhostSlot {
        default public void putFluidStack(@Nonnull FluidStack stack) {
            Fluid fluid = stack.getFluid();
            if (fluid != null) {
                this.putFluid(fluid);
            }
        }

        public void putFluid(@Nonnull Fluid var1);
    }
}

