/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.lang;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.lang.Lang;
import java.text.NumberFormat;
import javax.annotation.Nonnull;

public final class LangPower {
    @Nonnull
    public static final NumberFormat INT_NF = NumberFormat.getIntegerInstance();
    @Nonnull
    public static final NumberFormat FLOAT_NF = NumberFormat.getInstance();
    @Nonnull
    public static final NumberFormat FLOAT_NF2 = NumberFormat.getInstance();

    @Deprecated
    @Nonnull
    public static String perTickStr() {
        return EnderIO.lang.localize("power.tick");
    }

    @Deprecated
    @Nonnull
    public static String ofStr() {
        return EnderIO.lang.localize("gui.power_monitor.of");
    }

    @Nonnull
    public static String RFt(int amountPerTick) {
        return Lang.POWER_PERTICK.get(LangPower.format(amountPerTick));
    }

    @Nonnull
    public static String RFt(float amountPerTick) {
        return Lang.POWER_PERTICK.get(LangPower.format(amountPerTick));
    }

    @Nonnull
    public static String RFt2(float amountPerTick) {
        return Lang.POWER_PERTICK.get(LangPower.format2(amountPerTick));
    }

    @Nonnull
    public static String RF(int amount, int capacity) {
        return Lang.POWER_OF.get(LangPower.format(amount), LangPower.format(capacity));
    }

    @Nonnull
    public static String RF(long amount, long capacity) {
        return Lang.POWER_OF.get(LangPower.format(amount), LangPower.format(capacity));
    }

    @Nonnull
    public static String RF(long amount) {
        return Lang.POWER.get(LangPower.format(amount));
    }

    @Nonnull
    public static String RF(int amount) {
        return Lang.POWER.get(LangPower.format(amount));
    }

    @Nonnull
    public static String RF(float amount) {
        return Lang.POWER.get(LangPower.format(amount));
    }

    @Nonnull
    public static String RF() {
        return Lang.POWER_SYMBOL.get();
    }

    @Nonnull
    public static String format(long amount) {
        return INT_NF.format(amount);
    }

    @Nonnull
    public static String format(int amount) {
        return INT_NF.format(amount);
    }

    @Nonnull
    public static String format(float amount) {
        return FLOAT_NF.format(amount);
    }

    @Nonnull
    public static String format2(float amount) {
        return FLOAT_NF2.format(amount);
    }

    @Deprecated
    @Nonnull
    public static String abrevation() {
        return EnderIO.lang.localize("power.rf");
    }

    @Nonnull
    public static String toPercent(float fl) {
        return "" + Math.round(fl * 100.0f);
    }

    static {
        FLOAT_NF.setMinimumFractionDigits(1);
        FLOAT_NF.setMaximumFractionDigits(1);
        FLOAT_NF2.setMinimumFractionDigits(2);
        FLOAT_NF2.setMaximumFractionDigits(2);
    }
}

