/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.modes;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.Lists;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.gui.IconEIO;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;

public enum RedstoneControlMode {
    IGNORE,
    ON,
    OFF,
    NEVER;

    public static final int MIN_ON_LEVEL = 1;

    public static boolean isConditionMet(@Nonnull RedstoneControlMode redstoneControlMode, int powerLevel) {
        switch (redstoneControlMode) {
            case IGNORE: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case OFF: {
                return powerLevel == 0;
            }
            case ON: {
                return powerLevel > 0;
            }
        }
        return false;
    }

    public static boolean isConditionMet(@Nonnull RedstoneControlMode redstoneControlMode, TileEntity te) {
        switch (redstoneControlMode) {
            case IGNORE: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return RedstoneControlMode.isConditionMet(redstoneControlMode, ConduitUtil.isBlockIndirectlyGettingPoweredIfLoaded(te.func_145831_w(), te.func_174877_v()));
    }

    @Nonnull
    public RedstoneControlMode next() {
        return (RedstoneControlMode)((Object)NNList.of(RedstoneControlMode.class).next((Object)this));
    }

    @Nonnull
    public RedstoneControlMode previous() {
        return (RedstoneControlMode)((Object)NNList.of(RedstoneControlMode.class).prev((Object)this));
    }

    @Nonnull
    public static RedstoneControlMode fromOrdinal(int ordinal) {
        return (RedstoneControlMode)((Object)NullHelper.first((Object[])new RedstoneControlMode[]{RedstoneControlMode.values()[MathHelper.func_76125_a((int)ordinal, (int)0, (int)(RedstoneControlMode.values().length - 1))], IGNORE}));
    }

    public static enum IconHolder implements CycleButton.ICycleEnum
    {
        IGNORE(IGNORE, IconEIO.REDSTONE_MODE_ALWAYS),
        ON(ON, IconEIO.REDSTONE_MODE_WITH_SIGNAL),
        OFF(OFF, IconEIO.REDSTONE_MODE_WITHOUT_SIGNAL),
        NEVER(NEVER, IconEIO.REDSTONE_MODE_NEVER);

        @Nonnull
        private final RedstoneControlMode mode;
        @Nonnull
        private final IWidgetIcon icon;

        private IconHolder(RedstoneControlMode mode, IWidgetIcon icon) {
            this.mode = mode;
            this.icon = icon;
        }

        @Nonnull
        public String getTooltip() {
            return EnderIO.lang.localize(this.getUnlocalizedTooltip());
        }

        @Nonnull
        public String getUnlocalizedTooltip() {
            return "gui.tooltip.redstoneControlMode." + this.name().toLowerCase(Locale.US);
        }

        @Nonnull
        public IWidgetIcon getIcon() {
            return this.icon;
        }

        @Nonnull
        public List<String> getTooltipLines() {
            return Lists.newArrayList((Object[])new String[]{this.getTooltip()});
        }

        @Nonnull
        public RedstoneControlMode getMode() {
            return this.mode;
        }

        @Nonnull
        public static IconHolder getFromMode(@Nonnull RedstoneControlMode mode) {
            for (IconHolder holder : IconHolder.values()) {
                if (holder.mode != mode) continue;
                return holder;
            }
            return IGNORE;
        }
    }
}

