/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(@Nonnull aip input, @Nonnull aip ingredient, @Nonnull aip output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(@Nonnull aip input, @Nonnull String ingredient, @Nonnull aip output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingOreRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    @Nonnull
    public static aip getOutput(@Nonnull aip input, @Nonnull aip ingredient) {
        if (input.b() || input.E() != 1) {
            return aip.a;
        }
        if (ingredient.b()) {
            return aip.a;
        }
        for (IBrewingRecipe recipe : recipes) {
            aip output = recipe.getOutput(input, ingredient);
            if (output.b()) continue;
            return output;
        }
        return aip.a;
    }

    public static boolean hasOutput(@Nonnull aip input, @Nonnull aip ingredient) {
        return !BrewingRecipeRegistry.getOutput(input, ingredient).b();
    }

    public static boolean canBrew(fi<aip> inputs, @Nonnull aip ingredient, int[] inputIndexes) {
        if (ingredient.b()) {
            return false;
        }
        for (int i2 : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOutput((aip)inputs.get(i2), ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(fi<aip> inputs, @Nonnull aip ingredient, int[] inputIndexes) {
        for (int i2 : inputIndexes) {
            aip output = BrewingRecipeRegistry.getOutput((aip)inputs.get(i2), ingredient);
            if (output.b()) continue;
            inputs.set(i2, (Object)output);
        }
    }

    public static boolean isValidIngredient(@Nonnull aip stack) {
        if (stack.b()) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(@Nonnull aip stack) {
        if (stack.E() != 1) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

