/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy.items;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import sonar.core.api.asm.ItemEnergyHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.IItemEnergyHandler;
import sonar.core.api.utils.ActionType;

@ItemEnergyHandler(modid="tesla", priority=2)
public class ItemHandlerTesla
implements IItemEnergyHandler {
    @Override
    public EnergyType getEnergyType() {
        return EnergyType.TESLA;
    }

    @Override
    public boolean canAddEnergy(ItemStack stack) {
        return !stack.func_190926_b() && stack.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null);
    }

    @Override
    public boolean canRemoveEnergy(ItemStack stack) {
        return !stack.func_190926_b() && stack.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null);
    }

    @Override
    public boolean canReadEnergy(ItemStack stack) {
        return stack.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
    }

    @Override
    public long addEnergy(long add, ItemStack stack, ActionType actionType) {
        ITeslaConsumer consumer = (ITeslaConsumer)stack.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null);
        return consumer.givePower(add, actionType.shouldSimulate());
    }

    @Override
    public long removeEnergy(long remove, ItemStack stack, ActionType actionType) {
        ITeslaProducer producer = (ITeslaProducer)stack.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null);
        return producer.takePower(remove, actionType.shouldSimulate());
    }

    @Override
    public long getStored(ItemStack stack) {
        return ((ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null)).getStoredPower();
    }

    @Override
    public long getCapacity(ItemStack stack) {
        return ((ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null)).getCapacity();
    }
}

