/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismClient;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ITierItem;
import mekanism.common.base.TileNetworkList;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.forgeenergy.ForgeEnergyItemWrapper;
import mekanism.common.integration.ic2.IC2ItemManager;
import mekanism.common.integration.tesla.TeslaItemWrapper;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2")})
public class ItemBlockEnergyCube
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
ISustainedInventory,
IEnergyContainerItem,
ISecurityItem,
ITierItem {
    public Block metaBlock;

    public ItemBlockEnergyCube(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
        list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(Tier.EnergyCubeTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].maxEnergy));
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
        } else {
            if (this.hasSecurity(itemstack)) {
                list.add(SecurityUtils.getOwnerDisplay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, MekanismClient.clientUUIDMap.get(this.getOwnerUUID(itemstack))));
                list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                    list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                }
            }
            list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    public ItemStack getUnchargedItem(Tier.EnergyCubeTier tier) {
        ItemStack stack = new ItemStack((Item)this);
        this.setBaseTier(stack, tier.getBaseTier());
        return stack;
    }

    public String func_77653_i(ItemStack itemstack) {
        return LangUtils.localize("tile.EnergyCube" + this.getBaseTier(itemstack).getSimpleName() + ".name");
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        boolean place = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state);
        if (place) {
            TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_175625_s(pos);
            tileEntity.tier = Tier.EnergyCubeTier.values()[this.getBaseTier(stack).ordinal()];
            tileEntity.electricityStored = this.getEnergy(stack);
            if (tileEntity.tier == Tier.EnergyCubeTier.CREATIVE) {
                tileEntity.configComponent.fillConfig(TransmissionType.ENERGY, tileEntity.getEnergy() > 0.0 ? 2 : 1);
            }
            if (tileEntity instanceof ISecurityTile) {
                TileEntityEnergyCube security = tileEntity;
                security.getSecurity().setOwnerUUID(this.getOwnerUUID(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwnerUUID(stack) == null) {
                    security.getSecurity().setOwnerUUID(player.func_110124_au());
                }
            }
            if (tileEntity instanceof ISideConfiguration) {
                TileEntityEnergyCube config = tileEntity;
                if (ItemDataUtils.hasData(stack, "sideDataStored")) {
                    config.getConfig().read(ItemDataUtils.getDataMap(stack));
                    config.getEjector().read(ItemDataUtils.getDataMap(stack));
                }
            }
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
        return place;
    }

    @Override
    public Tier.BaseTier getBaseTier(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return Tier.BaseTier.BASIC;
        }
        return Tier.BaseTier.values()[itemstack.func_77978_p().func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, Tier.BaseTier tier) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("tier", tier.ordinal());
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemDataUtils.setList((ItemStack)data[0], "Items", nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            return ItemDataUtils.getList((ItemStack)data[0], "Items");
        }
        return null;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return 0.0;
        }
        return ItemDataUtils.getDouble(itemStack, "energyStored");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (this.getBaseTier(itemStack) == Tier.BaseTier.CREATIVE && amount != Double.MAX_VALUE) {
            return;
        }
        ItemDataUtils.setDouble(itemStack, "energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return Tier.EnergyCubeTier.values()[this.getBaseTier((ItemStack)itemStack).ordinal()].maxEnergy;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * MekanismConfig.general.FROM_RF, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * MekanismConfig.general.FROM_RF, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * MekanismConfig.general.TO_RF);
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * MekanismConfig.general.TO_RF);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getEnergy(stack) / this.getMaxEnergy(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Override
    public UUID getOwnerUUID(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "ownerUUID")) {
            return UUID.fromString(ItemDataUtils.getString(stack, "ownerUUID"));
        }
        return null;
    }

    @Override
    public void setOwnerUUID(ItemStack stack, UUID owner) {
        if (owner == null) {
            ItemDataUtils.removeData(stack, "ownerUUID");
            return;
        }
        ItemDataUtils.setString(stack, "ownerUUID", owner.toString());
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (!MekanismConfig.general.allowProtection) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[ItemDataUtils.getInt(stack, "security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        ItemDataUtils.setInt(stack, "security", mode.ordinal());
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityWrapper(stack, new TeslaItemWrapper(), new ForgeEnergyItemWrapper());
    }
}

