/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.gui;

import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.inventory.ContainerFuelGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityFuelGenerator;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFuelGenerator
extends GuiContainerGC {
    private static final ResourceLocation fuelGeneratorTexture = new ResourceLocation("galaxyspace", "textures/gui/geothermal_generator.png");
    private GuiElementInfoRegion fuelTankRegion;
    private TileEntityFuelGenerator tileEntity;

    public GuiFuelGenerator(InventoryPlayer par1InventoryPlayer, TileEntityFuelGenerator tileEntity) {
        super((Container)new ContainerFuelGenerator(par1InventoryPlayer, tileEntity));
        this.fuelTankRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 7, (this.field_146295_m - this.field_147000_g) / 2 + 28, 16, 38, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.tileEntity = tileEntity;
    }

    public void func_73866_w_() {
        int fuelCapacity;
        super.func_73866_w_();
        ArrayList<String> fuelTankDesc = new ArrayList<String>();
        int fuelLevel = this.tileEntity.fuelTank != null && this.tileEntity.fuelTank.getFluid() != null ? this.tileEntity.fuelTank.getFluid().amount : 0;
        int n = fuelCapacity = this.tileEntity.fuelTank != null ? this.tileEntity.fuelTank.getCapacity() : 0;
        if (this.tileEntity.fuelTank.getFluid() != null) {
            fuelTankDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)this.tileEntity.fuelTank.getFluid().getUnlocalizedName()) + ": " + fuelLevel + " / " + fuelCapacity);
        }
        this.fuelTankRegion.tooltipStrings = fuelTankDesc;
        this.fuelTankRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 7;
        this.fuelTankRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 28;
        this.fuelTankRegion.parentWidth = this.field_146294_l;
        this.fuelTankRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.fuelTankRegion);
    }

    protected void func_146979_b(int par1, int par2) {
        int yOffset = -18;
        this.field_146289_q.func_78276_b(EnumColor.WHITE + this.tileEntity.func_70005_c_(), 100 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 4, 0x404040);
        String displayText = EnumColor.WHITE + GCCoreUtil.translate((String)"gui.status.generating.name");
        this.field_146289_q.func_78276_b(displayText, 122 - this.field_146289_q.func_78256_a(displayText) / 2, 33, 0x404040);
        displayText = this.tileEntity.heatGJperTick <= 0.0f ? EnumColor.WHITE + GCCoreUtil.translate((String)"gui.status.not_generating.name") : (this.tileEntity.heatGJperTick < 1.0f ? EnumColor.WHITE + GCCoreUtil.translate((String)"gui.status.hullheat.name") + ": " + (int)(this.tileEntity.heatGJperTick / 1.0f * 100.0f) + "%" : EnergyDisplayHelper.getEnergyDisplayS((float)(this.tileEntity.heatGJperTick - 1.0f)) + "/t");
        if (this.tileEntity.fuelTank.getFluid() == null && this.tileEntity.heatGJperTick <= 0.0f) {
            displayText = EnumColor.RED + GCCoreUtil.translate((String)"gui.status.nofuelgenerator.name");
        }
        this.field_146289_q.func_78276_b(EnumColor.WHITE + GCCoreUtil.translate((String)"gui.message.status.name") + ": " + displayText, 72, 68 + yOffset, 0x404040);
        this.field_146289_q.func_78276_b(EnumColor.WHITE + GCCoreUtil.translate((String)"container.inventory"), 14, this.field_147000_g - 93 + 2, 0x404040);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        int fuelCapacity;
        this.field_146297_k.field_71446_o.func_110577_a(fuelGeneratorTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(containerWidth, containerHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        FluidStack fuel = this.tileEntity.fuelTank.getFluid();
        this.func_73729_b(containerWidth + 30, containerHeight + 33, 176, 58, 24, 16);
        this.func_73729_b(containerWidth + 5, containerHeight + 26, 200, 38, 20, 42);
        int fuelgraphLevel = this.tileEntity.getScaledFuelLevel(38);
        if (fuel != null) {
            GL11.glPushMatrix();
            this.displayGauge(7, 8, this.tileEntity.getScaledFuelLevel(38), this.tileEntity.fuelTank.getFluid(), 0);
            GL11.glPopMatrix();
        }
        this.func_73729_b(containerWidth + 7, containerHeight + 12, 176, -16, 16, 54);
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            int x = this.field_147002_h.func_75139_a((int)i).field_75223_e;
            int y = this.field_147002_h.func_75139_a((int)i).field_75221_f;
            GL11.glPushMatrix();
            switch (i) {
                case 0: {
                    this.func_73729_b(containerWidth + x - 2, containerHeight + y - 2, 176, 38, 20, 21);
                    break;
                }
                default: {
                    this.func_73729_b(containerWidth + x - 2, containerHeight + y - 2, 176, 38, 20, 21);
                }
            }
            GL11.glPopMatrix();
        }
        ArrayList<String> fuelTankDesc = new ArrayList<String>();
        int fuelLevel = this.tileEntity.fuelTank != null && this.tileEntity.fuelTank.getFluid() != null ? this.tileEntity.fuelTank.getFluid().amount : 0;
        int n = fuelCapacity = this.tileEntity.fuelTank != null ? this.tileEntity.fuelTank.getCapacity() : 0;
        if (fuel != null) {
            if (fuel.getFluid() == FluidRegistry.LAVA) {
                fuelTankDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.message.lava.name") + ": " + fuelLevel + " / " + fuelCapacity);
            } else {
                fuelTankDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + fuelLevel + " / " + fuelCapacity);
            }
        }
        this.fuelTankRegion.tooltipStrings = fuelTankDesc;
    }

    public void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, int side) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int start = 0;
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.func_175175_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, GSUtils.getFluidTexture(fluid.getFluid(), GSUtils.FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.field_146297_k.field_71446_o.func_110577_a(fuelGeneratorTexture);
    }
}

