/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.base;

import de.ellpeck.actuallyadditions.api.misc.IDisableableItem;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.ConfigurationHandler;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.oredict.OreDictionary;

public class ItemToolAA
extends ItemTool
implements IDisableableItem {
    private final String name;
    private final EnumRarity rarity;
    private final ItemStack repairItem;
    private String repairOredict;
    private final boolean disabled;

    public ItemToolAA(float attack, float speed, Item.ToolMaterial toolMat, String repairItem, String unlocalizedName, EnumRarity rarity, Set<Block> effectiveStuff) {
        this(attack, speed, toolMat, ItemStack.field_190927_a, unlocalizedName, rarity, effectiveStuff);
        this.repairOredict = repairItem;
    }

    public ItemToolAA(float attack, float speed, Item.ToolMaterial toolMat, ItemStack repairItem, String unlocalizedName, EnumRarity rarity, Set<Block> effectiveStuff) {
        super(attack, speed, toolMat, effectiveStuff);
        this.repairItem = repairItem;
        this.name = unlocalizedName;
        this.rarity = rarity;
        this.disabled = ConfigurationHandler.config.getBoolean("Disable: " + StringUtil.badTranslate(unlocalizedName), "Tool Control", false, "This will disable the " + StringUtil.badTranslate(unlocalizedName) + ". It will not be registered.");
        if (!this.disabled) {
            this.register();
        }
    }

    private void register() {
        ItemUtil.registerItem((Item)this, this.getBaseName(), this.shouldAddCreative());
        this.registerRendering();
    }

    protected String getBaseName() {
        return this.name;
    }

    public boolean shouldAddCreative() {
        return true;
    }

    protected void registerRendering() {
        ActuallyAdditions.PROXY.addRenderRegister(new ItemStack((Item)this), this.getRegistryName(), "inventory");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        if (StackUtil.isValid(this.repairItem)) {
            return ItemUtil.areItemsEqual(this.repairItem, stack, false);
        }
        if (this.repairOredict != null) {
            int[] idsStack;
            for (int id : idsStack = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)id).equals(this.repairOredict)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }
}

