/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityItemRepairer
extends TileEntityInventoryBase {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int ENERGY_USE = 2500;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(300000, 6000, 0);
    public int nextRepairTick;
    private int lastEnergy;

    public TileEntityItemRepairer() {
        super(2, "repairer");
    }

    public static boolean canBeRepaired(ItemStack stack) {
        Item item;
        if (StackUtil.isValid(stack) && (item = stack.func_77973_b()) != null) {
            if (item.isRepairable() && item.getMaxDamage(stack) > 0) {
                return true;
            }
            String reg = item.getRegistryName().toString();
            if (reg != null) {
                for (String strg : ConfigStringListValues.REPAIRER_EXTRA_WHITELIST.getValue()) {
                    if (!reg.equals(strg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("NextRepairTick", this.nextRepairTick);
        }
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.nextRepairTick = compound.func_74762_e("NextRepairTick");
        }
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack input = this.inv.getStackInSlot(0);
            if (!StackUtil.isValid(this.inv.getStackInSlot(1)) && TileEntityItemRepairer.canBeRepaired(input)) {
                if (input.func_77952_i() <= 0) {
                    this.inv.setStackInSlot(1, input.func_77946_l());
                    this.inv.setStackInSlot(0, StackUtil.getEmpty());
                    this.nextRepairTick = 0;
                } else if (this.storage.getEnergyStored() >= 2500) {
                    ++this.nextRepairTick;
                    this.storage.extractEnergyInternal(2500, false);
                    if (this.nextRepairTick >= 4) {
                        this.nextRepairTick = 0;
                        input.func_77964_b(input.func_77952_i() - 1);
                        if (input.func_77942_o() && "tconstruct".equalsIgnoreCase(input.func_77973_b().getRegistryName().func_110624_b())) {
                            NBTTagCompound stats = input.func_77978_p().func_74775_l("Stats");
                            stats.func_82580_o("Broken");
                        }
                    }
                }
            } else {
                this.nextRepairTick = 0;
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    public int getItemDamageToScale(int i) {
        if (StackUtil.isValid(this.inv.getStackInSlot(0))) {
            return (this.inv.getStackInSlot(0).func_77958_k() - this.inv.getStackInSlot(0).func_77952_i()) * i / this.inv.getStackInSlot(0).func_77958_k();
        }
        return 0;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

