/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.util.client;

import java.awt.Color;
import java.util.Random;
import java.util.function.Function;
import lumien.randomthings.client.render.magiccircles.ColorFunctions;
import lumien.randomthings.client.render.magiccircles.ITriangleFunction;
import lumien.randomthings.handler.RTEventHandler;
import lumien.randomthings.util.client.ColorUtil;
import lumien.randomthings.util.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.animation.Animation;
import org.lwjgl.opengl.GL11;

public class MKRRenderUtil {
    static ResourceLocation mkrFont = new ResourceLocation("randomthings", "textures/entitys/mkr_font.png");

    public static void circle1(double posX, double posY, double posZ, Color c1, Color c2, boolean fullCircle) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        RenderUtils.enableDefaultBlending();
        float progress = ((float)RTEventHandler.clientAnimationCounter + Animation.getPartialTickTime()) / 2.0f % 100.0f;
        if (progress <= 100.0f) {
            double radius = Math.sin((double)progress * 0.15707963267948966) * (double)0.8f + (double)0.2f;
            if ((double)progress * 0.15707963267948966 >= 1.5707963267948966) {
                radius = 1.0;
            }
            float rotation = (float)(3.6 * (double)progress);
            double modY = Math.min(0.05, 0.00625 * (double)progress);
            GlStateManager.func_179129_p();
            GlStateManager.func_179137_b((double)posX, (double)(posY += modY), (double)posZ);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            MKRRenderUtil.renderCircleDecTriInner(radius / 4.0, ColorFunctions.alternate(c2, c1).tt(progress), 11);
            MKRRenderUtil.renderCircleDecTriPart3Tri(1.5 * radius / 4.0, radius / 4.0, ColorFunctions.alternate(c1, c2).next(ColorFunctions.flicker(1000L, 10)).tt(progress), 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(2.0 * radius / 4.0, 1.5 * radius / 4.0, ColorFunctions.alternate(c2, c1).next(ColorFunctions.flicker(2000L, 10)).tt(progress), 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(2.5 * radius / 4.0, 2.0 * radius / 4.0, ColorFunctions.alternate(c2, c1).next(ColorFunctions.limit(ColorFunctions.constant(c2.darker()), i -> i % 10 % 2 == 0)).next(ColorFunctions.flicker(3000L, 10)).tt(progress), 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(3.0 * radius / 4.0, 2.5 * radius / 4.0, ColorFunctions.alternate(c2, c1).next(ColorFunctions.flicker(4000L, 10)).tt(progress), 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(radius, 3.0 * radius / 4.0, ColorFunctions.constant(c2).next(ColorFunctions.limit(ColorFunctions.constant(c1), i -> i % 2 == 1)).next(ColorFunctions.flicker(5000L, 10)).tt(progress), 30);
            if (fullCircle) {
                MKRRenderUtil.renderCircleDecOuterPart(radius, i -> c2);
            }
            GL11.glPolygonMode((int)1032, (int)6913);
            Color c1Dot = ColorUtil.brighter(c1, 20.0f);
            Color dotColor = new Color(c1Dot.getRed(), c1Dot.getGreen(), c1Dot.getBlue(), 50);
            ITriangleFunction outlineFunction = ITriangleFunction.from(progress, ColorFunctions.constant(dotColor));
            ITriangleFunction darkerFunction = outlineFunction.modColor(c -> c.darker());
            MKRRenderUtil.renderCircleDecTriInner(radius / 4.0, outlineFunction, 11);
            MKRRenderUtil.renderCircleDecTriPart3Tri(1.5 * radius / 4.0, radius / 4.0, darkerFunction, 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(2.0 * radius / 4.0, 1.5 * radius / 4.0, darkerFunction, 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(2.5 * radius / 4.0, 2.0 * radius / 4.0, darkerFunction, 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(radius, 3.0 * radius / 4.0, outlineFunction.modColor(c -> c.darker().darker().darker().darker()), 30);
            GlStateManager.func_179114_b((float)(-rotation), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-posX), (double)(-posY), (double)(-posZ));
            GlStateManager.func_179098_w();
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }

    public static void circle2(double posX, double posY, double posZ, Color c1, Color c2, boolean fullCircle) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        RenderUtils.enableDefaultBlending();
        float progress = ((float)RTEventHandler.clientAnimationCounter + Animation.getPartialTickTime()) / 2.0f % 100.0f;
        if (progress <= 100.0f) {
            double radius = Math.sin((double)progress * 0.15707963267948966) * (double)0.8f + (double)0.2f;
            if ((double)progress * 0.15707963267948966 >= 1.5707963267948966) {
                radius = 1.0;
            }
            float rotation = (float)(3.6 * (double)progress);
            double modY = Math.min(0.05, 0.00625 * (double)progress);
            GlStateManager.func_179129_p();
            GlStateManager.func_179137_b((double)posX, (double)(posY += modY), (double)posZ);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            MKRRenderUtil.renderCircleDecTriInner(radius / 4.0, i -> i % 4 == 0 ? c2 : ((i - 2) % 4 == 0 ? new Color(50, 50, 50, 50) : c1), 21, p -> {
                if (p % 2 == 0) {
                    return 3;
                }
                return 1;
            });
            MKRRenderUtil.renderCircleDecTriPartCross(1.5 * radius / 4.0, radius / 4.0, ColorFunctions.constant(c2).next(ColorFunctions.limit(ColorFunctions.constant(c1), i -> i % 6 < 4 && i / 6 % 2 != 0)).tt(progress), 60);
            MKRRenderUtil.renderCircleDecTriPart3Tri(2.0 * radius / 4.0, 1.5 * radius / 4.0, ColorFunctions.alternate(c1, c2).next(ColorFunctions.flicker(0L, 10)).tt(progress), 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(2.5 * radius / 4.0, 2.0 * radius / 4.0, ColorFunctions.alternate(c2, c1).next(ColorFunctions.flicker(500L, 10)).tt(progress), 30);
            MKRRenderUtil.renderCircleDecTriPart5Tri(3.0 * radius / 4.0, 2.5 * radius / 4.0, ColorFunctions.alternateN(c2, c1, 5, 3).next(ColorFunctions.flicker(0L, 10)).tt(progress), 60);
            MKRRenderUtil.renderCircleDecTriPart5Tri(radius, 3.0 * radius / 4.0, i -> {
                Color c = Color.getHSBColor(0.02f * (float)i + progress / 100.0f, 1.0f, 1.0f);
                return new Color(c.getRed(), c.getGreen(), c.getBlue(), 150);
            }, 50);
            if (fullCircle) {
                MKRRenderUtil.renderCircleDecOuterPart(radius, i -> c2);
            }
            MKRRenderUtil.renderCircleDecOuterPart(radius, t -> new Color(255, 0, 0, 100));
            MKRRenderUtil.renderCircleDecTriPart3Tri(radius + 0.1, radius + 0.05, t -> Color.RED, 30);
            GL11.glDisable((int)2848);
            GL11.glPolygonMode((int)1032, (int)6913);
            Color c1Dot = ColorUtil.brighter(c1, 20.0f);
            Color dotColor = new Color(c1Dot.getRed(), c1Dot.getGreen(), c1Dot.getBlue(), 50);
            ITriangleFunction dotColorFunction = ColorFunctions.constant(dotColor).tt(progress);
            MKRRenderUtil.renderCircleDecTriInner(radius / 4.0, dotColorFunction.modColor(c -> dotColor), 11);
            MKRRenderUtil.renderCircleDecTriPart3Tri(2.0 * radius / 4.0, 1.5 * radius / 4.0, dotColorFunction.darker(), 30);
            MKRRenderUtil.renderCircleDecTriPart3Tri(2.5 * radius / 4.0, 2.0 * radius / 4.0, dotColorFunction.darker(), 30);
            GlStateManager.func_179114_b((float)(-rotation), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-posX), (double)(-posY), (double)(-posZ));
            GlStateManager.func_179098_w();
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }

    public static void renderTextRing(double posX, double posY, double posZ, double radius, double qStep, int brokenNess, Color c) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        RenderUtils.enableDefaultBlending();
        mc.field_71446_o.func_110577_a(mkrFont);
        GlStateManager.func_179129_p();
        for (double q = 0.0; q < Math.PI * 2; q += qStep) {
            double cX = Math.sin(q) * radius;
            double cZ = Math.cos(q) * radius;
            double x = cX + posX;
            double y = posY;
            double z = cZ + posZ;
            double winkel = 57.29577951308232 * q;
            float fontSize = (float)(0.12 * radius);
            ColorUtil.applyColor(c);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)((float)winkel), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_187447_r((int)7);
            int charMod = new Random((long)(q * 1000.0) + (long)(RTEventHandler.clientAnimationCounter / 15)).nextInt(25);
            float uXMod = 0.0390625f * (float)charMod;
            float uYMod = (float)(brokenNess * 1) / 256.0f * 9.0f;
            GlStateManager.func_187426_b((float)uXMod, (float)uYMod);
            GlStateManager.func_187435_e((float)(-fontSize), (float)fontSize, (float)0.0f);
            GlStateManager.func_187426_b((float)uXMod, (float)(0.03515625f + uYMod));
            GlStateManager.func_187435_e((float)(-fontSize), (float)(-fontSize), (float)0.0f);
            GlStateManager.func_187426_b((float)(uXMod + 0.0390625f), (float)(0.03515625f + uYMod));
            GlStateManager.func_187435_e((float)fontSize, (float)(-fontSize), (float)0.0f);
            GlStateManager.func_187426_b((float)(uXMod + 0.0390625f), (float)uYMod);
            GlStateManager.func_187435_e((float)fontSize, (float)fontSize, (float)0.0f);
            GlStateManager.func_187437_J();
            GlStateManager.func_179114_b((float)(-((float)winkel)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        }
    }

    public static void renderMKRCastCharacters(double posX, double posY, double posZ, Color c) {
        for (int offset = 0; offset <= 15; offset += 15) {
            float progress = ((float)(RTEventHandler.clientAnimationCounter + offset) + Animation.getPartialTickTime()) % 30.0f;
            double radius = Math.sin((double)progress * 0.15707963267948966) * (double)0.15f + (double)0.1f;
            if ((double)progress * 0.15707963267948966 >= 1.5707963267948966) {
                radius = 0.25;
            }
            if (progress >= 25.0f) {
                radius -= (double)(0.015999999f * (progress - 25.0f));
            }
            double heightMod = 0.1 * (double)progress - 0.3;
            double qLimit = Math.PI / (radius * 40.0);
            MKRRenderUtil.renderTextRing(posX, posY + heightMod, posZ, radius, 0.2991993003418851, progress < 5.0f ? 2 : (progress < 8.0f ? 1 : 0), c);
        }
    }

    public static void renderCircleDecTriInner(double r, ITriangleFunction triangleFunction, int triCount) {
        MKRRenderUtil.renderCircleDecTriInner(r, triangleFunction, triCount, i -> 1);
    }

    public static void renderCircleDecTriInner(double r, ITriangleFunction triangleFunction, int triCount, Function<Integer, Integer> countFunction) {
        GlStateManager.func_187447_r((int)6);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        int currentTriCount = 0;
        for (int c = 0; c < 10; ++c) {
            int countForC = countFunction.apply(c);
            double winkelPart = 36 / countForC;
            double winkel = Math.PI / 180 * (double)c * 36.0;
            double winkel2 = Math.PI / 180 * (double)(c + 1) * 36.0;
            double pX = Math.sin(winkel) * r;
            double pZ = Math.cos(winkel) * r;
            double pX2 = Math.sin(winkel2) * r;
            double pZ2 = Math.cos(winkel2) * r;
            double dX = pX2 - pX;
            double dZ = pZ2 - pZ;
            double length = Math.sqrt(dX * dX + dZ * dZ);
            double partLength = length / (double)countForC;
            double nX = dX / length;
            double nZ = dZ / length;
            GlStateManager.func_187435_e((float)((float)pX), (float)0.0f, (float)((float)pZ));
            for (int p = 1; p <= countForC; ++p) {
                if (currentTriCount >= triCount) continue;
                ColorUtil.applyColor(triangleFunction.apply(currentTriCount));
                GlStateManager.func_187435_e((float)((float)(pX + nX * partLength * (double)p)), (float)0.0f, (float)((float)(pZ + nZ * partLength * (double)p)));
                ++currentTriCount;
            }
        }
        GlStateManager.func_187437_J();
    }

    public static void renderCircleDecOuterPart(double r, ITriangleFunction triangleFunction) {
        for (int c = 0; c < 10; ++c) {
            int winkelDeg1 = 36 * c;
            int winkelDeg2 = 36 * (c + 1);
            double winkelRad1 = Math.PI / 180 * (double)winkelDeg1;
            double winkelRad2 = Math.PI / 180 * (double)winkelDeg2;
            double pX1 = Math.sin(winkelRad1) * r;
            double pZ1 = Math.cos(winkelRad1) * r;
            double pX2 = Math.sin(winkelRad2) * r;
            double pZ2 = Math.cos(winkelRad2) * r;
            double cX = (pX2 + pX1) / 2.0;
            double cZ = (pZ2 + pZ1) / 2.0;
            GlStateManager.func_187447_r((int)6);
            GlStateManager.func_187435_e((float)((float)cX), (float)0.0f, (float)((float)cZ));
            for (int winkel = winkelDeg1; winkel <= winkelDeg2; winkel += 4) {
                int tri = c * 8 + (winkel - winkelDeg1) / 5;
                ColorUtil.applyColor(triangleFunction.apply(tri));
                double tWinkelRad = Math.PI / 180 * (double)winkel;
                double tX = Math.sin(tWinkelRad) * r;
                double tZ = Math.cos(tWinkelRad) * r;
                GlStateManager.func_187435_e((float)((float)tX), (float)0.0f, (float)((float)tZ));
            }
            GlStateManager.func_187437_J();
        }
    }

    public static void renderCircleDecTriPart5Tri(double r1, double r2, ITriangleFunction triangleFunction, int triCount) {
        MKRRenderUtil.renderCircleDecTriPart5Tri(r1, r2, triangleFunction, triCount, 0, 10);
    }

    public static void renderCircleDecTriPart5Tri(double r1, double r2, ITriangleFunction triangleFunction, int triCount, int cStart, int cEnd) {
        GlStateManager.func_187447_r((int)5);
        for (int c = cStart; c < cEnd; ++c) {
            int winkelDeg1 = 36 * c;
            int winkelDeg2 = 36 * (c + 1);
            int triIndex = (c - cStart) * 5;
            double winkelRad1 = Math.PI / 180 * (double)winkelDeg1;
            double winkelRad2 = Math.PI / 180 * (double)winkelDeg2;
            double pX1 = Math.sin(winkelRad1) * r1;
            double pZ1 = Math.cos(winkelRad1) * r1;
            double pX2 = Math.sin(winkelRad2) * r1;
            double pZ2 = Math.cos(winkelRad2) * r1;
            double pX1H = Math.sin(winkelRad1) * r2;
            double pZ1H = Math.cos(winkelRad1) * r2;
            double pX2H = Math.sin(winkelRad2) * r2;
            double pZ2H = Math.cos(winkelRad2) * r2;
            double cXH = (pX2H + pX1H) / 2.0;
            double cZH = (pZ2H + pZ1H) / 2.0;
            double tX1 = pX1 + (pX2 - pX1) / 3.0;
            double tZ1 = pZ1 + (pZ2 - pZ1) / 3.0;
            double tX2 = pX1 + 2.0 * (pX2 - pX1) / 3.0;
            double tZ2 = pZ1 + 2.0 * (pZ2 - pZ1) / 3.0;
            if (triIndex < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex));
                GlStateManager.func_187435_e((float)((float)pX1), (float)0.0f, (float)((float)pZ1));
                GlStateManager.func_187435_e((float)((float)pX1H), (float)0.0f, (float)((float)pZ1H));
                GlStateManager.func_187435_e((float)((float)tX1), (float)0.0f, (float)((float)tZ1));
            }
            if (triIndex + 1 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 1));
                GlStateManager.func_187435_e((float)((float)cXH), (float)0.0f, (float)((float)cZH));
            }
            if (triIndex + 2 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 2));
                GlStateManager.func_187435_e((float)((float)tX2), (float)0.0f, (float)((float)tZ2));
            }
            if (triIndex + 3 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 3));
                GlStateManager.func_187435_e((float)((float)pX2H), (float)0.0f, (float)((float)pZ2H));
            }
            if (triIndex + 4 >= triCount) continue;
            ColorUtil.applyColor(triangleFunction.apply(triIndex + 4));
            GlStateManager.func_187435_e((float)((float)pX2), (float)0.0f, (float)((float)pZ2));
        }
        GlStateManager.func_187437_J();
    }

    public static void renderCircleDecTriPart3Tri(double r1, double r2, ITriangleFunction triangleFunction, int triCount) {
        MKRRenderUtil.renderCircleDecTriPart3Tri(r1, r2, triangleFunction, triCount, 0, 10);
    }

    public static void renderCircleDecTriPart3Tri(double r1, double r2, ITriangleFunction triangleFunction, int triCount, int cStart, int cEnd) {
        GlStateManager.func_187447_r((int)5);
        for (int c = cStart; c < cEnd; ++c) {
            int winkelDeg1 = 36 * c;
            int winkelDeg2 = 36 * (c + 1);
            int triIndex = (c - cStart) * 3;
            double winkelRad1 = Math.PI / 180 * (double)winkelDeg1;
            double winkelRad2 = Math.PI / 180 * (double)winkelDeg2;
            double pX1 = Math.sin(winkelRad1) * r1;
            double pZ1 = Math.cos(winkelRad1) * r1;
            double pX2 = Math.sin(winkelRad2) * r1;
            double pZ2 = Math.cos(winkelRad2) * r1;
            double pX1H = Math.sin(winkelRad1) * r2;
            double pZ1H = Math.cos(winkelRad1) * r2;
            double pX2H = Math.sin(winkelRad2) * r2;
            double pZ2H = Math.cos(winkelRad2) * r2;
            double cX = (pX2 + pX1) / 2.0;
            double cZ = (pZ2 + pZ1) / 2.0;
            if (triIndex < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex));
                GlStateManager.func_187435_e((float)((float)pX1), (float)0.0f, (float)((float)pZ1));
                GlStateManager.func_187435_e((float)((float)pX1H), (float)0.0f, (float)((float)pZ1H));
                GlStateManager.func_187435_e((float)((float)cX), (float)0.0f, (float)((float)cZ));
            }
            if (triIndex + 1 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 1));
                GlStateManager.func_187435_e((float)((float)pX2H), (float)0.0f, (float)((float)pZ2H));
            }
            if (triIndex + 2 >= triCount) continue;
            ColorUtil.applyColor(triangleFunction.apply(triIndex + 2));
            GlStateManager.func_187435_e((float)((float)pX2), (float)0.0f, (float)((float)pZ2));
        }
        GlStateManager.func_187437_J();
    }

    public static void renderCircleDecTriPartCross(double r1, double r2, ITriangleFunction triangleFunction, int triCount) {
        for (int c = 0; c < 10; ++c) {
            int winkelDeg1 = 36 * c;
            int winkelDeg2 = 36 * (c + 1);
            int triIndex = c * 6;
            double winkelRad1 = Math.PI / 180 * (double)winkelDeg1;
            double winkelRad2 = Math.PI / 180 * (double)winkelDeg2;
            double pX1 = Math.sin(winkelRad1) * r1;
            double pZ1 = Math.cos(winkelRad1) * r1;
            double pX2 = Math.sin(winkelRad2) * r1;
            double pZ2 = Math.cos(winkelRad2) * r1;
            double pX1N = Math.sin(winkelRad1) * r2;
            double pZ1N = Math.cos(winkelRad1) * r2;
            double pX2N = Math.sin(winkelRad2) * r2;
            double pZ2N = Math.cos(winkelRad2) * r2;
            double cXF = (pX2 + pX1) / 2.0;
            double cZF = (pZ2 + pZ1) / 2.0;
            double cXN = (pX2N + pX1N) / 2.0;
            double cZN = (pZ2N + pZ1N) / 2.0;
            double cX = (cXF + cXN) / 2.0;
            double cZ = (cZF + cZN) / 2.0;
            double uX1 = cX + (cX - pX2N);
            double uZ1 = cZ + (cZ - pZ2N);
            double uX2 = cX + (cX - pX1N);
            double uZ2 = cZ + (cZ - pZ1N);
            GlStateManager.func_187447_r((int)6);
            GlStateManager.func_187435_e((float)((float)cX), (float)0.0f, (float)((float)cZ));
            if (triIndex < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex));
                GlStateManager.func_187435_e((float)((float)pX1N), (float)0.0f, (float)((float)pZ1N));
                GlStateManager.func_187435_e((float)((float)uX1), (float)0.0f, (float)((float)uZ1));
            }
            if (triIndex + 1 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 1));
                GlStateManager.func_187435_e((float)((float)uX2), (float)0.0f, (float)((float)uZ2));
            }
            if (triIndex + 2 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 2));
                GlStateManager.func_187435_e((float)((float)pX2N), (float)0.0f, (float)((float)pZ2N));
            }
            if (triIndex + 3 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 3));
                GlStateManager.func_187435_e((float)((float)pX1N), (float)0.0f, (float)((float)pZ1N));
            }
            GlStateManager.func_187437_J();
            GlStateManager.func_187447_r((int)4);
            if (triIndex + 4 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 4));
                GlStateManager.func_187435_e((float)((float)pX1), (float)0.0f, (float)((float)pZ1));
                GlStateManager.func_187435_e((float)((float)uX1), (float)0.0f, (float)((float)uZ1));
                GlStateManager.func_187435_e((float)((float)pX1N), (float)0.0f, (float)((float)pZ1N));
            }
            if (triIndex + 5 < triCount) {
                ColorUtil.applyColor(triangleFunction.apply(triIndex + 5));
                GlStateManager.func_187435_e((float)((float)pX2), (float)0.0f, (float)((float)pZ2));
                GlStateManager.func_187435_e((float)((float)pX2N), (float)0.0f, (float)((float)pZ2N));
                GlStateManager.func_187435_e((float)((float)uX2), (float)0.0f, (float)((float)uZ2));
            }
            GlStateManager.func_187437_J();
        }
    }
}

