/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.init.NCItems;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.fluids.FluidRegistry;

public class MelterRecipes
extends ProcessorRecipeHandler {
    private static final List<String> MELTING_BLACKLIST = Arrays.asList("coal", "redstone", "glowstone", "prismarine", "obsidian", "silicon");

    public MelterRecipes() {
        super("melter", 1, 0, 0, 1);
    }

    @Override
    public void addRecipes() {
        this.addRecipe("dustSulfur", this.fluidStack("sulfur", 666), 1.0, 1.0);
        this.addRecipe("dustSodiumHydroxide", this.fluidStack("naoh", 666), 1.0, 1.0);
        this.addRecipe("dustPotassiumHydroxide", this.fluidStack("koh", 666), 1.0, 1.0);
        this.addRecipe("dustArsenic", this.fluidStack("arsenic", 666), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"gemPrismarine", "dustPrismarine"}), this.fluidStack("prismarine", 144), 1.0, 1.0);
        this.addIngotMeltingRecipes("boron10");
        this.addIngotMeltingRecipes("boron11");
        this.addIngotMeltingRecipes("lithium6");
        this.addIngotMeltingRecipes("lithium7");
        this.addIngotMeltingRecipes("ferroboron");
        this.addIngotMeltingRecipes("tough");
        this.addIngotMeltingRecipes("hardCarbon", "hard_carbon");
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotSilicon", "itemSilicon"}), this.fluidStack("silicon", 144), 1.0, 1.0);
        this.addRecipe(NCItems.ground_cocoa_nibs, this.fluidStack("chocolate_liquor", 144), 0.25, 0.5);
        this.addRecipe(NCItems.cocoa_butter, this.fluidStack("cocoa_butter", 144), 0.25, 0.5);
        this.addRecipe(NCItems.unsweetened_chocolate, this.fluidStack("unsweetened_chocolate", 144), 0.25, 0.5);
        this.addRecipe(NCItems.dark_chocolate, this.fluidStack("dark_chocolate", 144), 0.25, 0.5);
        this.addRecipe(NCItems.milk_chocolate, this.fluidStack("milk_chocolate", 144), 0.25, 0.5);
        this.addRecipe(Items.field_151102_aT, this.fluidStack("sugar", 144), 0.5, 0.5);
        this.addRecipe(NCItems.gelatin, this.fluidStack("gelatin", 144), 0.5, 0.5);
        this.addRecipe(NCItems.marshmallow, this.fluidStack("marshmallow", 144), 0.5, 0.5);
        this.addRecipe("obsidian", this.fluidStack("obsidian", 288), 2.0, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotObsidian", "dustObsidian"}), this.fluidStack("obsidian", 72), 0.5, 2.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nuggetObsidian", "tinyDustObsidian"}), this.fluidStack("obsidian", 8), 0.05555555555555555, 2.0);
        this.addRecipe("sand", this.fluidStack("glass", 1000), 1.5, 1.5);
        this.addRecipe("blockGlass", this.fluidStack("glass", 1000), 1.5, 1.5);
        this.addRecipe(Blocks.field_150435_aG, this.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe(Items.field_151119_aD, this.fluidStack("clay", 144), 0.5, 1.5);
        this.addRecipe(Blocks.field_150336_V, this.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe("ingotBrick", this.fluidStack("clay", 144), 0.5, 1.5);
        this.addRecipe(Blocks.field_150405_ch, this.fluidStack("clay", 576), 2.0, 1.5);
        this.addRecipe("stone", this.fluidStack("stone", 72), 1.5, 1.5);
        this.addRecipe("cobblestone", this.fluidStack("stone", 72), 1.5, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dirt", "grass"}), this.fluidStack("dirt", 144), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dustRedstone", "ingotRedstone"}), this.fluidStack("redstone", 100), 0.25, 1.0);
        this.addRecipe("blockRedstone", this.fluidStack("redstone", 900), 2.0, 1.0);
        this.addRecipe("dustGlowstone", this.fluidStack("glowstone", 250), 0.25, 1.0);
        this.addRecipe("glowstone", this.fluidStack("glowstone", 1000), 2.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new Object[]{Items.field_151079_bi, "dustEnder"}), this.fluidStack("ender", 250), 0.5, 1.5);
        this.addRecipe("dustPyrotheum", this.fluidStack("pyrotheum", 250), 1.0, 1.0);
        this.addRecipe("dustCryotheum", this.fluidStack("cryotheum", 250), 1.0, 1.0);
        this.addRecipe("dustAerotheum", this.fluidStack("aerotheum", 250), 1.0, 1.0);
        this.addRecipe("dustPetrotheum", this.fluidStack("petrotheum", 250), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"coal", "dustCoal"}), this.fluidStack("coal", 100), 0.5, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingotGraphite", "dustGraphite"}), this.fluidStack("coal", 100), 0.5, 1.0);
        this.addRecipe("blockCoal", this.fluidStack("coal", 900), 4.5, 1.0);
        this.addRecipe("blockGraphite", this.fluidStack("coal", 900), 4.5, 1.0);
        this.addIngotMeltingRecipes("dilithium");
        this.addIngotMeltingRecipes("titanium");
        this.addIngotMeltingRecipes("manasteel");
        this.addIngotMeltingRecipes("terrasteel");
        this.addIngotMeltingRecipes("elementium");
        this.addIngotMeltingRecipes("refinedObsidian");
        this.addIngotMeltingRecipes("refinedGlowstone");
        this.addIngotMeltingRecipes("psi");
        this.addIngotMeltingRecipes("astralStarmetal");
        this.addIngotMeltingRecipes("baseEssence");
        this.addIngotMeltingRecipes("inferium");
        this.addIngotMeltingRecipes("prudentium");
        this.addIngotMeltingRecipes("intermedium");
        this.addIngotMeltingRecipes("superium");
        this.addIngotMeltingRecipes("supremium");
        this.addIsotopeMeltingRecipes("thorium", 230);
        this.addIngotMeltingRecipes("thorium232", "fuel_tbu");
        this.addIsotopeMeltingRecipes("uranium", 233, 235, 238);
        this.addIsotopeMeltingRecipes("neptunium", 236, 237);
        this.addIsotopeMeltingRecipes("plutonium", 238, 239, 241, 242);
        this.addIsotopeMeltingRecipes("americium", 241, 242, 243);
        this.addIsotopeMeltingRecipes("curium", 243, 245, 246, 247);
        this.addIsotopeMeltingRecipes("berkelium", 247, 248);
        this.addIsotopeMeltingRecipes("californium", 249, 250, 251, 252);
        for (String suffix : new String[]{"", "Oxide"}) {
            for (String prefix : new String[]{"fuel", "fuelRod"}) {
                this.addRecipe(prefix + "TBU" + suffix, this.fluidStack("fuel_tbu", 1296), 9.0);
            }
            for (String prefix : new String[]{"depletedFuel", "depletedFuelRod"}) {
                this.addRecipe(prefix + "TBU" + suffix, this.fluidStack("depleted_fuel_tbu", 1024), 7.111111111111111);
            }
        }
        this.addFissionFuelMeltingRecipes("uranium", "eu", 233, 235);
        this.addFissionFuelMeltingRecipes("neptunium", "en", 236);
        this.addFissionFuelMeltingRecipes("plutonium", "ep", 239, 241);
        this.addFissionFuelMeltingRecipes("americium", "ea", 242);
        this.addFissionFuelMeltingRecipes("curium", "ec", "m", 243, 245, 247);
        this.addFissionFuelMeltingRecipes("berkelium", "eb", 248);
        this.addFissionFuelMeltingRecipes("californium", "ec", "f", 249, 251);
        this.addRecipe(Blocks.field_150432_aD, this.fluidStack("water", 1000), 0.25, 0.5);
        this.addRecipe(Blocks.field_150403_cj, this.fluidStack("water", 1000), 0.5, 0.5);
        this.addOreMeltingRecipes();
        this.addRecipe("blockQuartz", this.fluidStack("quartz", 2664), 4.0, 1.0);
        this.addRecipe("blockLapis", this.fluidStack("lapis", 5994), 9.0, 1.0);
        this.addRecipe("blockDiamond", this.fluidStack("diamond", 5994), 9.0, 1.0);
        this.addRecipe("blockEmerald", this.fluidStack("emerald", 5994), 9.0, 1.0);
    }

    public void addIngotMeltingRecipes(String oreName, String fluidName) {
        oreName = StringHelper.capitalize(oreName);
        this.addRecipe("ore" + oreName, this.fluidStack(fluidName, 360), 1.25, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"ingot" + oreName, "dust" + oreName}), this.fluidStack(fluidName, 144), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nugget" + oreName, "tinyDust" + oreName}), this.fluidStack(fluidName, 16), 0.1111111111111111, 1.0);
        this.addRecipe("block" + oreName, this.fluidStack(fluidName, 1296), 9.0, 1.0);
    }

    public void addIngotMeltingRecipes(String name) {
        this.addIngotMeltingRecipes(name, name);
    }

    public void addGemMeltingRecipes(String name) {
        String oreName = StringHelper.capitalize(name);
        this.addRecipe("ore" + oreName, this.fluidStack(name, 1665), 1.25, 1.5);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"gem" + oreName, "dust" + oreName}), this.fluidStack(name, 666), 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"nugget" + oreName, "tinyDust" + oreName}), this.fluidStack(name, 74), 0.1111111111111111, 1.0);
    }

    public void addIsotopeMeltingRecipes(String element, int ... types) {
        for (int type : types) {
            this.addIngotMeltingRecipes(element + type, element + "_" + type);
        }
    }

    public void addFissionFuelMeltingRecipes(String element, String suffix, String suffixExtra, int ... types) {
        for (int type : types) {
            for (String oxide : new String[]{"", "Oxide"}) {
                for (String prefix : new String[]{"fuel", "fuelRod"}) {
                    this.addRecipe(prefix + "L" + suffix.toUpperCase() + suffixExtra + type + oxide, this.fluidStack("fuel_l" + suffix + suffixExtra + "_" + type, 1296), 9.0, 1.0);
                    this.addRecipe(prefix + "H" + suffix.toUpperCase() + suffixExtra + type + oxide, this.fluidStack("fuel_h" + suffix + suffixExtra + "_" + type, 1296), 9.0, 1.0);
                }
                for (String prefix : new String[]{"depletedFuel", "depletedFuelRod"}) {
                    this.addRecipe(prefix + "L" + suffix.toUpperCase() + suffixExtra + type + oxide, this.fluidStack("depleted_fuel_l" + suffix + suffixExtra + "_" + type, 1024), 7.111111111111111, 1.0);
                    this.addRecipe(prefix + "H" + suffix.toUpperCase() + suffixExtra + type + oxide, this.fluidStack("depleted_fuel_h" + suffix + suffixExtra + "_" + type, 1024), 7.111111111111111, 1.0);
                }
            }
        }
    }

    public void addFissionFuelMeltingRecipes(String element, String suffix, int ... types) {
        this.addFissionFuelMeltingRecipes(element, suffix, "", types);
    }

    public void addOreMeltingRecipes() {
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().keySet());
        for (String fluidName : fluidList) {
            if (MELTING_BLACKLIST.contains(fluidName)) continue;
            String materialName = StringHelper.capitalize(fluidName);
            String ore = "ore" + materialName;
            String ingot = "ingot" + materialName;
            String gem = "gem" + materialName;
            String dust = "dust" + materialName;
            if (OreDictHelper.oreExists(ingot) && OreDictHelper.oreExists(dust)) {
                this.addIngotMeltingRecipes(fluidName);
                continue;
            }
            if (!OreDictHelper.oreExists(gem) || !OreDictHelper.oreExists(dust)) continue;
            this.addGemMeltingRecipes(fluidName);
        }
    }
}

