/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.rf;

import gcewing.sg.PowerTE;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class RFPowerTE
extends PowerTE
implements IEnergyStorage {
    static final int maxEnergyBuffer = 4000000;
    static final double rfPerSGEnergyUnit = 80.0;
    private EnergyStorage storage = new EnergyStorage(4000000);

    public RFPowerTE() {
        super(4000000.0, 80.0);
    }

    @Override
    public String getScreenTitle() {
        return "RF SGPU";
    }

    @Override
    public String getUnitName() {
        return "RF";
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbttagcompound) {
        super.readContentsFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("capacity")) {
            int capacity = nbttagcompound.func_74762_e("capacity");
            int energy = nbttagcompound.func_74762_e("energy");
            this.storage = new EnergyStorage(capacity, capacity, capacity, energy);
        }
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbttagcompound) {
        super.writeContentsToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("capacity", this.storage.getMaxEnergyStored());
        nbttagcompound.func_74768_a("energy", this.storage.getEnergyStored());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability.equals((Object)CapabilityEnergy.ENERGY) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int result = this.storage.receiveEnergy(maxReceive, simulate);
        this.energyBuffer = this.storage.getEnergyStored();
        this.markChanged();
        return result;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int result = this.storage.extractEnergy(maxExtract, simulate);
        this.energyBuffer = this.storage.getEnergyStored();
        this.markChanged();
        return result;
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.storage.canExtract();
    }

    public boolean canReceive() {
        return this.storage.canReceive();
    }
}

