/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.render.entity;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.core.client.model.OBJLoaderGC;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderRockets
extends Render<EntityTieredRocket> {
    private OBJModel.OBJBakedModel rocketModel;
    private String model;

    public RenderRockets(RenderManager manager, String model) {
        super(manager);
        this.model = model;
        this.field_76989_e = 2.0f;
    }

    private void updateModel() {
        if (this.rocketModel == null) {
            try {
                IModel model = OBJLoaderGC.instance.loadModel(new ResourceLocation("galaxyspace", this.model + ".obj"));
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                this.rocketModel = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Base"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntityTieredRocket entity) {
        return TextureMap.field_110575_b;
    }

    public void doRender(EntityTieredRocket entity, double x, double y, double z, float entityYaw, float partialTicks) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)0.0f, (float)240.0f);
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks + 180.0f;
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)entity.getRenderOffsetY(), (float)0.0f);
        float rollAmplitude = entity.rollAmplitude / 3.0f - partialTicks;
        if (rollAmplitude > 0.0f) {
            float i = entity.getLaunched() ? (float)(5 - MathHelper.func_76141_d((float)(entity.timeUntilLaunch / 85))) / 10.0f : 0.3f;
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)rollAmplitude) * rollAmplitude * i * partialTicks), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)rollAmplitude) * rollAmplitude * i * partialTicks), (float)1.0f, (float)0.0f, (float)1.0f);
        }
        this.updateModel();
        this.func_110776_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        ClientUtil.drawBakedModel((IBakedModel)this.rocketModel);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public boolean shouldRender(EntityTieredRocket rocket, ICamera camera, double camX, double camY, double camZ) {
        AxisAlignedBB axisalignedbb = rocket.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5);
        return rocket.func_145770_h(camX, camY, camZ) && camera.func_78546_a(axisalignedbb);
    }
}

