/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.tiles;

import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctUnitStructural;
import cofh.thermaldynamics.duct.GridStructural;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.util.TickHandler;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class TileGridStructureBase
extends TileGrid {
    private Map<DuctToken, DuctUnit> ducts = null;

    public <T extends TileGridStructureBase> T addDuctUnits(DuctToken token, DuctUnit unit) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        if (this.ducts != null) {
            for (Map.Entry<DuctToken, DuctUnit> entry : this.ducts.entrySet()) {
                if (entry.getKey().equals(token)) continue;
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        builder.put((Object)token, (Object)unit);
        this.ducts = builder.build();
        return (T)this;
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public <T extends DuctUnit<T, G, C>, G extends MultiBlockGrid<T>, C> T getDuct(DuctToken<T, G, C> token) {
        DuctUnit ductUnit = this.ducts.get(token);
        if (ductUnit == null && token == DuctToken.STRUCTURAL) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            builder.putAll(this.ducts);
            DuctUnitStructural structural = new DuctUnitStructural((TileGrid)this, this.ducts.get(this.getPrimaryDuctToken()));
            builder.put(DuctToken.STRUCTURAL, (Object)structural);
            TickHandler.addMultiBlockToNextTickBatch(structural);
            this.ducts = builder.build();
            return (T)structural;
        }
        return (T)ductUnit;
    }

    protected abstract DuctToken getPrimaryDuctToken();

    public DuctUnit getPrimaryDuctUnit() {
        return this.getDuct(this.getPrimaryDuctToken());
    }

    @Override
    public Iterable<DuctUnit> getDuctUnits() {
        return this.ducts.values();
    }

    @Nullable
    public DuctUnitStructural getStructureUnitIfPresent() {
        return (DuctUnitStructural)this.ducts.get(DuctToken.STRUCTURAL);
    }

    @Override
    public boolean isPowered() {
        DuctUnitStructural ductUnit = (DuctUnitStructural)this.ducts.get(DuctToken.STRUCTURAL);
        if (ductUnit != null && ductUnit.grid != null && ((GridStructural)ductUnit.grid).rs != null) {
            for (int i = 0; i < 16; ++i) {
                if (((GridStructural)ductUnit.grid).rs.redstoneLevels[i] <= 0) continue;
                return true;
            }
        }
        return super.isPowered();
    }

    @Override
    public Duct getDuctType() {
        return this.getPrimaryDuctUnit().getDuctType();
    }

    @Override
    public TextureAtlasSprite getBaseIcon() {
        return this.getPrimaryDuctUnit().getBaseIcon();
    }
}

