/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseDataChannel {
    public String name;
    public List handlers = new ArrayList();
    protected EnumMap<Side, FMLEmbeddedChannel> pipes;

    public BaseDataChannel(String name, Object ... handlers) {
        this.name = name;
        DataHandler handler = new DataHandler(this);
        this.pipes = NetworkRegistry.INSTANCE.newChannel(name, new ChannelHandler[]{handler});
        this.handlers.add(this);
        for (Object h : handlers) {
            this.handlers.add(h);
        }
    }

    protected ChannelOutput openTarget(String message, Side fromSide, FMLOutboundHandler.OutboundTarget target) {
        return this.openTarget(message, fromSide, target, null);
    }

    protected ChannelOutput openTarget(String message, Side fromSide, FMLOutboundHandler.OutboundTarget target, Object arg) {
        DataPacket out = new DataPacket(this, fromSide, target, arg);
        out.writeUTF(message);
        return out;
    }

    public ChannelOutput openServer(String message) {
        return this.openTarget(message, Side.CLIENT, FMLOutboundHandler.OutboundTarget.TOSERVER);
    }

    public ChannelOutput openPlayer(EntityPlayer player, String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.PLAYER, player);
    }

    public ChannelOutput openAllPlayers(String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALL);
    }

    public ChannelOutput openAllAround(NetworkRegistry.TargetPoint point, String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT, point);
    }

    public ChannelOutput openDimension(int dimensionId, String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.DIMENSION, dimensionId);
    }

    public ChannelOutput openServerContainer(String message) {
        ChannelOutput out = this.openServer(".container.");
        out.writeUTF(message);
        return out;
    }

    public ChannelOutput openClientContainer(EntityPlayer player, String message) {
        ChannelOutput out = this.openPlayer(player, ".container.");
        out.writeUTF(message);
        return out;
    }

    @ServerMessageHandler(value=".container.")
    public void onServerContainerMessage(EntityPlayer player, ChannelInput data) {
        String message = data.readUTF();
        BaseDataChannel.doServerDispatch(player.field_71070_bA, message, player, data);
    }

    @SideOnly(value=Side.CLIENT)
    @ClientMessageHandler(value=".container.")
    public void onClientContainerMessage(ChannelInput data) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        String message = data.readUTF();
        BaseDataChannel.doClientDispatch(player.field_71070_bA, message, data);
    }

    protected void onReceiveFromClient(EntityPlayer player, ChannelInput data) {
        String message = data.readUTF();
        for (Object h : this.handlers) {
            if (!BaseDataChannel.serverDispatch(h, message, player, data)) continue;
            return;
        }
        System.out.printf("No ServerMessageHandler for '%s' found in registered handlers of %s\n", message, this);
    }

    public static void doServerDispatch(Object handler, String message, EntityPlayer player, ChannelInput data) {
        if (!BaseDataChannel.serverDispatch(handler, message, player, data)) {
            System.out.printf("No ServerMessageHandler for '%s' found in %s\n", message, handler.getClass().getName());
        }
    }

    public static boolean serverDispatch(Object handler, String message, EntityPlayer player, ChannelInput data) {
        Method meth;
        if (handler != null && (meth = HandlerMap.SERVER.get(handler, message)) != null) {
            try {
                meth.invoke(handler, player, data);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Exception while calling server-side handler %s.%s for message %s", handler.getClass().getName(), meth.getName(), message), e);
            }
            return true;
        }
        return false;
    }

    protected void onReceiveFromServer(ChannelInput data) {
        String message = data.readUTF();
        for (Object h : this.handlers) {
            if (!BaseDataChannel.clientDispatch(h, message, data)) continue;
            return;
        }
        System.out.printf("No ClientMessageHandler for '%s' found in registered handlers\n", message);
    }

    public static void doClientDispatch(Object handler, String message, ChannelInput data) {
        if (!BaseDataChannel.clientDispatch(handler, message, data)) {
            System.out.printf("No ClientMessageHandler for '%s' found in %s\n", message, handler.getClass().getName());
        }
    }

    public static boolean clientDispatch(Object handler, String message, ChannelInput data) {
        Method meth;
        if (handler != null && (meth = HandlerMap.CLIENT.get(handler, message)) != null) {
            try {
                meth.invoke(handler, data);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Exception while calling client-side handler %s.%s for message %s", handler.getClass().getName(), meth.getName(), message), e);
            }
            return true;
        }
        return false;
    }

    @ChannelHandler.Sharable
    protected static class DataHandler
    extends ChannelInboundHandlerAdapter {
        BaseDataChannel channel;

        DataHandler(BaseDataChannel channel) {
            this.channel = channel;
        }

        public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
            if (obj instanceof FMLProxyPacket) {
                this.handleProxyPacket(ctx, (FMLProxyPacket)obj);
            } else {
                System.out.printf("BaseDataChannel.DataHandler: Received unexpected message type %s\n", obj.getClass().getName());
            }
        }

        protected void handleProxyPacket(ChannelHandlerContext ctx, FMLProxyPacket msg) {
            ChannelInputStream data = new ChannelInputStream(msg.payload());
            if (ctx.channel() == this.channel.pipes.get(Side.SERVER)) {
                INetHandler net = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayerMP player = ((NetHandlerPlayServer)net).field_147369_b;
                player.func_184102_h().func_152344_a(() -> this.lambda$handleProxyPacket$0((EntityPlayer)player, data));
            } else {
                this.channel.onReceiveFromServer(data);
            }
        }

        private /* synthetic */ void lambda$handleProxyPacket$0(EntityPlayer player, ChannelInput data) {
            this.channel.onReceiveFromClient(player, data);
        }
    }

    static class DataPacket
    implements ChannelOutput {
        ByteBufOutputStream out = new ByteBufOutputStream(Unpooled.buffer());
        BaseDataChannel channel;
        Side side;
        FMLOutboundHandler.OutboundTarget target;
        Object arg;

        DataPacket(BaseDataChannel channel, Side side, FMLOutboundHandler.OutboundTarget target, Object arg) {
            this.channel = channel;
            this.side = side;
            this.target = target;
            this.arg = arg;
        }

        @Override
        public void write(byte[] b) {
            try {
                this.out.write(b);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            try {
                this.out.write(b, off, len);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(int b) {
            try {
                this.out.write(b);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeBoolean(boolean v) {
            try {
                this.out.writeBoolean(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeByte(int v) {
            try {
                this.out.writeByte(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeBytes(String s) {
            try {
                this.out.writeBytes(s);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeChar(int v) {
            try {
                this.out.writeChar(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeChars(String s) {
            try {
                this.out.writeChars(s);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeDouble(double v) {
            try {
                this.out.writeDouble(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeFloat(float v) {
            try {
                this.out.writeFloat(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeInt(int v) {
            try {
                this.out.writeInt(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeLong(long v) {
            try {
                this.out.writeLong(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeShort(int v) {
            try {
                this.out.writeShort(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeUTF(String s) {
            try {
                this.out.writeUTF(s);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ByteBuf payload = this.out.buffer();
            FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(payload), this.channel.name);
            FMLEmbeddedChannel pipe = this.channel.pipes.get(this.side);
            pipe.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)this.target);
            pipe.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(this.arg);
            pipe.writeAndFlush((Object)pkt).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    static class ChannelInputStream
    extends ByteBufInputStream
    implements ChannelInput {
        public ChannelInputStream(ByteBuf buf) {
            super(buf);
        }

        @Override
        public boolean readBoolean() {
            try {
                return super.readBoolean();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte readByte() {
            try {
                return super.readByte();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public char readChar() {
            try {
                return super.readChar();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public double readDouble() {
            try {
                return super.readDouble();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public float readFloat() {
            try {
                return super.readFloat();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void readFully(byte[] b) {
            try {
                super.readFully(b);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            try {
                super.readFully(b, off, len);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int readInt() {
            try {
                return super.readInt();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String readLine() {
            try {
                return super.readLine();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long readLong() {
            try {
                return super.readLong();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public short readShort() {
            try {
                return super.readShort();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int readUnsignedByte() {
            try {
                return super.readUnsignedByte();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int readUnsignedShort() {
            try {
                return super.readUnsignedShort();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String readUTF() {
            try {
                return super.readUTF();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int skipBytes(int n) {
            try {
                return super.skipBytes(n);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface ChannelOutput
    extends DataOutput {
        @Override
        public void write(byte[] var1);

        @Override
        public void write(byte[] var1, int var2, int var3);

        @Override
        public void write(int var1);

        @Override
        public void writeBoolean(boolean var1);

        @Override
        public void writeByte(int var1);

        @Override
        public void writeBytes(String var1);

        @Override
        public void writeChar(int var1);

        @Override
        public void writeChars(String var1);

        @Override
        public void writeDouble(double var1);

        @Override
        public void writeFloat(float var1);

        @Override
        public void writeInt(int var1);

        @Override
        public void writeLong(long var1);

        @Override
        public void writeShort(int var1);

        @Override
        public void writeUTF(String var1);

        public void close();
    }

    public static interface ChannelInput
    extends DataInput {
        @Override
        public boolean readBoolean();

        @Override
        public byte readByte();

        @Override
        public char readChar();

        @Override
        public double readDouble();

        @Override
        public float readFloat();

        @Override
        public void readFully(byte[] var1);

        @Override
        public void readFully(byte[] var1, int var2, int var3);

        @Override
        public int readInt();

        @Override
        public String readLine();

        @Override
        public long readLong();

        @Override
        public short readShort();

        @Override
        public int readUnsignedByte();

        @Override
        public int readUnsignedShort();

        @Override
        public String readUTF();

        @Override
        public int skipBytes(int var1);
    }

    protected static class ClassCache
    extends HashMap<Class, MethodCache> {
        protected ClassCache() {
        }

        public MethodCache get(Class key) {
            MethodCache result = (MethodCache)super.get(key);
            if (result == null) {
                result = new MethodCache();
                this.put(key, result);
            }
            return result;
        }
    }

    protected static class MethodCache
    extends HashMap<String, Method> {
        protected MethodCache() {
        }
    }

    protected static enum HandlerMap {
        SERVER(ServerMessageHandler.class){

            @Override
            protected String annotationValue(Object a) {
                return ((ServerMessageHandler)a).value();
            }
        }
        ,
        CLIENT(ClientMessageHandler.class){

            @Override
            protected String annotationValue(Object a) {
                return ((ClientMessageHandler)a).value();
            }
        };

        protected Class type;
        protected ClassCache classCache = new ClassCache();

        private HandlerMap(Class type) {
            this.type = type;
        }

        protected abstract String annotationValue(Object var1);

        public Method get(Object handler, String message) {
            Class<?> cls = handler.getClass();
            MethodCache cache = this.classCache.get(cls);
            Method meth = (Method)cache.get(message);
            if (meth == null) {
                for (Method m : cls.getMethods()) {
                    Object a = m.getAnnotation(this.type);
                    if (a == null || !this.annotationValue(a).equals(message)) continue;
                    cache.put(message, m);
                    meth = m;
                    break;
                }
            }
            return meth;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ClientMessageHandler {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ServerMessageHandler {
        public String value();
    }
}

