/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.util;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IngredientMap<T> {
    private final HashMap<IItemDefinition, List<IngredientMapEntry<T>>> entries = new HashMap();

    public IngredientMapEntry<T> register(IIngredient ingredient, T entry) {
        Set items = ingredient.getItems().stream().map(IItemStack::getDefinition).collect(Collectors.toSet());
        IngredientMapEntry<T> actualEntry = new IngredientMapEntry<T>(ingredient, entry);
        for (IItemDefinition item : items) {
            if (!this.entries.containsKey(item)) {
                this.entries.put(item, new ArrayList());
            }
            this.entries.get(item).add(actualEntry);
        }
        return actualEntry;
    }

    public void unregister(IngredientMapEntry<T> entry) {
        Set items = ((IngredientMapEntry)entry).ingredient.getItems().stream().map(IItemStack::getDefinition).collect(Collectors.toSet());
        for (IItemDefinition item : items) {
            if (!this.entries.containsKey(item)) continue;
            this.entries.get(item).remove(entry);
        }
    }

    public T getFirstEntry(IItemStack item) {
        for (IngredientMapEntry<T> entry : this.entries.get(item.getDefinition())) {
            if (!((IngredientMapEntry)entry).ingredient.matches(item)) continue;
            return (T)((IngredientMapEntry)entry).entry;
        }
        return null;
    }

    public List<T> getEntries(IItemStack item) {
        if (item == null || item.getDefinition() == null) {
            return Collections.EMPTY_LIST;
        }
        List<IngredientMapEntry<T>> entries = this.entries.get(item.getDefinition());
        if (entries != null) {
            return entries.stream().filter(entry -> ((IngredientMapEntry)entry).ingredient.matches(item)).map(entry -> ((IngredientMapEntry)entry).entry).collect(Collectors.toCollection(ArrayList::new));
        }
        return Collections.EMPTY_LIST;
    }

    public static class IngredientMapEntry<T> {
        private final IIngredient ingredient;
        private final T entry;

        public IngredientMapEntry(IIngredient ingredient, T entry) {
            this.ingredient = ingredient;
            this.entry = entry;
        }
    }
}

