/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.entangloporter;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.PacketHandler;
import mekanism.common.Tier;
import mekanism.common.base.TileNetworkList;
import mekanism.common.frequency.Frequency;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class InventoryFrequency
extends Frequency {
    public static final String ENTANGLOPORTER = "Entangloporter";
    public static final int FLUID_TANK_SIZE = Tier.FluidTankTier.ULTIMATE.output;
    public static final int GAS_TANK_SIZE = Tier.GasTankTier.ULTIMATE.output;
    public double storedEnergy;
    public FluidTank storedFluid;
    public GasTank storedGas;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public double temperature;

    public InventoryFrequency(String n, UUID uuid) {
        super(n, uuid);
        this.storedFluid = new FluidTank(FLUID_TANK_SIZE);
        this.storedGas = new GasTank(GAS_TANK_SIZE);
    }

    public InventoryFrequency(NBTTagCompound nbtTags) {
        super(nbtTags);
    }

    public InventoryFrequency(ByteBuf dataStream) {
        super(dataStream);
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74780_a("storedEnergy", this.storedEnergy);
        if (this.storedFluid.getFluid() != null) {
            nbtTags.func_74782_a("storedFluid", (NBTBase)this.storedFluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.storedGas.getGas() != null) {
            nbtTags.func_74782_a("storedGas", (NBTBase)this.storedGas.write(new NBTTagCompound()));
        }
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < 1; ++slotCount) {
            if (((ItemStack)this.inventory.get(slotCount)).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            ((ItemStack)this.inventory.get(slotCount)).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTags.func_74782_a("Items", (NBTBase)tagList);
        nbtTags.func_74780_a("temperature", this.temperature);
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.storedFluid = new FluidTank(FLUID_TANK_SIZE);
        this.storedGas = new GasTank(GAS_TANK_SIZE);
        this.storedEnergy = nbtTags.func_74769_h("storedEnergy");
        if (nbtTags.func_74764_b("storedFluid")) {
            this.storedFluid.readFromNBT(nbtTags.func_74775_l("storedFluid"));
        }
        if (nbtTags.func_74764_b("storedGas")) {
            this.storedGas.read(nbtTags.func_74775_l("storedGas"));
        }
        NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= 1) continue;
            this.inventory.set((int)slotID, (Object)InventoryUtils.loadFromNBT(tagCompound));
        }
        this.temperature = nbtTags.func_74769_h("temperature");
    }

    @Override
    public void write(TileNetworkList data) {
        super.write(data);
        data.add(this.storedEnergy);
        if (this.storedFluid.getFluid() != null) {
            data.add(true);
            data.add(FluidRegistry.getFluidName((FluidStack)this.storedFluid.getFluid()));
            data.add(this.storedFluid.getFluidAmount());
        } else {
            data.add(false);
        }
        if (this.storedGas.getGas() != null) {
            data.add(true);
            data.add(this.storedGas.getGasType().getID());
            data.add(this.storedGas.getStored());
        } else {
            data.add(false);
        }
        data.add(this.temperature);
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.storedFluid = new FluidTank(FLUID_TANK_SIZE);
        this.storedGas = new GasTank(GAS_TANK_SIZE);
        this.storedEnergy = dataStream.readDouble();
        if (dataStream.readBoolean()) {
            this.storedFluid.setFluid(new FluidStack(FluidRegistry.getFluid((String)PacketHandler.readString(dataStream)), dataStream.readInt()));
        } else {
            this.storedFluid.setFluid(null);
        }
        if (dataStream.readBoolean()) {
            this.storedGas.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.storedGas.setGas(null);
        }
        this.temperature = dataStream.readDouble();
    }
}

