/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.TileNetworkList;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTurbineRotor
extends TileEntityBasicBlock {
    public List<Coord4D> rotors = new ArrayList<Coord4D>();
    public boolean hasComplex;
    public String multiblockUUID;
    public int blades = 0;
    public int clientIndex;
    public float rotationLower;
    public float rotationUpper;

    public void onNeighborChange(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.updateRotors();
        }
    }

    public void updateRotors() {
        if (this.rotors.contains(Coord4D.get((TileEntity)this))) {
            this.rotors.add(Coord4D.get((TileEntity)this));
        }
        this.buildRotors();
        Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get((TileEntity)this)));
    }

    private void buildRotors() {
        ArrayList<Coord4D> newRotors = new ArrayList<Coord4D>();
        int newBlades = 0;
        boolean complex = false;
        String id = null;
        Coord4D pointer = Coord4D.get((TileEntity)this);
        while (this.isRotor(pointer.offset(EnumFacing.DOWN))) {
            pointer = pointer.offset(EnumFacing.DOWN);
        }
        while (true) {
            newRotors.add(pointer.clone());
            newBlades += ((TileEntityTurbineRotor)pointer.getTileEntity((IBlockAccess)this.field_145850_b)).getHousedBlades();
            if (!this.isRotor(pointer.offset(EnumFacing.UP))) break;
            pointer = pointer.offset(EnumFacing.UP);
        }
        if (this.isComplex(pointer.offset(EnumFacing.UP))) {
            id = ((TileEntityRotationalComplex)pointer.offset((EnumFacing)EnumFacing.UP).getTileEntity((IBlockAccess)this.field_145850_b)).multiblockUUID;
            complex = true;
        }
        for (Coord4D coord : newRotors) {
            TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)coord.getTileEntity((IBlockAccess)this.field_145850_b);
            int prevHoused = rotor.getHousedBlades();
            int prevBlades = rotor.blades;
            rotor.rotors = newRotors;
            rotor.blades = newBlades;
            rotor.multiblockUUID = id;
            rotor.hasComplex = this.rotors.indexOf(coord) == this.rotors.size() - 1 ? complex : false;
            Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(coord, rotor.getNetworkedData(new TileNetworkList())), new Range4D(coord));
        }
    }

    public boolean editBlade(boolean add) {
        if (!this.rotors.contains(Coord4D.get((TileEntity)this))) {
            this.rotors.add(Coord4D.get((TileEntity)this));
        }
        if (add && this.rotors.size() * 2 - this.blades > 0 || !add && this.blades > 0) {
            for (Coord4D coord : this.rotors) {
                TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)coord.getTileEntity((IBlockAccess)this.field_145850_b);
                rotor.internalEditBlade(add);
            }
            return true;
        }
        return false;
    }

    public void internalEditBlade(boolean add) {
        int prev = this.getHousedBlades();
        this.blades += add ? 1 : -1;
        if (this.getHousedBlades() != prev) {
            Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get((TileEntity)this)));
        }
    }

    public int getHousedBlades() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.rotors.size() > 0) {
                return Math.max(0, Math.min(2, this.blades - this.rotors.indexOf(Coord4D.get((TileEntity)this)) * 2));
            }
            return this.blades;
        }
        return this.blades;
    }

    private boolean isRotor(Coord4D coord) {
        return coord.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityTurbineRotor;
    }

    private boolean isComplex(Coord4D coord) {
        return coord.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityRotationalComplex;
    }

    public void onChunkLoad() {
        super.onChunkLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.updateRotors();
        }
    }

    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            int prevBlades = this.blades;
            int prevIndex = this.clientIndex;
            this.blades = dataStream.readInt();
            this.clientIndex = dataStream.readInt();
            this.multiblockUUID = dataStream.readBoolean() ? PacketHandler.readString((ByteBuf)dataStream) : null;
            if (prevBlades != this.blades || prevIndex != this.clientIndex) {
                this.rotationLower = 0.0f;
                this.rotationUpper = 0.0f;
            }
        }
    }

    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)this.getHousedBlades());
        data.add((Object)this.rotors.indexOf(Coord4D.get((TileEntity)this)));
        if (this.multiblockUUID != null) {
            data.add((Object)true);
            data.add((Object)this.multiblockUUID);
        } else {
            data.add((Object)false);
        }
        return data;
    }

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.blades = nbtTags.func_74762_e("blades");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("blades", this.getHousedBlades());
        return nbtTags;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void onUpdate() {
    }
}

