/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.utils.energy;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.machinemuse.numina.capabilities.energy.adapter.ElectricAdapter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class ElectricItemUtils {
    public static List<ElectricAdapter> electricItemsEquipped(EntityPlayer player) {
        ArrayList<ElectricAdapter> electrics = new ArrayList<ElectricAdapter>();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ElectricAdapter adapter = ElectricAdapter.wrap(player.func_184582_a(slot));
            if (adapter == null) continue;
            electrics.add(adapter);
        }
        return electrics;
    }

    public static int chargeEmulatedToolFromPlayerEnergy(EntityPlayer player, @Nonnull ItemStack emulatedTool) {
        int chargeAmount;
        int charge;
        if (player.field_70170_p.field_72995_K) {
            return 0;
        }
        ElectricAdapter adapter = ElectricAdapter.wrap(emulatedTool);
        if (adapter == null) {
            return 0;
        }
        int maxCharge = adapter.getMaxEnergyStored();
        if (maxCharge == (charge = adapter.getEnergyStored())) {
            return 0;
        }
        int playerEnergy = ElectricItemUtils.getPlayerEnergy(player);
        if (playerEnergy > maxCharge - charge) {
            adapter.receiveEnergy(maxCharge - charge, false);
            chargeAmount = ElectricItemUtils.drainPlayerEnergy(player, maxCharge - charge);
        } else {
            adapter.receiveEnergy(playerEnergy, false);
            chargeAmount = ElectricItemUtils.drainPlayerEnergy(player, playerEnergy);
        }
        return chargeAmount;
    }

    public static int getPlayerEnergy(EntityPlayer player) {
        int avail = 0;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            avail += adapter.getEnergyStored();
        }
        return avail;
    }

    public static int getMaxPlayerEnergy(EntityPlayer player) {
        int avail = 0;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            avail += adapter.getMaxEnergyStored();
        }
        return avail;
    }

    public static int drainPlayerEnergy(EntityPlayer player, int drainAmount) {
        if (player.field_70170_p.field_72995_K) {
            return 0;
        }
        int drainleft = drainAmount;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            if (drainleft <= 0) break;
            drainleft -= adapter.extractEnergy(drainleft, false);
        }
        return drainAmount - drainleft;
    }

    public static int givePlayerEnergy(EntityPlayer player, int rfToGive) {
        int rfLeft = rfToGive;
        for (ElectricAdapter adapter : ElectricItemUtils.electricItemsEquipped(player)) {
            if (rfLeft <= 0) break;
            rfLeft -= adapter.receiveEnergy(rfLeft, false);
        }
        return rfToGive - rfLeft;
    }

    public static int getItemEnergy(@Nonnull ItemStack itemStack) {
        ElectricAdapter adapter = ElectricAdapter.wrap(itemStack);
        if (adapter != null) {
            return adapter.getEnergyStored();
        }
        return 0;
    }

    public static int getMaxItemEnergy(@Nonnull ItemStack itemStack) {
        ElectricAdapter adapter = ElectricAdapter.wrap(itemStack);
        if (adapter != null) {
            return adapter.getEnergyStored();
        }
        return 0;
    }

    public static int chargeItem(@Nonnull ItemStack itemStack, int chargeAmount) {
        ElectricAdapter adapter = ElectricAdapter.wrap(itemStack);
        if (adapter != null) {
            return adapter.receiveEnergy(chargeAmount, false);
        }
        return 0;
    }
}

