/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.machinemuse.numina.client.render.MuseTextureUtils;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.gui.IClickable;
import net.machinemuse.numina.gui.frame.IGuiFrame;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.module.IToggleableModule;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.numina.utils.math.geometry.GradientAndArcCalculator;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import net.machinemuse.numina.utils.render.MuseRenderer;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.control.KeyBindingHelper;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.powersuits.gui.MuseGui;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableButton;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableKeybinding;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableModule;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;

public class KeybindConfigFrame
implements IGuiFrame {
    private static KeyBindingHelper keyBindingHelper = new KeyBindingHelper();
    protected Set<ClickableModule> modules = new HashSet<ClickableModule>();
    protected IClickable selectedClickie;
    protected ClickableKeybinding closestKeybind;
    protected EntityPlayer player;
    protected MusePoint2D ul;
    protected MusePoint2D br;
    protected MuseGui gui;
    protected boolean selecting;
    protected ClickableButton newKeybindButton;
    protected ClickableButton trashKeybindButton;
    protected long takenTime;

    public KeybindConfigFrame(MuseGui gui, MusePoint2D ul, MusePoint2D br, EntityPlayer player) {
        for (ClickableKeybinding kb : KeybindManager.getKeybindings()) {
            this.modules.addAll(kb.getBoundModules());
        }
        this.gui = gui;
        this.ul = ul;
        this.br = br;
        this.player = player;
        MusePoint2D center = br.plus(ul).times(0.5);
        this.newKeybindButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.newKeybind", (Object[])new Object[0]), center.plus(new MusePoint2D(0.0, -8.0)), true);
        this.trashKeybindButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.trashKeybind", (Object[])new Object[0]), center.plus(new MusePoint2D(0.0, 8.0)), true);
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        if (button == 0) {
            if (this.selectedClickie == null) {
                for (ClickableModule module : this.modules) {
                    if (!module.hitBox(x, y)) continue;
                    this.selectedClickie = module;
                    return;
                }
                for (ClickableKeybinding keybind : KeybindManager.getKeybindings()) {
                    if (!keybind.hitBox(x, y)) continue;
                    this.selectedClickie = keybind;
                    return;
                }
            }
            if (this.newKeybindButton.hitBox(x, y)) {
                this.selecting = true;
            }
        } else if (button == 1) {
            for (ClickableKeybinding keybind : KeybindManager.getKeybindings()) {
                if (!keybind.hitBox(x, y)) continue;
                keybind.toggleHUDState();
                return;
            }
        } else if (button > 2) {
            int key = button - 100;
            if (keyBindingHelper.keyBindingHasKey(key)) {
                this.takenTime = System.currentTimeMillis();
            }
            if (!keyBindingHelper.keyBindingHasKey(key)) {
                this.addKeybind(key, true);
            } else if (MPSConfig.INSTANCE.allowConflictingKeybinds()) {
                this.addKeybind(key, false);
            }
            this.selecting = false;
        }
    }

    public void refreshModules() {
        List<IPowerModule> installedModules = ModuleManager.INSTANCE.getPlayerInstalledModules(this.player);
        List<MusePoint2D> points = GradientAndArcCalculator.pointsInLine(installedModules.size(), new MusePoint2D(this.ul.getX() + 10.0, this.ul.getY() + 10.0), new MusePoint2D(this.ul.getX() + 10.0, this.br.getY() - 10.0));
        Iterator<MusePoint2D> pointIterator = points.iterator();
        for (IPowerModule module : installedModules) {
            if (!(module instanceof IToggleableModule) || this.alreadyAdded(module)) continue;
            ClickableModule clickie = new ClickableModule(module, pointIterator.next());
            this.modules.add(clickie);
        }
    }

    public boolean alreadyAdded(IPowerModule module) {
        for (ClickableModule clickie : this.modules) {
            if (!clickie.getModule().getDataName().equals(module.getDataName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
        if (button == 0) {
            if (this.selectedClickie != null && this.closestKeybind != null && this.selectedClickie instanceof ClickableModule) {
                this.closestKeybind.bindModule((ClickableModule)this.selectedClickie);
            } else if (this.selectedClickie != null && this.selectedClickie instanceof ClickableKeybinding && this.trashKeybindButton.hitBox(x, y)) {
                KeyBinding binding = ((ClickableKeybinding)this.selectedClickie).getKeyBinding();
                keyBindingHelper.removeKey(binding);
                keyBindingHelper.removeKey(binding.func_151463_i());
                KeybindManager.getKeybindings().remove(this.selectedClickie);
            }
            this.selectedClickie = null;
        }
    }

    @Override
    public void update(double mousex, double mousey) {
        if (this.selecting) {
            return;
        }
        this.refreshModules();
        this.closestKeybind = null;
        double closestDistance = Double.MAX_VALUE;
        if (this.selectedClickie != null) {
            this.selectedClickie.move(mousex, mousey);
            if (this.selectedClickie instanceof ClickableModule) {
                ClickableModule selectedModule = (ClickableModule)this.selectedClickie;
                for (ClickableKeybinding keybind : KeybindManager.getKeybindings()) {
                    double distance = keybind.getPosition().minus(selectedModule.getPosition()).distance();
                    if (!(distance < closestDistance) || !((closestDistance = distance) < 32.0)) continue;
                    this.closestKeybind = keybind;
                }
            }
        }
        for (ClickableKeybinding clickableKeybinding : KeybindManager.getKeybindings()) {
            if (clickableKeybinding != this.selectedClickie) {
                clickableKeybinding.unbindFarModules();
            }
            clickableKeybinding.attractBoundModules(this.selectedClickie);
        }
        for (IClickable iClickable : this.modules) {
            if (iClickable == this.selectedClickie) continue;
            this.repelOtherModules(iClickable);
        }
        for (IClickable iClickable : KeybindManager.getKeybindings()) {
            if (iClickable == this.selectedClickie) continue;
            this.repelOtherModules(iClickable);
        }
        for (IClickable iClickable : this.modules) {
            this.clampClickiePosition(iClickable);
        }
        for (IClickable iClickable : KeybindManager.getKeybindings()) {
            this.clampClickiePosition(iClickable);
        }
    }

    private void clampClickiePosition(IClickable clickie) {
        MusePoint2D position = clickie.getPosition();
        position.setX(this.clampDouble(position.getX(), this.ul.getX(), this.br.getX()));
        position.setY(this.clampDouble(position.getY(), this.ul.getY(), this.br.getY()));
    }

    private double clampDouble(double x, double lower, double upper) {
        if (x < lower) {
            return lower;
        }
        if (x > upper) {
            return upper;
        }
        return x;
    }

    private void repelOtherModules(IClickable module) {
        MusePoint2D modulePosition = module.getPosition();
        for (ClickableModule otherModule : this.modules) {
            if (otherModule == this.selectedClickie || otherModule == module || !(otherModule.getPosition().distanceTo(modulePosition) < 16.0)) continue;
            MusePoint2D euclideanDistance = otherModule.getPosition().minus(module.getPosition());
            MusePoint2D directionVector = euclideanDistance.normalize();
            MusePoint2D tangentTarget = directionVector.times(16.0).plus(module.getPosition());
            MusePoint2D midpointTangent = otherModule.getPosition().midpoint(tangentTarget);
            if (!(midpointTangent.distanceTo(module.getPosition()) > 2.0)) continue;
            otherModule.move(midpointTangent.getX(), midpointTangent.getY());
        }
    }

    @Override
    public void draw() {
        MusePoint2D center = this.ul.plus(this.br).times(0.5);
        RenderState.blendingOn();
        RenderState.on2D();
        if (this.selecting) {
            MuseRenderer.drawCenteredString(I18n.func_135052_a((String)"gui.powersuits.pressKey", (Object[])new Object[0]), center.getX(), center.getY());
            RenderState.off2D();
            RenderState.blendingOff();
            return;
        }
        this.newKeybindButton.draw();
        this.trashKeybindButton.draw();
        MuseTextureUtils.pushTexture("textures/atlas/blocks.png");
        MuseRenderer.drawCenteredString(I18n.func_135052_a((String)"gui.powersuits.keybindInstructions1", (Object[])new Object[0]), center.getX(), center.getY() + 40.0);
        MuseRenderer.drawCenteredString(I18n.func_135052_a((String)"gui.powersuits.keybindInstructions2", (Object[])new Object[0]), center.getX(), center.getY() + 50.0);
        MuseRenderer.drawCenteredString(I18n.func_135052_a((String)"gui.powersuits.keybindInstructions3", (Object[])new Object[0]), center.getX(), center.getY() + 60.0);
        MuseRenderer.drawCenteredString(I18n.func_135052_a((String)"gui.powersuits.keybindInstructions4", (Object[])new Object[0]), center.getX(), center.getY() + 70.0);
        if (this.takenTime + 1000L > System.currentTimeMillis()) {
            MusePoint2D pos = this.newKeybindButton.getPosition().plus(new MusePoint2D(0.0, -20.0));
            MuseRenderer.drawCenteredString(I18n.func_135052_a((String)"gui.powersuits.keybindTaken", (Object[])new Object[0]), pos.getX(), pos.getY());
        }
        for (ClickableModule module : this.modules) {
            module.draw();
        }
        for (ClickableKeybinding keybind : KeybindManager.getKeybindings()) {
            keybind.draw();
        }
        if (this.selectedClickie != null && this.closestKeybind != null) {
            MuseRenderer.drawLineBetween(this.selectedClickie, this.closestKeybind, Colour.YELLOW);
        }
        RenderState.off2D();
        RenderState.blendingOff();
        MuseTextureUtils.popTexture();
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        for (ClickableModule module : this.modules) {
            if (!module.hitBox(x, y)) continue;
            if (MPSConfig.INSTANCE.doAdditionalInfo()) {
                return module.getToolTip();
            }
            return Collections.singletonList(module.getLocalizedName(module.getModule()));
        }
        return null;
    }

    public void handleKeyboard() {
        if (this.selecting && Keyboard.getEventKeyState()) {
            int key = Keyboard.getEventKey();
            if (keyBindingHelper.keyBindingHasKey(key)) {
                this.takenTime = System.currentTimeMillis();
            }
            if (!keyBindingHelper.keyBindingHasKey(key)) {
                this.addKeybind(key, true);
            } else if (MPSConfig.INSTANCE.allowConflictingKeybinds()) {
                this.addKeybind(key, false);
            }
            this.selecting = false;
        }
    }

    private void addKeybind(int key, boolean free) {
        String name;
        try {
            name = Keyboard.getKeyName((int)key);
        }
        catch (Exception e) {
            name = "???";
        }
        KeyBinding keybind = new KeyBinding(name, key, "Modular Powersuits");
        ClickableKeybinding clickie = new ClickableKeybinding(keybind, this.newKeybindButton.getPosition().plus(new MusePoint2D(0.0, -20.0)), free, false);
        KeybindManager.getKeybindings().add(clickie);
    }
}

