/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.weapon;

import javax.annotation.Nonnull;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.heat.MuseHeatUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.math.MuseMathUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlasmaCannonModule
extends PowerModuleBase
implements IRightClickModule {
    public PlasmaCannonModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.fieldEmitter, 2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.hvcapacitor, 2));
        this.addBasePropertyDouble("plasmaEnergyPerTick", 100.0, "RF");
        this.addBasePropertyDouble("plasmaDamage", 2.0, "pt");
        this.addTradeoffPropertyDouble("amperage", "plasmaEnergyPerTick", 1500.0, "RF");
        this.addTradeoffPropertyDouble("amperage", "plasmaDamage", 38.0, "pt");
        this.addTradeoffPropertyDouble("voltage", "plasmaEnergyPerTick", 500.0, "RF");
        this.addTradeoffPropertyDouble("voltage", "plasmaExplosiveness", 0.5, "creeper");
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_WEAPON;
    }

    @Override
    public String getDataName() {
        return "plasmaCannon";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && ElectricItemUtils.getPlayerEnergy(playerIn) > 500) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        int chargeTicks = (int)MuseMathUtils.clampDouble(itemStack.func_77988_m() - timeLeft, 10.0, 50.0);
        if (!worldIn.field_72995_K) {
            double energyConsumption = this.getEnergyUsage(itemStack) * chargeTicks;
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLiving;
                MuseHeatUtils.heatPlayer(player, energyConsumption / 5000.0);
                if ((double)ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
                    ElectricItemUtils.drainPlayerEnergy(player, (int)energyConsumption);
                    double explosiveness = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "plasmaExplosiveness");
                    double damagingness = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "plasmaDamage");
                    EntityPlasmaBolt plasmaBolt = new EntityPlasmaBolt(worldIn, (EntityLivingBase)player, explosiveness, damagingness, chargeTicks);
                    worldIn.func_72838_d((Entity)plasmaBolt);
                }
            }
        }
    }

    @Override
    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "plasmaEnergyPerTick");
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.plasmaCannon;
    }
}

