/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.handler;

import asmodeuscore.api.dimension.IPlanetFog;
import asmodeuscore.core.handler.GalaxyMapHandler$LightningStormHandler;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class PlanetFogHandler {
    private static double fogX;
    private static double fogZ;
    private static boolean fogInit;
    private static float fogFarPlaneDistance;
    private static volatile transient Object[] \u9736;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGetFogColour(EntityViewRenderEvent.FogColors event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            World world = player.field_70170_p;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            IBlockState blockAtEyes = ActiveRenderInfo.func_186703_a((World)world, (Entity)event.getEntity(), (float)((float)event.getRenderPartialTicks()));
            if (blockAtEyes.func_185904_a() == Material.field_151587_i) {
                return;
            }
            Vec3d mixedColor = blockAtEyes.func_185904_a() == Material.field_151586_h ? PlanetFogHandler.getFogBlendColorWater(world, (EntityLivingBase)player, x, y, z, event.getRenderPartialTicks()) : PlanetFogHandler.getFogBlendColour(world, (EntityLivingBase)player, x, y, z, event.getRed(), event.getGreen(), event.getBlue(), event.getRenderPartialTicks());
            event.setRed((float)mixedColor.field_72450_a);
            event.setGreen((float)mixedColor.field_72448_b);
            event.setBlue((float)mixedColor.field_72449_c);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        if ((double)playerX == fogX && (double)playerZ == fogZ && fogInit) {
            PlanetFogHandler.renderFog(event.getFogMode(), fogFarPlaneDistance, 0.75f);
            return;
        }
        fogInit = true;
        int distance = 20;
        float fpDistanceBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                WorldProvider provider = world.field_73011_w;
                if (!(provider instanceof IPlanetFog)) continue;
                float distancePart = ((IPlanetFog)provider).getFogDensity(playerX + x, playerY, playerZ + z);
                float weightPart = 1.0f;
                if (x == -distance) {
                    xDiff = 1.0 - (entity.field_70165_t - (double)playerX);
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    xDiff = entity.field_70165_t - (double)playerX;
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (entity.field_70161_v - (double)playerZ);
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = entity.field_70161_v - (double)playerZ;
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                fpDistanceBiomeFog += distancePart;
                weightBiomeFog += weightPart;
            }
        }
        float weightMixed = distance * 2 * distance * 2;
        float weightDefault = weightMixed - weightBiomeFog;
        float fpDistanceBiomeFogAvg = weightBiomeFog == 0.0f ? 0.0f : fpDistanceBiomeFog / weightBiomeFog;
        float farPlaneDistance = (fpDistanceBiomeFog * 240.0f + event.getFarPlaneDistance() * weightDefault) / weightMixed;
        float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
        float farPlaneDistanceScale = (farPlaneDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / weightMixed;
        fogX = entity.field_70165_t;
        fogZ = entity.field_70161_v;
        fogFarPlaneDistance = (float)PlanetFogHandler.\u1e41("\u4a79", (float)farPlaneDistance, (float)event.getFarPlaneDistance());
        PlanetFogHandler.renderFog(event.getFogMode(), fogFarPlaneDistance, farPlaneDistanceScale);
    }

    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode < 0) {
            GL11.glFogf((int)2915, (float)0.0f);
            GL11.glFogf((int)2916, (float)farPlaneDistance);
        } else {
            GL11.glFogf((int)2915, (float)(farPlaneDistance * farPlaneDistanceScale));
            GL11.glFogf((int)2916, (float)farPlaneDistance);
        }
    }

    private static Vec3d postProcessColor(World world, EntityLivingBase player, float r, float g, float b, double renderPartialTicks) {
        int duration;
        double darkScale = (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * renderPartialTicks) * world.field_73011_w.func_76565_k();
        if (player.func_70644_a(MobEffects.field_76440_q)) {
            duration = player.func_70660_b(MobEffects.field_76440_q).func_76459_b();
            darkScale *= duration < 20 ? (double)(1.0f - (float)duration / 20.0f) : 0.0;
        }
        if (darkScale < 1.0) {
            darkScale = darkScale < 0.0 ? 0.0 : darkScale * darkScale;
            r = (float)((double)r * darkScale);
            g = (float)((double)g * darkScale);
            b = (float)((double)b * darkScale);
        }
        if (player.func_70644_a(MobEffects.field_76439_r)) {
            duration = player.func_70660_b(MobEffects.field_76439_r).func_76459_b();
            float brightness = duration > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)((float)(((double)duration - renderPartialTicks) * Math.PI * (double)0.2f))) * 0.3f;
            Object scale = 1.0f / r;
            scale = PlanetFogHandler.\u1e41("\u4a79", (float)scale, (float)(1.0f / g));
            scale = PlanetFogHandler.\u1e41("\u4a79", (float)scale, (float)(1.0f / b));
            r = r * (1.0f - brightness) + r * scale * brightness;
            g = g * (1.0f - brightness) + g * scale * brightness;
            b = b * (1.0f - brightness) + b * scale * brightness;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            float aR = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float aG = (r * 30.0f + g * 70.0f) / 100.0f;
            float aB = (r * 30.0f + b * 70.0f) / 100.0f;
            r = aR;
            g = aG;
            b = aB;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    private static Vec3d getFogBlendColorWater(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, double renderPartialTicks) {
        int distance = 2;
        float rBiomeFog = 0.0f;
        float gBiomeFog = 0.0f;
        float bBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                Biome biome = world.getBiomeForCoordsBody(new BlockPos((double)(playerX + x), playerEntity.field_70163_u, (double)(playerZ + z)));
                int waterColorMult = biome.getWaterColorMultiplier();
                float rPart = (waterColorMult & 0xFF0000) >> 16;
                float gPart = (waterColorMult & 0xFF00) >> 8;
                float bPart = waterColorMult & 0xFF;
                if (x == -distance) {
                    xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                } else if (x == distance) {
                    xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                }
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
            }
        }
        float weight = distance * 2 * distance * 2;
        float respirationLevel = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)playerEntity) * 0.2f;
        float rMixed = ((rBiomeFog /= 255.0f) * 0.02f + respirationLevel) / weight;
        float gMixed = ((gBiomeFog /= 255.0f) * 0.02f + respirationLevel) / weight;
        float bMixed = ((bBiomeFog /= 255.0f) * 0.2f + respirationLevel) / weight;
        return PlanetFogHandler.postProcessColor(world, playerEntity, rMixed, gMixed, bMixed, renderPartialTicks);
    }

    private static Vec3d getFogBlendColour(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, float defR, float defG, float defB, double renderPartialTicks) {
        float thunderStrength;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 6;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        float rBiomeFog = 0.0f;
        float gBiomeFog = 0.0f;
        float bBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                WorldProvider provider = world.field_73011_w;
                if (!(provider instanceof IPlanetFog)) continue;
                IPlanetFog biomeFog = (IPlanetFog)provider;
                int fogColour = biomeFog.getFogColor(playerX + x, playerY, playerZ + z);
                float rPart = (fogColour & 0xFF0000) >> 16;
                float gPart = (fogColour & 0xFF00) >> 8;
                float bPart = fogColour & 0xFF;
                float weightPart = 1.0f;
                if (x == -distance) {
                    xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
                weightBiomeFog += weightPart;
            }
        }
        if (weightBiomeFog == 0.0f || distance == 0) {
            return new Vec3d((double)defR, (double)defG, (double)defB);
        }
        rBiomeFog /= 255.0f;
        gBiomeFog /= 255.0f;
        bBiomeFog /= 255.0f;
        float celestialAngle = world.func_72826_c((float)renderPartialTicks);
        float baseScale = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float rScale = baseScale * 0.94f + 0.06f;
        float gScale = baseScale * 0.94f + 0.06f;
        float bScale = baseScale * 0.91f + 0.09f;
        float rainStrength = world.func_72867_j((float)renderPartialTicks);
        if (rainStrength > 0.0f) {
            rScale *= 1.0f - rainStrength * 0.5f;
            gScale *= 1.0f - rainStrength * 0.5f;
            bScale *= 1.0f - rainStrength * 0.4f;
        }
        if ((thunderStrength = world.func_72819_i((float)renderPartialTicks)) > 0.0f) {
            rScale *= 1.0f - thunderStrength * 0.5f;
            gScale *= 1.0f - thunderStrength * 0.5f;
            bScale *= 1.0f - thunderStrength * 0.5f;
        }
        Vec3d processedColor = PlanetFogHandler.postProcessColor(world, playerEntity, rBiomeFog *= rScale / weightBiomeFog, gBiomeFog *= gScale / weightBiomeFog, bBiomeFog *= bScale / weightBiomeFog, renderPartialTicks);
        rBiomeFog = (float)processedColor.field_72450_a;
        gBiomeFog = (float)processedColor.field_72448_b;
        bBiomeFog = (float)processedColor.field_72449_c;
        float weightMixed = distance * 2 * distance * 2;
        float weightDefault = weightMixed - weightBiomeFog;
        double x = (rBiomeFog * weightBiomeFog + defR * weightDefault) / weightMixed;
        double y = (gBiomeFog * weightBiomeFog + defG * weightDefault) / weightMixed;
        double z = (bBiomeFog * weightBiomeFog + defB * weightDefault) / weightMixed;
        return new Vec3d(x, y, z);
    }

    private static Object \u1e41(Object object, String string, MethodType methodType) {
        if (\u9736 == null) {
            \u9736 = new Object[1];
        }
        if (\u9736[0] == null) {
            PlanetFogHandler.\u9736[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(GalaxyMapHandler$LightningStormHandler.\ua65b("\ubf5d\u0973\ud2e6\ub208\u7978\u9022\uc986\ua6f7\uccd6\ubfd7\u9a1d\ufb7d\u99e0\uc097")), GalaxyMapHandler$LightningStormHandler.\ua65b("\ubf5a\u097b\ud2fe"), methodType).asType(methodType));
        }
        return \u9736[0];
    }
}

