/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import openblocks.common.tileentity.TileEntityGoldenEgg;
import org.lwjgl.opengl.GL11;

public class TileEntityGoldenEggRenderer
extends TileEntitySpecialRenderer<TileEntityGoldenEgg> {
    private static final float PHANTOM_SCALE = 1.5f;
    private static final Random RANDOM = new Random(432L);
    protected static BlockRendererDispatcher blockRenderer;

    private static void renderEgg(IBakedModel model, IBlockState state) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            TileEntityGoldenEggRenderer.renderQuads(vertexBuffer, model.func_188616_a(state, enumfacing, 0L));
        }
        TileEntityGoldenEggRenderer.renderQuads(vertexBuffer, model.func_188616_a(state, (EnumFacing)null, 0L));
        GL11.glPushMatrix();
        GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    private static void renderQuads(BufferBuilder vertexBuffer, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            vertexBuffer.func_178981_a(quad.func_178209_a());
        }
    }

    public void render(TileEntityGoldenEgg egg, double x, double y, double z, float partialTickTime, int destroyProgress, float alpha) {
        if (egg == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        float rotation = egg.getRotation(partialTickTime);
        float progress = egg.getProgress(partialTickTime);
        float offset = egg.getOffset(partialTickTime);
        GL11.glTranslatef((float)0.0f, (float)offset, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(TextureMap.field_110575_b);
        if (blockRenderer == null) {
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        BlockPos pos = egg.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)egg.func_145831_w(), (BlockPos)pos);
        IBlockState blockState = world.func_180495_p(pos);
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(blockState);
        TileEntityGoldenEggRenderer.renderEgg(model, blockState);
        TileEntityGoldenEgg.State state = egg.getState();
        if (state.specialEffects) {
            TileEntityGoldenEggRenderer.renderPhantom(model, blockState, rotation, progress, partialTickTime);
            TileEntityGoldenEggRenderer.renderStar(rotation, progress, Tessellator.func_178181_a(), partialTickTime);
        }
        GL11.glPopMatrix();
    }

    private static void renderPhantom(IBakedModel model, IBlockState state, float rotation, float progress, float partialTicks) {
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + 0.8f * progress));
        float scale = 1.5f * (0.2f + progress * 0.8f);
        GL11.glTranslatef((float)0.0f, (float)(-0.1f * progress), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        TileEntityGoldenEggRenderer.renderEgg(model, state);
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
    }

    private static void renderStar(float rotation, float progress, Tessellator tes, float partialTicks) {
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)(rotation * -0.2f % 360.0f), (float)0.5f, (float)1.0f, (float)0.5f);
        float BEAM_START_DISTANCE = 2.0f;
        float BEAM_END_DISTANCE = 10.0f;
        float MAX_OPACITY = 192.0f;
        RenderHelper.func_74518_a();
        float f2 = 0.0f;
        if (progress > 0.8f) {
            f2 = (progress - 0.8f) / 0.2f;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)false);
        RANDOM.setSeed(432L);
        BufferBuilder wr = tes.func_178180_c();
        int alpha = (int)(MAX_OPACITY * (1.0f - f2));
        int i = 0;
        while ((float)i < (progress + progress * progress) / 2.0f * 60.0f) {
            GL11.glRotatef((float)(RANDOM.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(RANDOM.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(RANDOM.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(RANDOM.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(RANDOM.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(RANDOM.nextFloat() * 360.0f + progress * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            float f3 = RANDOM.nextFloat() * BEAM_END_DISTANCE + 5.0f + f2 * 10.0f;
            float f4 = RANDOM.nextFloat() * BEAM_START_DISTANCE + 1.0f + f2 * 2.0f;
            wr.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 255, 255, alpha).func_181675_d();
            wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 255, 255, alpha).func_181675_d();
            wr.func_181662_b(-0.866 * (double)f4, (double)f3, (double)(-0.5f * f4)).func_181669_b(255, 0, 255, 0).func_181675_d();
            wr.func_181662_b(0.866 * (double)f4, (double)f3, (double)(-0.5f * f4)).func_181669_b(255, 0, 255, 0).func_181675_d();
            wr.func_181662_b(0.0, (double)f3, (double)(1.0f * f4)).func_181669_b(255, 0, 255, 0).func_181675_d();
            wr.func_181662_b(-0.866 * (double)f4, (double)f3, (double)(-0.5f * f4)).func_181669_b(255, 0, 255, 0).func_181675_d();
            tes.func_78381_a();
            ++i;
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
    }
}

