/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import java.util.List;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.FluidStackHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidIngredient
implements IFluidIngredient {
    public FluidStack stack;
    public String fluidName;
    public int amount;

    public FluidIngredient(FluidStack stack) {
        this.stack = stack;
        this.fluidName = FluidStackHelper.getFluidName(stack);
        this.amount = stack.amount;
    }

    public FluidIngredient(String fluidName, int amount) {
        this.stack = FluidRegistry.getFluidStack((String)fluidName, (int)amount);
        this.fluidName = fluidName;
        this.amount = amount;
    }

    @Override
    public FluidStack getStack() {
        return this.stack.copy();
    }

    @Override
    public String getIngredientName() {
        return this.fluidName;
    }

    @Override
    public String getIngredientNamesConcat() {
        return this.fluidName;
    }

    @Override
    public boolean matches(Object object, IngredientSorption type) {
        if (object instanceof Tank) {
            object = ((Tank)((Object)object)).getFluid();
        }
        if (object instanceof FluidStack) {
            FluidStack fluidstack = (FluidStack)object;
            if (!fluidstack.isFluidEqual(this.stack) || !FluidStack.areFluidStackTagsEqual((FluidStack)fluidstack, (FluidStack)this.stack)) {
                return false;
            }
            return type.checkStackSize(this.stack.amount, fluidstack.amount);
        }
        if (object instanceof FluidIngredient && this.matches(((FluidIngredient)object).stack, type)) {
            return type.checkStackSize(this.getMaxStackSize(), ((FluidIngredient)object).getMaxStackSize());
        }
        return false;
    }

    @Override
    public List<FluidStack> getInputStackList() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.stack});
    }

    @Override
    public List<FluidStack> getOutputStackList() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.stack});
    }

    @Override
    public int getMaxStackSize() {
        return this.amount;
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        this.amount = stackSize;
        this.stack.amount = stackSize;
    }
}

