/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import nc.recipe.ProcessorRecipeHandler;

public class ChemicalReactorRecipes
extends ProcessorRecipeHandler {
    public ChemicalReactorRecipes() {
        super("chemical_reactor", 0, 2, 0, 2);
    }

    @Override
    public void addRecipes() {
        this.addRecipe(this.fluidStackList(Lists.newArrayList((Object[])new String[]{"boron", "boron10", "boron11"}), 144), this.fluidStack("hydrogen", 3000), this.fluidStack("diborane", 1000), this.emptyFluidStack(), 1.5, 1.0);
        this.addRecipe(this.fluidStack("diborane", 500), this.fluidStack("water", 3000), this.fluidStack("boric_acid", 1000), this.fluidStack("hydrogen", 3000), 1.0, 1.0);
        this.addRecipe(this.fluidStack("nitrogen", 1000), this.fluidStack("hydrogen", 3000), this.fluidStack("ammonia", 1000), this.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(this.fluidStack("boric_acid", 1000), this.fluidStack("ammonia", 1000), this.fluidStack("boron_nitride_solution", 666), this.fluidStack("water", 2000), 1.5, 1.5);
        this.addRecipe(this.fluidStackList(Lists.newArrayList((Object[])new String[]{"lithium", "lithium6", "lithium7"}), 144), this.fluidStack("fluorine", 500), this.fluidStack("lif", 144), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("beryllium", 144), this.fluidStack("fluorine", 500), this.fluidStack("bef2", 144), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("sulfur", 666), this.fluidStack("oxygen", 1000), this.fluidStack("sulfur_dioxide", 1000), this.emptyFluidStack(), 1.0, 0.5);
        this.addRecipe(this.fluidStack("sulfur_dioxide", 2000), this.fluidStack("oxygen", 1000), this.fluidStack("sulfur_trioxide", 2000), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("sulfur_trioxide", 1000), this.fluidStack("water", 1000), this.fluidStack("sulfuric_acid", 1000), this.emptyFluidStack(), 1.5, 0.5);
        this.addRecipe(this.fluidStack("fluorite_water", 666), this.fluidStack("sulfuric_acid", 1000), this.fluidStack("hydrofluoric_acid", 2000), this.fluidStack("calcium_sulfate_solution", 666), 1.0, 1.0);
        this.addRecipe(this.fluidStack("sodium_fluoride_solution", 666), this.fluidStack("water", 1000), this.fluidStack("sodium_hydroxide_solution", 666), this.fluidStack("hydrofluoric_acid", 1000), 1.0, 1.0);
        this.addRecipe(this.fluidStack("potassium_fluoride_solution", 666), this.fluidStack("water", 1000), this.fluidStack("potassium_hydroxide_solution", 666), this.fluidStack("hydrofluoric_acid", 1000), 1.0, 1.0);
        this.addRecipe(this.fluidStack("sodium_fluoride_solution", 666), this.fluidStack("boric_acid", 2000), this.fluidStack("borax_solution", 333), this.fluidStack("hydrofluoric_acid", 1000), 1.5, 1.0);
        this.addRecipe(this.fluidStack("oxygen_difluoride", 1000), this.fluidStack("water", 1000), this.fluidStack("oxygen", 1000), this.fluidStack("hydrofluoric_acid", 2000), 1.5, 1.0);
        this.addRecipe(this.fluidStack("oxygen_difluoride", 1000), this.fluidStack("sulfur_dioxide", 1000), this.fluidStack("sulfur_trioxide", 1000), this.fluidStack("fluorine", 1000), 1.0, 1.5);
        this.addRecipe(this.fluidStack("oxygen", 1000), this.fluidStack("fluorine", 2000), this.fluidStack("oxygen_difluoride", 2000), this.emptyFluidStack(), 1.0, 1.5);
        this.addRecipe(this.fluidStack("sugar", 144), this.fluidStack("water", 1000), this.fluidStack("ethanol", 4000), this.fluidStack("carbon_dioxide", 4000), 1.5, 0.5);
        this.addRecipe(this.fluidStack("carbon_dioxide", 1000), this.fluidStack("hydrogen", 1000), this.fluidStack("carbon_monoxide", 1000), this.fluidStack("water", 1000), 2.0, 0.5);
        this.addRecipe(this.fluidStack("carbon_monoxide", 1000), this.fluidStack("hydrogen", 2000), this.fluidStack("methanol", 1000), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("methanol", 1000), this.fluidStack("hydrofluoric_acid", 1000), this.fluidStack("fluoromethane", 1000), this.fluidStack("water", 1000), 1.0, 1.0);
        this.addRecipe(this.fluidStack("fluoromethane", 1000), this.fluidStack("naoh", 666), this.fluidStack("ethene", 500), this.fluidStack("sodium_fluoride_solution", 666), 1.5, 1.0);
        this.addRecipe(this.fluidStack("fluoromethane", 1000), this.fluidStack("koh", 666), this.fluidStack("ethene", 500), this.fluidStack("potassium_fluoride_solution", 666), 1.5, 1.0);
        this.addRecipe(this.fluidStack("ethene", 1000), this.fluidStack("sulfuric_acid", 1000), this.fluidStack("ethanol", 1000), this.fluidStack("sulfur_trioxide", 1000), 1.0, 1.0);
        this.addRecipe(this.fluidStackList(Lists.newArrayList((Object[])new String[]{"boron", "boron10", "boron11"}), 144), this.fluidStack("arsenic", 666), this.fluidStack("bas", 666), this.emptyFluidStack(), 1.5, 1.5);
        this.addElementFluorideRecipes("thorium", "uranium", "plutonium");
        this.addIsotopeFluorideRecipes("thorium", 230);
        this.addIsotopeFluorideRecipes("uranium", 233, 235, 238);
        this.addIsotopeFluorideRecipes("neptunium", 236, 237);
        this.addIsotopeFluorideRecipes("plutonium", 238, 239, 241, 242);
        this.addIsotopeFluorideRecipes("americium", 241, 242, 243);
        this.addIsotopeFluorideRecipes("curium", 243, 245, 246, 247);
        this.addIsotopeFluorideRecipes("berkelium", 247, 248);
        this.addIsotopeFluorideRecipes("californium", 249, 250, 251, 252);
        this.addRecipe(this.fluidStack("fuel_tbu", 144), this.fluidStack("fluorine", 1000), this.fluidStack("fuel_tbu_fluoride", 144), this.emptyFluidStack(), 1.0, 1.0);
        this.addRecipe(this.fluidStack("depleted_fuel_tbu", 144), this.fluidStack("fluorine", 1000), this.fluidStack("depleted_fuel_tbu_fluoride", 144), this.emptyFluidStack(), 1.0, 1.0);
        this.addFissionFuelFluorideRecipes("eu", 233, 235);
        this.addFissionFuelFluorideRecipes("en", 236);
        this.addFissionFuelFluorideRecipes("ep", 239, 241);
        this.addFissionFuelFluorideRecipes("ea", 242);
        this.addFissionFuelFluorideRecipes("ecm", 243, 245, 247);
        this.addFissionFuelFluorideRecipes("eb", 248);
        this.addFissionFuelFluorideRecipes("ecf", 249, 251);
    }

    public void addElementFluorideRecipes(String ... elements) {
        for (String element : elements) {
            this.addRecipe(this.fluidStack(element, 144), this.fluidStack("fluorine", 1000), this.fluidStack(element + "_fluoride", 144), this.emptyFluidStack(), 1.0, 1.0);
        }
    }

    public void addIsotopeFluorideRecipes(String element, int ... types) {
        for (int type : types) {
            this.addRecipe(this.fluidStack(element + "_" + type, 144), this.fluidStack("fluorine", 1000), this.fluidStack(element + "_" + type + "_fluoride", 144), this.emptyFluidStack(), 1.0, 1.0);
        }
    }

    public void addFissionFuelFluorideRecipes(String suffix, int ... types) {
        for (int type : types) {
            for (String form : new String[]{"fuel_l", "fuel_h", "depleted_fuel_l", "depleted_fuel_h"}) {
                this.addRecipe(this.fluidStack(form + suffix + "_" + type, 144), this.fluidStack("fluorine", 1000), this.fluidStack(form + suffix + "_" + type + "_fluoride", 144), this.emptyFluidStack(), 1.0, 1.0);
            }
        }
    }
}

