/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import extracells.container.ContainerTerminal;
import extracells.container.StorageType;
import extracells.gridblock.ECBaseGridBlock;
import extracells.gui.GuiTerminal;
import extracells.inventory.IInventoryListener;
import extracells.inventory.InventoryPlain;
import extracells.models.PartModels;
import extracells.network.packet.part.PacketTerminalSelectFluidClient;
import extracells.part.PartECBase;
import extracells.util.AEUtils;
import extracells.util.FluidHelper;
import extracells.util.MachineSource;
import extracells.util.NetworkUtil;
import extracells.util.PermissionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class PartFluidTerminal
extends PartECBase
implements IGridTickable,
IInventoryListener {
    private final List<Object> containers = new ArrayList<Object>();
    protected final InventoryPlain inventory = new InventoryPlain("extracells.part.fluid.terminal", 2, 64, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return PartFluidTerminal.this.isItemValidForInputSlot(i, itemStack);
        }

        @Override
        protected void onContentsChanged() {
            PartFluidTerminal.this.saveData();
        }
    };
    protected Fluid currentFluid;
    protected MachineSource machineSource = new MachineSource(this);

    protected boolean isItemValidForInputSlot(int i, ItemStack itemStack) {
        return FluidHelper.isFluidContainer(itemStack);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.inventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        ItemStack stack = super.getItemStack(type);
        if (type.equals((Object)PartItemStack.WRENCH)) {
            stack.func_77978_p().func_82580_o("inventory");
        }
        return stack;
    }

    public void addContainer(ContainerTerminal containerTerminalFluid) {
        this.containers.add(containerTerminalFluid);
        this.sendCurrentFluid();
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 1.0f;
    }

    public void decreaseFirstSlot() {
        ItemStack slot = this.inventory.func_70301_a(0);
        slot.func_190920_e(slot.func_190916_E() - 1);
        if (slot.func_190916_E() <= 0) {
            this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    public void doWork() {
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot != null && !secondSlot.func_190926_b() && secondSlot.func_190916_E() >= secondSlot.func_77976_d()) {
            return;
        }
        ItemStack container = this.inventory.func_70301_a(0);
        if (!FluidHelper.isFluidContainer(container)) {
            return;
        }
        container = container.func_77946_l();
        container.func_190920_e(1);
        ECBaseGridBlock gridBlock = this.getGridBlock();
        if (gridBlock == null) {
            return;
        }
        IMEMonitor<IAEFluidStack> monitor = gridBlock.getFluidMonitor();
        if (monitor == null) {
            return;
        }
        if (FluidHelper.isDrainableFilledContainer(container)) {
            FluidStack containerFluid = FluidHelper.getFluidFromContainer(container);
            IAEFluidStack notInjected = (IAEFluidStack)monitor.injectItems((IAEStack)AEUtils.createFluidStack(containerFluid), Actionable.SIMULATE, (IActionSource)this.machineSource);
            if (notInjected != null) {
                return;
            }
            Pair<Integer, ItemStack> drainedContainer = FluidHelper.drainStack(container, containerFluid);
            ItemStack emptyContainer = (ItemStack)drainedContainer.getRight();
            if (emptyContainer == null || this.fillSecondSlot(emptyContainer)) {
                monitor.injectItems((IAEStack)AEUtils.createFluidStack(containerFluid), Actionable.MODULATE, (IActionSource)this.machineSource);
                this.decreaseFirstSlot();
            }
        } else if (FluidHelper.isFillableContainerWithRoom(container)) {
            if (this.currentFluid == null) {
                return;
            }
            int capacity = FluidHelper.getCapacity(container, this.currentFluid);
            IAEFluidStack result = (IAEFluidStack)monitor.extractItems((IAEStack)AEUtils.createFluidStack(this.currentFluid, (long)capacity), Actionable.SIMULATE, (IActionSource)this.machineSource);
            int proposedAmount = result == null ? 0 : (int)Math.min((long)capacity, result.getStackSize());
            Pair<Integer, ItemStack> filledContainer = FluidHelper.fillStack(container, new FluidStack(this.currentFluid, proposedAmount));
            if ((Integer)filledContainer.getLeft() > proposedAmount) {
                return;
            }
            if (this.fillSecondSlot((ItemStack)filledContainer.getRight())) {
                monitor.extractItems((IAEStack)AEUtils.createFluidStack(this.currentFluid, (long)((Integer)filledContainer.getLeft()).intValue()), Actionable.MODULATE, (IActionSource)this.machineSource);
                this.decreaseFirstSlot();
            }
        }
    }

    public boolean fillSecondSlot(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot == null || secondSlot.func_190926_b()) {
            this.inventory.func_70299_a(1, itemStack);
            return true;
        }
        if (!secondSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)secondSlot)) {
            return false;
        }
        this.inventory.incrStackSize(1, itemStack.func_190916_E());
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiTerminal(this, player, StorageType.FLUID);
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public double getPowerUsage() {
        return 0.5;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerTerminal(this, player, StorageType.FLUID);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (this.isActive() && (PermissionUtil.hasPermission(player, SecurityPermissions.INJECT, this) || PermissionUtil.hasPermission(player, SecurityPermissions.EXTRACT, this))) {
            return super.onActivate(player, hand, pos);
        }
        return false;
    }

    @Override
    public void onInventoryChanged() {
        this.saveData();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.readFromNBT(data.func_150295_c("inventory", 10));
    }

    public void removeContainer(ContainerTerminal containerTerminalFluid) {
        this.containers.remove(containerTerminalFluid);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IPartModel getStaticModels() {
        if (this.isActive()) {
            return PartModels.TERMINAL_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.TERMINAL_ON;
        }
        return PartModels.TERMINAL_OFF;
    }

    public void sendCurrentFluid() {
        for (Object containerFluidTerminal : this.containers) {
            this.sendCurrentFluid(containerFluidTerminal);
        }
    }

    public void sendCurrentFluid(Object container) {
        if (container instanceof ContainerTerminal) {
            ContainerTerminal containerFluidTerminal = (ContainerTerminal)container;
            NetworkUtil.sendToPlayer(new PacketTerminalSelectFluidClient(this.currentFluid), containerFluidTerminal.getPlayer());
        }
    }

    public void setCurrentFluid(Fluid currentFluid) {
        this.currentFluid = currentFluid;
        this.sendCurrentFluid();
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        this.doWork();
        return TickRateModulation.FASTER;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
    }
}

