/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import javax.annotation.Nonnull;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import sonar.core.api.energy.ISonarEnergyItem;
import sonar.core.api.utils.ActionType;
import sonar.core.integration.SonarLoader;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla")})
public class SonarEnergyItemWrapper
implements IEnergyStorage,
ICapabilityProvider,
ITeslaConsumer,
ITeslaProducer,
ITeslaHolder {
    public ISonarEnergyItem energyItem;
    public ItemStack stack;

    public SonarEnergyItemWrapper(ISonarEnergyItem energyItem, ItemStack stack) {
        this.energyItem = energyItem;
        this.stack = stack;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.energyItem.addEnergy(this.stack, maxReceive, ActionType.getTypeForAction(simulate));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.energyItem.removeEnergy(this.stack, maxExtract, ActionType.getTypeForAction(simulate));
    }

    public int getEnergyStored() {
        return (int)this.energyItem.getEnergyLevel(this.stack);
    }

    public int getMaxEnergyStored() {
        return (int)this.energyItem.getFullCapacity(this.stack);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    @Optional.Method(modid="tesla")
    public long getStoredPower() {
        return this.getEnergyStored();
    }

    @Optional.Method(modid="tesla")
    public long getCapacity() {
        return this.getMaxEnergyStored();
    }

    @Optional.Method(modid="tesla")
    public long takePower(long power, boolean simulated) {
        return this.energyItem.removeEnergy(this.stack, Math.min(Integer.MAX_VALUE, power), ActionType.getTypeForAction(simulated));
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulated) {
        return this.energyItem.addEnergy(this.stack, power, ActionType.getTypeForAction(simulated));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (SonarLoader.teslaLoaded) {
            return capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER;
        }
        return false;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        if (SonarLoader.teslaLoaded && (capability == TeslaCapabilities.CAPABILITY_CONSUMER || capability == TeslaCapabilities.CAPABILITY_PRODUCER || capability == TeslaCapabilities.CAPABILITY_HOLDER)) {
            return (T)this;
        }
        return null;
    }
}

