/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.core.command.CommandHandler;
import cofh.core.enchantment.EnchantmentSmashing;
import cofh.core.energy.FurnaceFuelHandler;
import cofh.core.gui.GuiHandler;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CorePotions;
import cofh.core.init.CoreProps;
import cofh.core.key.KeyHandlerCore;
import cofh.core.key.PacketKey;
import cofh.core.network.PacketCore;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketIndexedChat;
import cofh.core.network.PacketSocial;
import cofh.core.network.PacketTile;
import cofh.core.network.PacketTileInfo;
import cofh.core.proxy.Proxy;
import cofh.core.util.ConfigHandler;
import cofh.core.util.RegistrySocial;
import cofh.core.util.oredict.OreDictionaryArbiter;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="cofhcore", name="CoFH Core", version="4.6.1", dependencies="required-after:forge@[14.23.4.2705,15.0.0.0);required-after:redstoneflux@[2.1.0,2.2.0);", updateJSON="https://raw.github.com/cofh/version/master/cofhcore_update.json", acceptedMinecraftVersions="[1.12.2]")
public class CoFHCore {
    public static final String MOD_ID = "cofhcore";
    public static final String MOD_NAME = "CoFH Core";
    public static final String VERSION = "4.6.1";
    public static final String VERSION_MAX = "4.7.0";
    public static final String VERSION_GROUP = "required-after:cofhcore@[4.6.1,4.7.0);";
    public static final String UPDATE_URL = "https://raw.github.com/cofh/version/master/cofhcore_update.json";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.4.2705,15.0.0.0);required-after:redstoneflux@[2.1.0,2.2.0);";
    public static final String MOD_GUI_FACTORY = "cofh.core.gui.GuiConfigCoreFactory";
    @Mod.Instance(value="cofhcore")
    public static CoFHCore instance;
    @SidedProxy(clientSide="cofh.core.proxy.ProxyClient", serverSide="cofh.core.proxy.Proxy")
    public static Proxy proxy;
    public static final Logger LOG;
    public static final ConfigHandler CONFIG_CORE;
    public static final ConfigHandler CONFIG_LOOT;
    public static final ConfigHandler CONFIG_CLIENT;
    public static final GuiHandler GUI_HANDLER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CoreProps.configDir = event.getModConfigurationDirectory();
        CONFIG_CORE.setConfiguration(new Configuration(new File(CoreProps.configDir, "/cofh/core/common.cfg"), true));
        CONFIG_CLIENT.setConfiguration(new Configuration(new File(CoreProps.configDir, "/cofh/core/client.cfg"), true));
        CoreProps.preInit();
        CoreEnchantments.preInit();
        CorePotions.preInit();
        PacketHandler.preInit();
        this.addOreDictionaryEntries();
        this.registerHandlers();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        proxy.initialize(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PacketHandler.postInit();
        EnchantmentSmashing.initialize();
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        CONFIG_CORE.cleanUp(false, true);
        CONFIG_CLIENT.cleanUp(false, true);
        LOG.info("CoFH Core: Load Complete.");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerAboutToStartEvent event) {
        CoreProps.server = event.getServer();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)CommandHandler.INSTANCE);
    }

    @Mod.EventHandler
    public void handleIdMappingEvent(FMLModIdMappingEvent event) {
        OreDictionaryArbiter.refresh();
        FurnaceFuelHandler.refresh();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        OreDictionaryArbiter.initialize();
    }

    private void registerHandlers() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)GUI_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)KeyHandlerCore.INSTANCE);
        CommandHandler.initialize();
        FurnaceFuelHandler.initialize();
        RegistrySocial.initialize();
        PacketCore.initialize();
        PacketIndexedChat.initialize();
        PacketSocial.initialize();
        PacketKey.initialize();
        PacketTileInfo.initialize();
        PacketTile.initialize();
    }

    private void addOreDictionaryEntries() {
        OreDictionary.registerOre((String)"blockGlowstone", (ItemStack)new ItemStack(Blocks.field_150426_aN));
        OreDictionary.registerOre((String)"blockWool", (ItemStack)new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"coal", (ItemStack)new ItemStack(Items.field_151044_h));
        OreDictionary.registerOre((String)"charcoal", (ItemStack)new ItemStack(Items.field_151044_h, 1, 1));
        OreDictionary.registerOre((String)"dustBlaze", (ItemStack)new ItemStack(Items.field_151065_br));
        OreDictionary.registerOre((String)"rodBlaze", (ItemStack)new ItemStack(Items.field_151072_bj));
        OreDictionary.registerOre((String)"cropBeetroot", (Item)Items.field_185164_cV);
        OreDictionary.registerOre((String)"cropMelon", (Block)Blocks.field_150440_ba);
        OreDictionary.registerOre((String)"cropPumpkin", (Block)Blocks.field_150423_aK);
        OreDictionary.registerOre((String)"cropWheat", (Item)Items.field_151015_O);
        OreDictionary.registerOre((String)"seedBeetroot", (Item)Items.field_185163_cU);
        OreDictionary.registerOre((String)"seedMelon", (Item)Items.field_151081_bc);
        OreDictionary.registerOre((String)"seedPumpkin", (Item)Items.field_151080_bb);
        OreDictionary.registerOre((String)"seedWheat", (Item)Items.field_151014_N);
        OreDictionary.registerOre((String)"cofh:potion", (Item)Items.field_151068_bn);
    }

    static {
        LOG = LogManager.getLogger((String)MOD_ID);
        CONFIG_CORE = new ConfigHandler(VERSION);
        CONFIG_LOOT = new ConfigHandler(VERSION);
        CONFIG_CLIENT = new ConfigHandler(VERSION);
        GUI_HANDLER = new GuiHandler();
    }
}

