/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.packet;

import cf.terminator.laggoggles.profiler.TimingManager;
import cf.terminator.laggoggles.util.Coder;
import cf.terminator.laggoggles.util.Graphical;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ObjectData
implements IMessage {
    private TreeMap<Entry, Object> data = new TreeMap();
    public Type type;

    ObjectData() {
    }

    public ObjectData(int worldID, String name, String className, UUID id, long nanos, Type type_) {
        this.type = type_;
        this.data.put(Entry.WORLD_ID, worldID);
        this.data.put(Entry.ENTITY_NAME, name);
        this.data.put(Entry.ENTITY_CLASS_NAME, className);
        this.data.put(Entry.ENTITY_UUID, id);
        this.data.put(Entry.NANOS, nanos);
    }

    public ObjectData(int worldID, String name, String className, BlockPos pos, long nanos, Type type_) {
        this.type = type_;
        this.data.put(Entry.WORLD_ID, worldID);
        this.data.put(Entry.BLOCK_NAME, name);
        this.data.put(Entry.BLOCK_CLASS_NAME, className);
        this.data.put(Entry.BLOCK_POS_X, pos.func_177958_n());
        this.data.put(Entry.BLOCK_POS_Y, pos.func_177956_o());
        this.data.put(Entry.BLOCK_POS_Z, pos.func_177952_p());
        this.data.put(Entry.NANOS, nanos);
    }

    public ObjectData(TimingManager.EventTimings eventTimings, long nanos) {
        this.type = Type.EVENT_BUS_LISTENER;
        this.data.put(Entry.EVENT_BUS_EVENT_CLASS_NAME, Graphical.formatClassName(eventTimings.eventClass.toString()));
        this.data.put(Entry.EVENT_BUS_LISTENER, Graphical.formatClassName(eventTimings.listener));
        this.data.put(Entry.EVENT_BUS_THREAD_TYPE, eventTimings.threadType.ordinal());
        this.data.put(Entry.NANOS, nanos);
    }

    public <T> T getValue(Entry entry) {
        if (this.data.get((Object)entry) == null) {
            throw new IllegalArgumentException("Cant find the entry " + (Object)((Object)entry) + " for " + (Object)((Object)this.type));
        }
        return (T)this.data.get((Object)entry);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.data.size());
        for (Map.Entry<Entry, Object> entry : this.data.entrySet()) {
            buf.writeInt(entry.getKey().ordinal());
            entry.getKey().coder.write(entry.getValue(), buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.values()[buf.readInt()];
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Entry entry = Entry.values()[buf.readInt()];
            this.data.put(entry, entry.coder.read(buf));
        }
    }

    public String toString() {
        return this.type.toString() + ": " + this.data.toString();
    }

    public static enum Entry {
        WORLD_ID(Coder.INTEGER),
        ENTITY_NAME(Coder.STRING),
        ENTITY_UUID(Coder.UUID),
        ENTITY_CLASS_NAME(Coder.STRING),
        BLOCK_NAME(Coder.STRING),
        BLOCK_POS_X(Coder.INTEGER),
        BLOCK_POS_Y(Coder.INTEGER),
        BLOCK_POS_Z(Coder.INTEGER),
        BLOCK_CLASS_NAME(Coder.STRING),
        EVENT_BUS_LISTENER(Coder.STRING),
        EVENT_BUS_EVENT_CLASS_NAME(Coder.STRING),
        EVENT_BUS_THREAD_TYPE(Coder.INTEGER),
        NANOS(Coder.LONG);

        public final Coder coder;

        private Entry(Coder d) {
            this.coder = d;
        }
    }

    public static enum Type {
        ENTITY,
        TILE_ENTITY,
        BLOCK,
        EVENT_BUS_LISTENER,
        GUI_ENTITY,
        GUI_BLOCK;

    }
}

