/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;
import tinker_io.TinkerIO;
import tinker_io.block.base.BlockFacingTileEntity;
import tinker_io.helper.EasterEggsHelper;
import tinker_io.tileentity.TileEntityFuelInputMachine;

public class BlockFuelInputMachine
extends BlockFacingTileEntity<TileEntityFuelInputMachine> {
    public BlockFuelInputMachine(String name) {
        super(Material.field_151576_e, name);
    }

    @Override
    public Class<TileEntityFuelInputMachine> getTileEntityClass() {
        return TileEntityFuelInputMachine.class;
    }

    @Override
    @Nullable
    public TileEntityFuelInputMachine createTileEntity(World world, IBlockState state) {
        return new TileEntityFuelInputMachine();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                return false;
            }
            if (this.isActive(world, pos)) {
                player.openGui((Object)TinkerIO.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"tio.playerMessage.FIM.rightClick", (Object[])new Object[0])));
            }
        }
        EasterEggsHelper.displayMessage(world, pos, player);
        return true;
    }

    private boolean isActive(World world, BlockPos pos) {
        TileEntityFuelInputMachine tileEntityFuelInputMachine;
        TileSmeltery tileSmeltery;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFuelInputMachine && (tileSmeltery = (tileEntityFuelInputMachine = (TileEntityFuelInputMachine)tile).getMasterTile()) != null) {
            return tileEntityFuelInputMachine.getHasMaster() && tileSmeltery.isActive();
        }
        return false;
    }

    @Override
    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileSmelteryComponent) {
            ((TileSmelteryComponent)te).notifyMasterOfChange();
        }
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileSmelteryComponent) {
            ((TileSmelteryComponent)te).notifyMasterOfChange();
        }
        if (te instanceof TileEntityFuelInputMachine) {
            ((TileEntityFuelInputMachine)te).resetTemp();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }
}

