/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.chemical.dissolution")
@ModOnly(value="mtlib")
@ZenRegister
public class ChemicalDissolution {
    public static final String NAME = "Mekanism Chemical Dissolution Chamber";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IGasStack gasOutput) {
        if (itemInput == null || gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        DissolutionRecipe recipe = new DissolutionRecipe(InputHelper.toStack((IItemStack)itemInput), GasHelper.toGas(gasOutput));
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe(NAME, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient gasOutput, @Optional IIngredient itemInput) {
        if (gasOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get(), gasOutput, itemInput));
    }

    private static class Remove
    extends RemoveMekanismRecipe {
        private IIngredient gasOutput;
        private IIngredient itemInput;

        public Remove(String name, Map<MachineInput, MachineRecipe> map, IIngredient gasOutput, IIngredient itemInput) {
            super(name, map);
            this.gasOutput = gasOutput;
            this.itemInput = itemInput;
        }

        @Override
        public void addRecipes() {
            HashMap recipesToRemove = new HashMap();
            for (Map.Entry entry : RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get().entrySet()) {
                IItemStack inputItem = InputHelper.toIItemStack((ItemStack)((ItemStackInput)entry.getKey()).ingredient);
                CraftTweakerGasStack outputGas = new CraftTweakerGasStack(((GasOutput)((DissolutionRecipe)entry.getValue()).recipeOutput).output);
                if (!GasHelper.matches(this.gasOutput, outputGas) || !StackHelper.matches((IIngredient)this.itemInput, (IItemStack)inputItem)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logWarning((String)String.format("No %s recipe found for %s and %s. Command ignored!", ChemicalDissolution.NAME, this.gasOutput.toString(), this.itemInput.toString()));
            }
        }
    }
}

