/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multiblock;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.multiblock.TileEntityInternalMultiblock;
import mekanism.common.tile.TileEntityMultiblock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class UpdateProtocol<T extends SynchronizedData<T>> {
    public Set<Coord4D> iteratedNodes = new HashSet<Coord4D>();
    public Set<Coord4D> innerNodes = new HashSet<Coord4D>();
    public T structureFound = null;
    public TileEntityMultiblock<T> pointer;

    public UpdateProtocol(TileEntityMultiblock<T> tileEntity) {
        this.pointer = tileEntity;
    }

    public void loopThrough(Coord4D coord, Deque<Coord4D> queue) {
        int origX = coord.x;
        int origY = coord.y;
        int origZ = coord.z;
        boolean isCorner = true;
        boolean isHollow = true;
        boolean rightBlocks = true;
        boolean rightFrame = true;
        HashSet<Coord4D> locations = new HashSet<Coord4D>();
        int xmin = 0;
        int xmax = 0;
        int ymin = 0;
        int ymax = 0;
        int zmin = 0;
        int zmax = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        if (this.isViableNode(origX + 1, origY, origZ) && this.isViableNode(origX - 1, origY, origZ) || this.isViableNode(origX, origY + 1, origZ) && this.isViableNode(origX, origY - 1, origZ) || this.isViableNode(origX, origY, origZ + 1) && this.isViableNode(origX, origY, origZ - 1)) {
            isCorner = false;
        }
        if (isCorner) {
            if (this.isViableNode(origX + 1, origY, origZ)) {
                xmin = 0;
                while (this.isViableNode(origX + x + 1, origY, origZ)) {
                    ++x;
                }
                xmax = x;
            } else {
                xmax = 0;
                while (this.isViableNode(origX + x - 1, origY, origZ)) {
                    --x;
                }
                xmin = x;
            }
            if (this.isViableNode(origX, origY + 1, origZ)) {
                ymin = 0;
                while (this.isViableNode(origX, origY + y + 1, origZ)) {
                    ++y;
                }
                ymax = y;
            } else {
                ymax = 0;
                while (this.isViableNode(origX, origY + y - 1, origZ)) {
                    --y;
                }
                ymin = y;
            }
            if (this.isViableNode(origX, origY, origZ + 1)) {
                zmin = 0;
                while (this.isViableNode(origX, origY, origZ + z + 1)) {
                    ++z;
                }
                zmax = z;
            } else {
                zmax = 0;
                while (this.isViableNode(origX, origY, origZ + z - 1)) {
                    --z;
                }
                zmin = z;
            }
            for (x = xmin; x <= xmax; ++x) {
                for (y = ymin; y <= ymax; ++y) {
                    for (z = zmin; z <= zmax; ++z) {
                        if (x == xmin || x == xmax || y == ymin || y == ymax || z == zmin || z == zmax) {
                            if (!this.isViableNode(origX + x, origY + y, origZ + z)) {
                                rightBlocks = false;
                                break;
                            }
                            if (this.isFrame(coord.translate(x, y, z), origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax) && !this.isValidFrame(origX + x, origY + y, origZ + z)) {
                                rightFrame = false;
                                break;
                            }
                            locations.add(coord.translate(x, y, z));
                            continue;
                        }
                        if (!this.isValidInnerNode(origX + x, origY + y, origZ + z)) {
                            isHollow = false;
                            break;
                        }
                        if (this.isAir(origX + x, origY + y, origZ + z)) continue;
                        this.innerNodes.add(new Coord4D(origX + x, origY + y, origZ + z, this.pointer.func_145831_w().field_73011_w.getDimension()));
                    }
                    if (!isHollow || !rightBlocks || !rightFrame) break;
                }
                if (!isHollow || !rightBlocks || !rightFrame) break;
            }
        }
        if (Math.abs(xmax - xmin) + 1 <= 18 && Math.abs(ymax - ymin) + 1 <= 18 && Math.abs(zmax - zmin) + 1 <= 18 && rightBlocks && rightFrame && isHollow && isCorner) {
            T structure = this.getNewStructure();
            ((SynchronizedData)structure).locations = locations;
            ((SynchronizedData)structure).volLength = Math.abs(xmax - xmin) + 1;
            ((SynchronizedData)structure).volHeight = Math.abs(ymax - ymin) + 1;
            ((SynchronizedData)structure).volWidth = Math.abs(zmax - zmin) + 1;
            ((SynchronizedData)structure).volume = ((SynchronizedData)structure).volLength * ((SynchronizedData)structure).volHeight * ((SynchronizedData)structure).volWidth;
            ((SynchronizedData)structure).renderLocation = coord.translate(0, 1, 0);
            ((SynchronizedData)structure).minLocation = coord.translate(xmin, ymin, zmin);
            ((SynchronizedData)structure).maxLocation = coord.translate(xmax, ymax, zmax);
            if (((SynchronizedData)structure).volLength >= 3 && ((SynchronizedData)structure).volHeight >= 3 && ((SynchronizedData)structure).volWidth >= 3) {
                this.onStructureCreated(structure, origX, origY, origZ, xmin, xmax, ymin, ymax, zmin, zmax);
                if (((SynchronizedData)structure).locations.contains(Coord4D.get(this.pointer)) && this.isCorrectCorner(coord, origX + xmin, origY + ymin, origZ + zmin) && this.canForm(structure)) {
                    this.structureFound = structure;
                    return;
                }
            }
        }
        this.innerNodes.clear();
        this.iteratedNodes.add(coord);
        if (this.iteratedNodes.size() > 2048) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D sideCoord = coord.offset(side);
            if (!this.isViableNode(sideCoord.getPos()) || this.iteratedNodes.contains(sideCoord)) continue;
            queue.addLast(sideCoord);
        }
    }

    protected boolean canForm(T structure) {
        return true;
    }

    public EnumFacing getSide(Coord4D obj, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        if (obj.x == xmin) {
            return EnumFacing.WEST;
        }
        if (obj.x == xmax) {
            return EnumFacing.EAST;
        }
        if (obj.y == ymin) {
            return EnumFacing.DOWN;
        }
        if (obj.y == ymax) {
            return EnumFacing.UP;
        }
        if (obj.z == zmin) {
            return EnumFacing.NORTH;
        }
        if (obj.z == zmax) {
            return EnumFacing.SOUTH;
        }
        return null;
    }

    protected boolean isAir(int x, int y, int z) {
        return this.pointer.func_145831_w().func_175623_d(new BlockPos(x, y, z));
    }

    protected boolean isValidInnerNode(int x, int y, int z) {
        return this.isAir(x, y, z);
    }

    public boolean isViableNode(int x, int y, int z) {
        TileEntity tile = new Coord4D(x, y, z, this.pointer.func_145831_w().field_73011_w.getDimension()).getTileEntity((IBlockAccess)this.pointer.func_145831_w());
        if (tile instanceof IStructuralMultiblock && ((IStructuralMultiblock)tile).canInterface(this.pointer)) {
            return true;
        }
        return MultiblockManager.areEqual(tile, this.pointer);
    }

    public boolean isViableNode(BlockPos pos) {
        TileEntity tile = new Coord4D(pos, this.pointer.func_145831_w()).getTileEntity((IBlockAccess)this.pointer.func_145831_w());
        if (tile == null || !tile.func_145830_o() || tile.func_145837_r()) {
            return false;
        }
        if (tile instanceof IStructuralMultiblock && ((IStructuralMultiblock)tile).canInterface(this.pointer)) {
            return true;
        }
        return MultiblockManager.areEqual(tile, this.pointer);
    }

    private boolean isCorrectCorner(Coord4D obj, int xmin, int ymin, int zmin) {
        return obj.x == xmin && obj.y == ymin && obj.z == zmin;
    }

    private boolean isFrame(Coord4D obj, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        if (obj.x == xmin && obj.y == ymin) {
            return true;
        }
        if (obj.x == xmax && obj.y == ymin) {
            return true;
        }
        if (obj.x == xmin && obj.y == ymax) {
            return true;
        }
        if (obj.x == xmax && obj.y == ymax) {
            return true;
        }
        if (obj.x == xmin && obj.z == zmin) {
            return true;
        }
        if (obj.x == xmax && obj.z == zmin) {
            return true;
        }
        if (obj.x == xmin && obj.z == zmax) {
            return true;
        }
        if (obj.x == xmax && obj.z == zmax) {
            return true;
        }
        if (obj.y == ymin && obj.z == zmin) {
            return true;
        }
        if (obj.y == ymax && obj.z == zmin) {
            return true;
        }
        if (obj.y == ymin && obj.z == zmax) {
            return true;
        }
        return obj.y == ymax && obj.z == zmax;
    }

    protected abstract boolean isValidFrame(int var1, int var2, int var3);

    protected abstract MultiblockCache<T> getNewCache();

    protected abstract T getNewStructure();

    protected abstract MultiblockManager<T> getManager();

    protected abstract void mergeCaches(List<ItemStack> var1, MultiblockCache<T> var2, MultiblockCache<T> var3);

    protected void onFormed() {
        for (Coord4D coord : ((SynchronizedData)this.structureFound).internalLocations) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (!(tile instanceof TileEntityInternalMultiblock)) continue;
            ((TileEntityInternalMultiblock)tile).setMultiblock(((SynchronizedData)this.structureFound).inventoryID);
        }
    }

    protected void onStructureCreated(T structure, int origX, int origY, int origZ, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
    }

    public void onStructureDestroyed(T structure) {
        for (Coord4D coord : ((SynchronizedData)structure).internalLocations) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (!(tile instanceof TileEntityInternalMultiblock)) continue;
            ((TileEntityInternalMultiblock)tile).setMultiblock(null);
        }
    }

    public void killInnerNode(Coord4D coord) {
        TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
        if (tile instanceof TileEntityInternalMultiblock) {
            ((TileEntityInternalMultiblock)tile).setMultiblock(null);
        }
    }

    public void doUpdate() {
        LinkedList<Coord4D> pathingQueue = new LinkedList<Coord4D>();
        pathingQueue.add(Coord4D.get(this.pointer));
        while (pathingQueue.peek() != null) {
            Coord4D next = (Coord4D)pathingQueue.removeFirst();
            if (this.iteratedNodes.contains(next)) continue;
            this.loopThrough(next, pathingQueue);
        }
        if (this.structureFound != null) {
            for (Coord4D coord : this.iteratedNodes) {
                if (((SynchronizedData)this.structureFound).locations.contains(coord)) continue;
                for (Coord4D newCoord : this.iteratedNodes) {
                    TileEntity tile = newCoord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                    if (tile instanceof TileEntityMultiblock) {
                        ((TileEntityMultiblock)tile).structure = null;
                        continue;
                    }
                    if (!(tile instanceof IStructuralMultiblock)) continue;
                    ((IStructuralMultiblock)tile).setController(null);
                }
                for (Coord4D newCoord : this.innerNodes) {
                    this.killInnerNode(newCoord);
                }
                return;
            }
            ArrayList<String> idsFound = new ArrayList<String>();
            String idToUse = null;
            for (Coord4D obj : ((SynchronizedData)this.structureFound).locations) {
                TileEntity tileEntity = obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (!(tileEntity instanceof TileEntityMultiblock) || ((TileEntityMultiblock)tileEntity).cachedID == null) continue;
                idsFound.add(((TileEntityMultiblock)tileEntity).cachedID);
            }
            MultiblockCache<T> cache = this.getNewCache();
            ArrayList<ItemStack> rejectedItems = new ArrayList<ItemStack>();
            if (!idsFound.isEmpty()) {
                for (String id : idsFound) {
                    if (this.getManager().inventories.get(id) == null) continue;
                    if (cache == null) {
                        cache = this.getManager().pullInventory(this.pointer.func_145831_w(), id);
                    } else {
                        this.mergeCaches(rejectedItems, cache, this.getManager().pullInventory(this.pointer.func_145831_w(), id));
                    }
                    idToUse = id;
                }
            } else {
                idToUse = this.getManager().getUniqueInventoryID();
            }
            cache.apply(this.structureFound);
            ((SynchronizedData)this.structureFound).inventoryID = idToUse;
            this.onFormed();
            ArrayList<IStructuralMultiblock> structures = new ArrayList<IStructuralMultiblock>();
            Coord4D toUse = null;
            for (Coord4D obj : ((SynchronizedData)this.structureFound).locations) {
                TileEntity tileEntity = obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (tileEntity instanceof TileEntityMultiblock) {
                    ((TileEntityMultiblock)tileEntity).structure = this.structureFound;
                    if (toUse != null) continue;
                    toUse = obj;
                    continue;
                }
                if (!(tileEntity instanceof IStructuralMultiblock)) continue;
                structures.add((IStructuralMultiblock)tileEntity);
            }
            for (IStructuralMultiblock node : structures) {
                node.setController(toUse);
                ((SynchronizedData)this.structureFound).locations.remove(Coord4D.get((TileEntity)node));
            }
        } else {
            for (Coord4D coord : this.iteratedNodes) {
                TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (tile instanceof TileEntityMultiblock) {
                    TileEntityMultiblock tileEntity = (TileEntityMultiblock)tile;
                    if (tileEntity.structure != null && !((SynchronizedData)tileEntity.structure).destroyed) {
                        this.onStructureDestroyed(tileEntity.structure);
                        ((SynchronizedData)tileEntity.structure).destroyed = true;
                    }
                    tileEntity.structure = null;
                    continue;
                }
                if (!(tile instanceof IStructuralMultiblock)) continue;
                ((IStructuralMultiblock)tile).setController(null);
            }
            for (Coord4D coord : this.innerNodes) {
                this.killInnerNode(coord);
            }
        }
    }

    public static abstract class NodeChecker {
        public abstract boolean isValid(Coord4D var1);

        public boolean shouldContinue(int iterated) {
            return true;
        }
    }

    public class NodeCounter {
        public Set<Coord4D> iterated = new HashSet<Coord4D>();
        public NodeChecker checker;

        public NodeCounter(NodeChecker c) {
            this.checker = c;
        }

        public void loop(Coord4D pos) {
            this.iterated.add(pos);
            if (!this.checker.shouldContinue(this.iterated.size())) {
                return;
            }
            for (EnumFacing side : EnumFacing.field_82609_l) {
                Coord4D coord = pos.offset(side);
                if (this.iterated.contains(coord) || !this.checker.isValid(coord)) continue;
                this.loop(coord);
            }
        }

        public int calculate(Coord4D coord) {
            if (!this.checker.isValid(coord)) {
                return 0;
            }
            this.loop(coord);
            return this.iterated.size();
        }
    }
}

