/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import java.util.Random;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IMergedBlock;
import net.malisis.core.block.ISmartCull;
import net.malisis.core.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SlabComponent
implements IBlockComponent,
IMergedBlock,
ISmartCull {
    public PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");
    public PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public PropertyBool[] getProperties() {
        return new PropertyBool[]{this.TOP, this.BOTTOM};
    }

    public PropertyBool getTopProperty() {
        return this.TOP;
    }

    public PropertyBool getBottomProperty() {
        return this.BOTTOM;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getBottomProperty(), (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)this.getTopProperty(), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean canMerge(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        return !SlabComponent.isDoubleSlab((IBlockAccess)world, pos);
    }

    @Override
    public IBlockState mergeBlock(World world, BlockPos pos, IBlockState state, ItemStack itemStack, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        int z;
        int y;
        int x = (int)Math.floor(hitX + (float)side.func_82601_c() * 0.4f);
        BlockPos hitPos = new BlockPos((Vec3i)pos).func_177982_a(x, y = (int)Math.floor(hitY + (float)side.func_96559_d() * 0.4f), z = (int)Math.floor(hitZ + (float)side.func_82599_e() * 0.4f));
        return hitPos.equals((Object)pos) ? state.func_177226_a((IProperty)this.TOP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)this.BOTTOM, (Comparable)Boolean.valueOf(true)) : null;
    }

    @Override
    public IBlockState getStateForPlacement(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        boolean bottom = facing != EnumFacing.DOWN && (facing == EnumFacing.UP || hitY <= 0.5f);
        return state.func_177226_a((IProperty)this.getBottomProperty(), (Comparable)Boolean.valueOf(bottom)).func_177226_a((IProperty)this.getTopProperty(), (Comparable)Boolean.valueOf(!bottom));
    }

    @Override
    public AxisAlignedBB getBoundingBox(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (SlabComponent.isDoubleSlab(state)) {
            return AABBUtils.identity();
        }
        return (Boolean)state.func_177229_b((IProperty)this.getBottomProperty()) != false ? BOTTOM_AABB : TOP_AABB;
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)this.getBottomProperty(), (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)this.getTopProperty(), (Comparable)Boolean.valueOf((meta & 2) != 0));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)this.getBottomProperty()) != false ? 1 : 0) + ((Boolean)state.func_177229_b((IProperty)this.getTopProperty()) != false ? 2 : 0);
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return SlabComponent.isDoubleSlab(state);
    }

    @Override
    public Boolean isFullBlock(Block block, IBlockState state) {
        return SlabComponent.isDoubleSlab(state);
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return SlabComponent.isDoubleSlab(state);
    }

    @Override
    public Integer getPackedLightmapCoords(Block block, IBlockAccess world, BlockPos pos, IBlockState state) {
        return null;
    }

    @Override
    public Integer quantityDropped(Block block, IBlockState state, int fortune, Random random) {
        return SlabComponent.isDoubleSlab(state) ? 2 : 1;
    }

    @Override
    public int damageDropped(Block block, IBlockState state) {
        return 1;
    }

    @Override
    public Integer getLightOpacity(Block block, IBlockAccess world, BlockPos pos, IBlockState state) {
        return SlabComponent.isDoubleSlab(world, pos) ? 255 : 0;
    }

    public static boolean isDoubleSlab(IBlockAccess world, BlockPos pos) {
        return SlabComponent.isDoubleSlab(world.func_180495_p(pos));
    }

    public static boolean isDoubleSlab(IBlockState state) {
        SlabComponent sc = IComponent.getComponent(SlabComponent.class, state.func_177230_c());
        if (sc == null) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)sc.getTopProperty()) != false && (Boolean)state.func_177229_b((IProperty)sc.getBottomProperty()) != false;
    }

    public static boolean isSlab(IBlockAccess world, BlockPos pos) {
        return SlabComponent.isSlab(world.func_180495_p(pos).func_177230_c());
    }

    public static boolean isSlab(Block block) {
        if (block == Blocks.field_150333_U || block == Blocks.field_180389_cP || block == Blocks.field_150376_bx) {
            return true;
        }
        return IComponent.getComponent(SlabComponent.class, block) != null;
    }
}

