/*
 * Decompiled with CFR 0.152.
 */
package minechem.api;

import java.util.WeakHashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IMinechemBlueprint
extends IForgeRegistryEntry<IMinechemBlueprint> {
    public int xSize();

    public int ySize();

    public int zSize();

    public int getRenderScale();

    public IBlockState[][] getHorizontalSlice(int var1);

    public IBlockState[][] getVerticalSlice(int var1);

    public int getTotalSize();

    public IBlockState[][][] getStructure();

    public int getManagerPosX();

    public int getManagerPosY();

    public int getManagerPosZ();

    public String getDescriptiveName();

    default public IBlockState getBlockstateFromStack(int index, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77952_i());
        }
        return null;
    }

    default public WeakHashMap<IBlockState, Integer> getMaterials() {
        WeakHashMap<IBlockState, Integer> tmpMap = new WeakHashMap<IBlockState, Integer>();
        for (int x = 0; x < this.xSize(); ++x) {
            for (int y = 0; y < this.ySize(); ++y) {
                for (int z = 0; z < this.zSize(); ++z) {
                    IBlockState tmpState = this.getStructure()[y][x][z];
                    if (tmpMap.isEmpty() || !tmpMap.containsKey(tmpState)) {
                        tmpMap.put(tmpState, 1);
                        continue;
                    }
                    int currCount = tmpMap.get(tmpState);
                    tmpMap.put(tmpState, currCount + 1);
                }
            }
        }
        return tmpMap;
    }

    public int getXOffset();

    public int getYOffset();
}

