/*
 * Decompiled with CFR 0.152.
 */
package minechem.block;

import minechem.Minechem;
import minechem.block.BlockSimpleContainer;
import minechem.block.tile.TileDecomposer;
import minechem.client.render.RenderDecomposer;
import minechem.init.ModCreativeTab;
import minechem.init.ModGlobals;
import minechem.init.ModRendering;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockDecomposer
extends BlockSimpleContainer {
    public BlockDecomposer() {
        super(Material.field_151573_f);
        this.setRegistryName("minechem:chemical_decomposer");
        this.func_149663_c("chemical_decomposer");
        this.func_149647_a(ModCreativeTab.CREATIVE_TAB_ITEMS);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register(new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        ModRendering.setBlockRendering((Block)this, new RenderDecomposer(), TileDecomposer.class, new RenderDecomposer.ItemRenderDecomposer(), ModGlobals.Textures.Sprite.DECOMPOSER);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || player.func_70093_af() || !(tile instanceof TileDecomposer)) {
            return false;
        }
        if (!world.field_72995_K) {
            if (hand == EnumHand.MAIN_HAND && !player.func_184614_ca().func_190926_b() && (this.isFullBucket(player.func_184614_ca()) || this.getFluidFromItemTank(player.func_184614_ca()) != null)) {
                if (this.isFullBucket(player.func_184614_ca()) || this.getFluidFromItemTank(player.func_184614_ca()) != null) {
                    TileDecomposer decomposerTile = (TileDecomposer)tile;
                    if (this.doesTileContainFluid(decomposerTile)) {
                        FluidStack tileFluid;
                        FluidStack bucketFluid;
                        if (this.doesTileHaveFluidSpace(decomposerTile) && this.getFluidFromBucket(player.func_184614_ca()) != null && (bucketFluid = this.getFluidFromBucket(player.func_184614_ca())).isFluidEqual(tileFluid = decomposerTile.tank.getFluid())) {
                            ((IFluidHandler)decomposerTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)).fill(bucketFluid, true);
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
                            }
                        }
                    } else if (this.getFluidFromBucket(player.func_184614_ca()) != null) {
                        FluidStack bucketFluid = this.getFluidFromBucket(player.func_184614_ca());
                        ((IFluidHandler)decomposerTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)).fill(bucketFluid, true);
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
                        }
                    } else if (this.getFluidFromItemTank(player.func_184614_ca()) != null) {
                        FluidStack tankFluid = this.getFluidFromItemTank(player.func_184614_ca());
                        int added = ((IFluidHandler)decomposerTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)).fill(tankFluid, true);
                        System.out.println("" + tankFluid.amount % 1000);
                        if (!player.field_71075_bZ.field_75098_d) {
                            this.getFluidItemHandler(player.func_184614_ca()).drain(added, !player.field_71075_bZ.field_75098_d);
                        }
                    }
                }
            } else {
                player.openGui((Object)Minechem.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    private FluidStack getFluidFromItemTank(ItemStack tank) {
        IFluidHandlerItem handler = this.getFluidItemHandler(tank);
        if (handler != null) {
            FluidStack fluid = handler.getTankProperties()[0].getContents();
            return fluid;
        }
        return null;
    }

    private IFluidHandlerItem getFluidItemHandler(ItemStack tank) {
        if (tank.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem handler = (IFluidHandlerItem)tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            return handler;
        }
        return null;
    }

    private FluidStack getFluidFromBucket(ItemStack bucket) {
        NBTTagCompound subNBT;
        NBTTagCompound nbt;
        Item item = bucket.func_77973_b();
        if (item == Items.field_151131_as) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (item == Items.field_151129_at) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if ((item instanceof UniversalBucket || item == Items.field_151133_ar) && bucket.func_77942_o() && (nbt = bucket.func_77978_p()).func_74764_b("Tag") && (subNBT = nbt.func_74775_l("Tag")).func_74764_b("FluidName")) {
            return new FluidStack(FluidRegistry.getFluid((String)subNBT.func_74779_i("FluidName")), 1000);
        }
        return null;
    }

    private boolean doesTileContainFluid(TileDecomposer tile) {
        return tile.tank.getFluid() != null;
    }

    private boolean doesTileHaveFluidSpace(TileDecomposer tile) {
        int used;
        int cap = tile.tank.getCapacity();
        return cap - (used = tile.tank.getFluidAmount()) >= 1000;
    }

    private boolean isFullBucket(ItemStack stack) {
        Item item = stack.func_77973_b();
        boolean isBucketFull = false;
        if ((item instanceof UniversalBucket || item == Items.field_151133_ar) && stack.func_77942_o()) {
            isBucketFull = true;
        }
        return isBucketFull || item == Items.field_151131_as || item == Items.field_151129_at;
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileDecomposer();
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState p_isOpaqueCube_1_) {
        return false;
    }
}

