/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.multiblock.tile;

import javax.annotation.Nullable;
import minechem.block.multiblock.tile.TileReactorCore;
import minechem.init.ModConfig;
import minechem.init.ModItems;
import minechem.init.ModNetworking;
import minechem.item.ItemElement;
import minechem.item.blueprint.BlueprintFission;
import minechem.item.element.ElementEnum;
import minechem.network.message.FissionUpdateMessage;
import minechem.utils.MinechemUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileFissionCore
extends TileReactorCore
implements ISidedInventory {
    public static int[] kInput = new int[]{0};
    public static int[] kOutput = new int[]{2};
    public static int kStartInput = 0;
    int timer;

    public TileFissionCore() {
        this(null);
    }

    public TileFissionCore(EnumFacing structureFacing) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.setBlueprint(new BlueprintFission());
        this.setStructureFacing(structureFacing);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.timer;
        if (!this.field_145850_b.field_72995_K && this.structureFormed && !((ItemStack)this.inventory.get(kStartInput)).func_190926_b() && this.inputIsFissionable() && this.useEnergy(this.getEnergyRequired())) {
            ItemStack fissionResult = this.getFissionOutput();
            this.addToOutput(fissionResult);
            this.removeInputs();
        }
        if (this.timer >= 20) {
            this.timer = 0;
            FissionUpdateMessage message = new FissionUpdateMessage(this, this.structureFormed);
            ModNetworking.INSTANCE.sendToDimension((IMessage)message, this.func_145831_w().field_73011_w.getDimension());
            this.func_70296_d();
            IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (iblockstate != null) {
                this.func_145831_w().func_184138_a(this.func_174877_v(), iblockstate, iblockstate, 3);
            }
        }
    }

    public boolean inputIsFissionable() {
        ItemStack fissionResult = this.getFissionOutput();
        if (!fissionResult.func_190926_b()) {
            if (((ItemStack)this.inventory.get(kOutput[0])).func_190926_b()) {
                return true;
            }
            boolean sameItem = fissionResult.func_77973_b() == ((ItemStack)this.inventory.get(kOutput[0])).func_77973_b() && fissionResult.func_77952_i() == ((ItemStack)this.inventory.get(kOutput[0])).func_77952_i();
            return ((ItemStack)this.inventory.get(kOutput[0])).func_190916_E() < 64 && sameItem;
        }
        return false;
    }

    private void addToOutput(ItemStack fusionResult) {
        if (fusionResult.func_190926_b()) {
            return;
        }
        if (((ItemStack)this.inventory.get(kOutput[0])).func_190926_b()) {
            ItemStack output = fusionResult.func_77946_l();
            this.inventory.set(kOutput[0], (Object)output);
        } else {
            ((ItemStack)this.inventory.get(kOutput[0])).func_190917_f(2);
        }
    }

    private void removeInputs() {
        this.func_70298_a(kInput[0], 1);
    }

    private ItemStack getFissionOutput() {
        if (!((ItemStack)this.inventory.get(kInput[0])).func_190926_b() && ((ItemStack)this.inventory.get(kInput[0])).func_77973_b() instanceof ItemElement && ((ItemStack)this.inventory.get(kInput[0])).func_77952_i() > 0) {
            int mass = MinechemUtil.getElement((ItemStack)this.inventory.get(kInput[0])).atomicNumber();
            int newMass = mass / 2;
            if (newMass > 0 && ElementEnum.getByID(newMass) != null) {
                return new ItemStack((Item)ModItems.element, 2, newMass);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int func_70302_i_() {
        return 3;
    }

    @Override
    @Nullable
    public ItemStack func_70304_b(int i) {
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory.set(slot, (Object)itemstack);
    }

    @Override
    public String func_70005_c_() {
        return "container.minechemFission";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.structureFormed;
    }

    @Override
    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    @Override
    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        NBTTagList inventoryTagList = MinechemUtil.writeItemStackListToTagList((NonNullList<ItemStack>)this.inventory);
        nbtTagCompound.func_74782_a("inventory", (NBTBase)inventoryTagList);
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory = MinechemUtil.readTagListToItemStackList(nbtTagCompound.func_150295_c("inventory", 10));
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot != 2 && itemstack.func_77973_b() instanceof ItemElement) {
            if (slot == 1 && itemstack.func_77952_i() == 91) {
                return true;
            }
            if (slot == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int func_174887_a_(int i) {
        return 0;
    }

    @Override
    public void func_174885_b(int i, int i1) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing enumFacing) {
        switch (enumFacing) {
            case DOWN: {
                return kOutput;
            }
        }
        return kInput;
    }

    public boolean func_180462_a(int i, ItemStack itemStack, EnumFacing facing) {
        return false;
    }

    public boolean func_180461_b(int i, ItemStack itemStack, EnumFacing facing) {
        return false;
    }

    @Override
    public int getEnergyRequired() {
        if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return ((ItemStack)this.inventory.get(0)).func_77952_i() * ModConfig.fissionMultiplier;
        }
        return 0;
    }

    @Override
    public boolean func_191420_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

