/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.tile;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import minechem.api.IDecomposerControl;
import minechem.block.tile.TileMinechemEnergyBase;
import minechem.init.ModConfig;
import minechem.init.ModNetworking;
import minechem.inventory.InventoryBounded;
import minechem.item.ItemElement;
import minechem.network.message.MessageDecomposerDumpFluid;
import minechem.potion.PotionChemical;
import minechem.radiation.RadiationEnum;
import minechem.recipe.RecipeDecomposer;
import minechem.recipe.RecipeDecomposerFluid;
import minechem.recipe.handler.RecipeHandlerDecomposer;
import minechem.utils.MinechemUtil;
import minechem.utils.RadiationUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileDecomposer
extends TileMinechemEnergyBase
implements ISidedInventory {
    public static final int[] inputSlots = new int[]{0};
    public static final int[] outputSlots = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    private static final int TANK_CAPACITY = 5000;
    public FluidTank tank = new DecomposerFluidTank(5000);
    private final InventoryBounded inputInventory = new InventoryBounded(this, inputSlots);
    private NonNullList<ItemStack> outputBuffer = NonNullList.func_191197_a((int)outputSlots.length, (Object)ItemStack.field_190927_a);
    private final InventoryBounded outputInventory = new InventoryBounded(this, outputSlots);
    private boolean isCooking = false;
    private int timer = 0;

    public TileDecomposer() {
        super(ModConfig.maxDecomposerStorage);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.outputBuffer = NonNullList.func_191197_a((int)outputSlots.length, (Object)ItemStack.field_190927_a);
        this.tank.setTileEntity((TileEntity)this);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, facing));
        }
        return super.getCapability(capability, facing);
    }

    public boolean isCooking() {
        return this.isCooking;
    }

    private boolean isOutputBufferEmpty() {
        for (ItemStack stack : this.outputBuffer) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private int getCurrentOutputBufferProcessingSlot() {
        int currentSlotBeingProcessed;
        int lastPossibleSlot = currentSlotBeingProcessed = this.outputBuffer.size() - 1;
        if (!this.isOutputBufferEmpty()) {
            for (int i = lastPossibleSlot; i >= 0; --i) {
                if (((ItemStack)this.outputBuffer.get(i)).func_190926_b()) continue;
                currentSlotBeingProcessed = i;
                break;
            }
        } else {
            currentSlotBeingProcessed = -1;
        }
        return currentSlotBeingProcessed;
    }

    private boolean canStackBeAddedToOutputInventory(ItemStack stack) {
        if (this.outputInventory.func_191420_l()) {
            return true;
        }
        for (int i = 0; i < this.outputInventory.func_70302_i_(); ++i) {
            ItemStack tmpStack = this.outputInventory.func_70301_a(i);
            if (!this.outputInventory.func_70301_a(i).func_190926_b() && !this.areStacksEqualIgnoreSize(tmpStack, stack) || tmpStack.func_190916_E() >= tmpStack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    private boolean areStacksEqualIgnoreSize(ItemStack stack1, ItemStack stack2) {
        ItemStack tmpStack1 = stack1.func_77946_l();
        ItemStack tmpStack2 = stack2.func_77946_l();
        tmpStack1.func_190920_e(1);
        tmpStack2.func_190920_e(1);
        NBTTagCompound tmpNBT = new NBTTagCompound();
        tmpStack1.func_77982_d(tmpNBT);
        tmpStack2.func_77982_d(tmpNBT);
        boolean areEqual = ItemStack.func_77989_b((ItemStack)tmpStack1, (ItemStack)tmpStack2);
        return areEqual;
    }

    private void processInput() {
        if (this.canDecomposeInput()) {
            ArrayList<PotionChemical> output;
            RecipeDecomposer recipe = null;
            ItemStack inputStack = this.inputInventory.func_70301_a(0);
            if (!inputStack.func_190926_b()) {
                recipe = RecipeDecomposer.get(inputStack);
            } else if (this.tank.getFluidAmount() > 0) {
                recipe = RecipeDecomposer.get(this.tank.getFluid());
            }
            if (recipe != null && this.useEnergy(this.getEnergyRequired()) && !this.isOutputInventoryFull() && (output = recipe.getOutput()) != null) {
                this.isCooking = true;
                NonNullList<ItemStack> stacks = MinechemUtil.convertChemicalsIntoItemStacks(this.getBrokenOutput(output, inputStack.func_190926_b() ? 1.0 : this.getDecompositionMultiplier(inputStack)));
                for (ItemStack stack : stacks) {
                    if (RadiationUtil.getRadioactivity(stack) == RadiationEnum.stable) continue;
                    ItemElement.initiateRadioactivity(stack, this.func_145831_w());
                }
                if (!inputStack.func_190926_b()) {
                    this.outputBuffer = stacks;
                    inputStack.func_190918_g(1);
                    if (inputStack.func_190916_E() <= 0) {
                        this.inputInventory.func_70299_a(0, ItemStack.field_190927_a);
                    }
                } else if (this.tank.getFluidAmount() > 0) {
                    int fluidAmount = ((RecipeDecomposerFluid)recipe).inputFluid.amount;
                    if (this.tank.getFluidAmount() >= fluidAmount) {
                        this.outputBuffer = stacks;
                        this.tank.drain(fluidAmount, true);
                    }
                }
                this.func_70296_d();
                IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
                if (iblockstate != null) {
                    this.func_145831_w().func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
                }
            }
        }
    }

    private boolean processOutputBuffer() {
        if (!this.isOutputBufferEmpty()) {
            int currentSlot = this.getCurrentOutputBufferProcessingSlot();
            if (currentSlot >= 0) {
                this.isCooking = true;
                ItemStack currentBufferStack = (ItemStack)this.outputBuffer.get(currentSlot);
                if (this.canStackBeAddedToOutputInventory(currentBufferStack)) {
                    ItemStack outputStack = currentBufferStack.func_77946_l();
                    outputStack.func_190920_e(1);
                    currentBufferStack.func_190918_g(1);
                    if (currentBufferStack.func_190916_E() <= 0) {
                        currentBufferStack = ItemStack.field_190927_a;
                    }
                    this.addStackToOutput(outputStack);
                }
            } else {
                this.isCooking = false;
            }
        } else {
            this.isCooking = false;
        }
        this.func_70296_d();
        IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (iblockstate != null) {
            this.func_145831_w().func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
        }
        return this.isCooking;
    }

    private boolean canDecomposeInput() {
        if (!this.hasRequiredEnergy() || this.isCooking || !this.isOutputBufferEmpty()) {
            return false;
        }
        ItemStack inputStack = this.func_70301_a(inputSlots[0]);
        RecipeDecomposer recipe = null;
        if (!inputStack.func_190926_b()) {
            recipe = RecipeDecomposer.get(inputStack);
        } else if (this.tank.getFluidAmount() > 0) {
            recipe = RecipeDecomposer.get(this.tank.getFluid());
        }
        if (recipe != null) {
            NonNullList<ItemStack> recipeList = MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutputAsArray());
            for (ItemStack currentStack : recipeList) {
                for (int i = 0; i < this.outputInventory.func_70302_i_(); ++i) {
                    ItemStack tmpStack = this.outputInventory.func_70301_a(i);
                    if (tmpStack.func_190926_b()) {
                        return true;
                    }
                    if (!this.areStacksEqualIgnoreSize(currentStack, tmpStack)) continue;
                    int availSpace = tmpStack.func_77976_d() - tmpStack.func_190916_E();
                    if (tmpStack.func_77976_d() - tmpStack.func_190916_E() > availSpace) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isOutputInventoryFull() {
        for (int i = 0; i < this.outputInventory.func_70302_i_(); ++i) {
            ItemStack tmpStack = this.outputInventory.func_70301_a(i);
            if (!tmpStack.func_190926_b() && tmpStack.func_190916_E() >= tmpStack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private void addStackToOutput(ItemStack stack) {
        for (int i = 0; i < this.outputInventory.func_70302_i_(); ++i) {
            if (this.outputInventory.func_70301_a(i).func_190926_b()) {
                this.outputInventory.func_70299_a(i, stack);
                return;
            }
            if (!this.areStacksEqualIgnoreSize(this.outputInventory.func_70301_a(i), stack) || this.outputInventory.func_70301_a(i).func_190916_E() >= this.outputInventory.func_70301_a(i).func_77976_d()) continue;
            this.outputInventory.func_70301_a(i).func_190917_f(1);
            return;
        }
    }

    private boolean hasRequiredEnergy() {
        return this.getEnergyStored() >= ModConfig.costDecomposition || !ModConfig.powerUseEnabled;
    }

    public int[] func_180463_a(EnumFacing enumFacing) {
        return enumFacing == EnumFacing.UP ? inputSlots : outputSlots;
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing j) {
        boolean useableSide = false;
        for (EnumFacing tmpFacing : EnumFacing.field_176754_o) {
            if (!j.equals((Object)tmpFacing)) continue;
            useableSide = true;
            break;
        }
        return i > 0 && useableSide;
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing j) {
        return j == EnumFacing.UP && i == 0 && RecipeDecomposer.get(itemstack) != null && !this.isOutputInventoryFull();
    }

    public void closeInventory() {
    }

    private double getDecompositionMultiplier(ItemStack stack) {
        if (stack.func_77973_b() instanceof IDecomposerControl) {
            return ((IDecomposerControl)stack.func_77973_b()).getDecomposerMultiplier(stack);
        }
        if (!stack.func_77942_o()) {
            return 1.0;
        }
        if (stack.func_77978_p().func_150297_b("damage", 3)) {
            return 1.0 - (double)stack.func_77978_p().func_74762_e("damage") / 100.0;
        }
        if (stack.func_77978_p().func_150297_b("broken", 1)) {
            return stack.func_77978_p().func_74767_n("broken") ? 0.0 : 1.0;
        }
        return 1.0;
    }

    private PotionChemical[] getBrokenOutput(ArrayList<PotionChemical> output, double mult) {
        if (mult == 1.0) {
            return output.toArray(new PotionChemical[output.size()]);
        }
        if (mult <= 0.0) {
            return new PotionChemical[0];
        }
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        for (PotionChemical chemical : output) {
            PotionChemical addChemical = chemical.copy();
            addChemical.amount = (int)((double)addChemical.amount * mult);
            result.add(addChemical);
        }
        return result.toArray(new PotionChemical[result.size()]);
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        if (var1 == 1) {
            return inputSlots;
        }
        return outputSlots;
    }

    @Override
    public int func_70302_i_() {
        return 19;
    }

    @Override
    @Nullable
    public ItemStack func_70304_b(int i) {
        return ItemStack.field_190927_a;
    }

    public int[] getSizeInventorySide(int side) {
        switch (side) {
            case 1: {
                return inputSlots;
            }
        }
        return outputSlots;
    }

    public boolean isFluidValidForDecomposer(Fluid fluid) {
        return RecipeDecomposer.get(new FluidStack(fluid, 1)) != null;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        RecipeDecomposer recipe;
        return i == inputSlots[0] && (recipe = RecipeHandlerDecomposer.instance.getRecipe(itemstack)) != null;
    }

    @Override
    public int func_174887_a_(int i) {
        return 0;
    }

    @Override
    public void func_174885_b(int i, int i1) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
    }

    @Override
    public int getEnergyRequired() {
        return ModConfig.powerUseEnabled ? ModConfig.costDecomposition : 0;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        ItemStack oldStack;
        if (slot == outputSlots[0] && !(oldStack = (ItemStack)this.inventory.get(outputSlots[0])).func_190926_b() && !itemstack.func_190926_b() && oldStack.func_77952_i() == itemstack.func_77952_i() && oldStack.func_77973_b() == itemstack.func_77973_b() && oldStack.func_190916_E() > itemstack.func_190916_E()) {
            this.func_70298_a(slot, oldStack.func_190916_E() - itemstack.func_190916_E());
        }
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.inventory.set(slot, (Object)itemstack);
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    @Override
    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound mergedTankNBT;
        super.func_145839_a(nbt);
        NBTTagList inventoryTagList = nbt.func_150295_c("inventory", 10);
        NBTTagList buffer = nbt.func_150295_c("buffer", 10);
        this.outputBuffer = MinechemUtil.readTagListToItemStackList(buffer);
        this.inventory = MinechemUtil.readTagListToItemStackList(inventoryTagList);
        this.isCooking = nbt.func_74767_n("cooking");
        if (nbt.func_150297_b("tank", 10) && (mergedTankNBT = nbt.func_74775_l("tank")).func_74764_b("FluidName") && mergedTankNBT.func_74764_b("Amount")) {
            NBTTagCompound tempTankNBT = new NBTTagCompound();
            tempTankNBT.func_74778_a("FluidName", mergedTankNBT.func_74779_i("FluidName"));
            tempTankNBT.func_74768_a("Amount", mergedTankNBT.func_74762_e("Amount"));
            nbt.func_74782_a("tank", (NBTBase)tempTankNBT);
        }
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList inventoryTagList = MinechemUtil.writeItemStackListToTagList((NonNullList<ItemStack>)this.inventory);
        NBTTagList buffer = MinechemUtil.writeItemStackListToTagList(this.outputBuffer);
        nbt.func_74782_a("inventory", (NBTBase)inventoryTagList);
        nbt.func_74782_a("buffer", (NBTBase)buffer);
        nbt.func_74757_a("cooking", this.isCooking);
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.timer;
        if (this.timer <= 5) {
            return;
        }
        this.timer = 0;
        if (this.field_145850_b.field_72995_K || this.getState() == State.jammed || this.isOutputInventoryFull()) {
            return;
        }
        if (this.isCooking) {
            this.processOutputBuffer();
        } else {
            this.processInput();
        }
        this.func_70296_d();
        IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (iblockstate != null) {
            this.func_145831_w().func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
        }
    }

    public String getStateString() {
        return "TEMP";
    }

    public State getState() {
        if (!this.outputBuffer.isEmpty() && this.isOutputInventoryFull()) {
            return State.jammed;
        }
        if (this.canDecomposeInput()) {
            if (!ModConfig.powerUseEnabled || this.getEnergyStored() > ModConfig.costDecomposition) {
                return State.finished;
            }
            return State.idle;
        }
        return State.active;
    }

    public void dumpFluid() {
        this.tank = new FluidTank(5000);
        if (this.field_145850_b.field_72995_K) {
            ModNetworking.INSTANCE.sendToServer((IMessage)new MessageDecomposerDumpFluid(this));
        }
    }

    public int getTankCapacity() {
        return 5000;
    }

    @Override
    public String func_70005_c_() {
        return "container.decomposer";
    }

    @Override
    public boolean func_191420_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    public static enum State {
        idle,
        active,
        finished,
        jammed;

    }

    public static class DecomposerFluidTank
    extends FluidTank {
        public DecomposerFluidTank(int capacity) {
            super(capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return RecipeDecomposer.get(fluid) != null;
        }

        protected void onContentsChanged() {
            if (this.tile != null) {
                TileDecomposer te = (TileDecomposer)this.tile;
                te.func_70296_d();
                IBlockState iblockstate = te.func_145831_w().func_180495_p(te.func_174877_v());
                if (iblockstate != null) {
                    te.func_145831_w().func_184138_a(te.func_174877_v(), iblockstate, iblockstate, 3);
                }
            }
        }
    }
}

