/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import minechem.api.IMinechemBlueprint;
import minechem.api.client.gui.widget.IGuiMaterialListSlot;
import minechem.block.tile.TileBlueprintProjector;
import minechem.block.tile.TileMinechemEnergyBase;
import minechem.client.gui.GuiContainerTabbed;
import minechem.client.gui.widget.GuiImgButton;
import minechem.client.gui.widget.GuiMaterialListSlot;
import minechem.client.gui.widget.tab.TabBlueprintProjectorState;
import minechem.client.gui.widget.tab.TabHelp;
import minechem.container.ContainerBlueprintProjector;
import minechem.init.ModGlobals;
import minechem.utils.BlueprintUtil;
import minechem.utils.MinechemUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class GuiBlueprintProjector
extends GuiContainerTabbed {
    TileBlueprintProjector projector;
    GuiImgButton playButton;
    List<IGuiMaterialListSlot> materialList;
    int[] lastClick;
    int[] lastDrag;
    float rotX = 0.0f;
    float rotY = 0.0f;
    int mouseX;
    int mouseY = 0;

    public GuiBlueprintProjector(InventoryPlayer inventoryPlayer, TileBlueprintProjector projector) {
        super(new ContainerBlueprintProjector(inventoryPlayer, projector));
        this.projector = projector;
        this.addTab(new TabBlueprintProjectorState((Gui)this, projector));
        this.addTab(new TabHelp(this, MinechemUtil.getLocalString("help.projector")));
        this.rotX = 25.0f;
        this.rotY = -45.0f;
        this.field_147000_g = 204;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.getMaterialList();
        this.field_146292_n.clear();
    }

    public TileBlueprintProjector getProjector() {
        return this.projector;
    }

    public float getZLevel() {
        return this.field_73735_i;
    }

    public void setZLevel(float level) {
        this.field_73735_i = level;
    }

    public RenderItem getItemRenderer() {
        return this.field_146296_j;
    }

    public float getItemRendererZLevel() {
        return this.getItemRenderer().field_77023_b;
    }

    public void setItemRenderZLevel(float level) {
        this.getItemRenderer().field_77023_b = level;
    }

    protected List<IGuiMaterialListSlot> getMaterialList() {
        if (this.getProjector().hasBlueprint()) {
            if (this.materialList == null || this.materialList.isEmpty()) {
                this.materialList = new ArrayList<IGuiMaterialListSlot>();
                IBlockState[] states = this.getProjector().getBlueprint().getMaterials().keySet().toArray(new IBlockState[this.getProjector().getBlueprint().getMaterials().keySet().size()]);
                int yOffset = 0;
                for (int i = 0; i < states.length; ++i) {
                    ItemStack stack = states[i].func_177230_c().getPickBlock(states[i], null, (World)this.field_146297_k.field_71441_e, new BlockPos(0, 0, 0), (EntityPlayer)this.field_146297_k.field_71439_g);
                    if (stack.func_190926_b()) continue;
                    Integer count = this.getProjector().getBlueprint().getMaterials().get(states[i]);
                    this.materialList.add(new GuiMaterialListSlot(this, i, 7, this.field_147009_r + yOffset, (Pair<ItemStack, Integer>)Pair.of((Object)stack, (Object)count), Lists.newArrayList((Object[])new String[]{stack.func_82833_r()})));
                    yOffset += 10;
                }
            }
        } else {
            this.materialList = new ArrayList<IGuiMaterialListSlot>();
        }
        return this.materialList;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        String info = MinechemUtil.getLocalString("block.blueprint_projector.name");
        int infoWidth = this.field_146289_q.func_78256_a(info);
        this.field_146289_q.func_78276_b(info, (this.field_146999_f - infoWidth) / 2, 5, 0);
        if (this.getMaterialList() != null && !this.getMaterialList().isEmpty()) {
            IMinechemBlueprint bp = this.getProjector().getBlueprint();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            String bpName = bp.getDescriptiveName();
            if (bpName.length() > 15) {
                bpName = bpName.substring(0, 15) + "...";
            }
            this.field_146297_k.field_71466_p.func_78276_b(bpName, 27, 112, 0);
            this.field_146297_k.field_71466_p.func_78276_b(MinechemUtil.getLocalString("gui.blueprintprojector.material_list"), 34, 124, 0);
            GlStateManager.func_179121_F();
            int xx = 0;
            int yy = 0;
            for (IGuiMaterialListSlot slot : this.getMaterialList()) {
                int startX = (xx * 50 + 5) * 2;
                int startY = yy * 10 + 18;
                slot.draw(startX, startY, x, y);
                if (slot.isMouseOver(this.mouseX, this.mouseY)) {
                    this.renderTooltip(slot, this.mouseX, this.mouseY);
                }
                ++yy;
            }
        }
        super.func_146979_b(x, y);
    }

    public void renderTooltip(IGuiMaterialListSlot slot, int x, int y) {
        List<String> textLines = slot.getTooltip();
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && !textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int i = 0;
            for (String s : textLines) {
                int j = this.field_146297_k.field_71466_p.func_78256_a(s);
                if (j <= i) continue;
                i = j;
            }
            int l1 = x - this.field_146999_f - 50;
            int i2 = y - this.field_147000_g / 2;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10;
            }
            if (l1 + i > this.field_146999_f) {
                l1 -= 28 + i;
            }
            if (i2 + k + 6 > this.field_147000_g) {
                i2 = this.field_147000_g - k;
            }
            l1 = x - this.field_147003_i;
            i2 = y - this.field_147009_r - 20;
            this.setZLevel(300.0f);
            this.setItemRenderZLevel(300.0f);
            this.func_73733_a(l1 - 3, i2 - 4, l1 + (i += 13) + 3, i2 - 3, -10336502, -267386864);
            this.func_73733_a(l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, -267386864, -267386864);
            this.func_73733_a(l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, -267386864, -267386864);
            this.func_73733_a(l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.func_73733_a(l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, 0x505000FF, 0x505000FF);
            this.func_73733_a(l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, 1344798847, 1344798847);
            for (int k1 = 0; k1 < textLines.size(); ++k1) {
                String s1 = textLines.get(k1);
                this.field_146297_k.field_71466_p.func_175063_a(s1, (float)(l1 + 10), (float)i2, -1);
                if (k1 == 0) {
                    i2 += 2;
                }
                i2 += 10;
            }
            this.setItemRenderZLevel(0.0f);
            this.setZLevel(0.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            this.field_146296_j.func_180450_b((ItemStack)slot.get().getLeft(), l1 / 2 - 12, i2 / 2 - 12);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        int required;
        int stored;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.PROJECTOR);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        ItemStack blueprintStack = this.projector.func_70301_a(0);
        if (!blueprintStack.func_190926_b()) {
            this.drawBlueprintInfo(blueprintStack);
        }
        GlStateManager.func_179121_F();
        if (this.projector.hasBlueprint() && (stored = ((TileBlueprintProjector)this.field_146297_k.field_71441_e.func_175625_s(this.getProjector().func_174877_v())).getEnergyStored()) > (required = ((TileMinechemEnergyBase)this.field_146297_k.field_71441_e.func_175625_s(this.getProjector().func_174877_v())).getEnergyRequired())) {
            BlueprintUtil.renderStructureOnScreen(this.projector.getBlueprint(), x + 53, y + 5, var2, var3, this.rotX, this.rotY, this.projector.getBlueprint().getRenderScale());
        }
    }

    public int guiLeft() {
        return this.field_147003_i;
    }

    public int guiTop() {
        return this.field_147009_r;
    }

    public void renderToolTip(int x, int y) {
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            this.func_146285_a(this.field_147006_u.func_75211_c(), x, y);
        }
    }

    private void drawBlueprintInfo(ItemStack blueprintStack) {
        IMinechemBlueprint blueprint = BlueprintUtil.getBlueprint(blueprintStack);
        if (blueprint == null) {
            return;
        }
    }

    private void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
        if (clickX > this.field_147003_i + 62 && clickX < this.field_147003_i + 165 && mx >= 0 && mx < 1000 && clickY >= this.field_147009_r + 8 && clickY < this.field_147009_r + 80 && my >= 0 && my < 1000) {
            int dx = mx - lastX;
            int dy = my - lastY;
            this.rotY += (float)dx / 104.0f * 80.0f;
            this.rotX += (float)dy / 100.0f * 80.0f;
        }
    }

    protected void func_146273_a(int mx, int my, int button, long time) {
        if (this.lastClick != null) {
            if (this.lastDrag == null) {
                this.lastDrag = new int[]{mx - this.field_147003_i, my - this.field_147009_r};
            }
            this.mouseDragged(this.field_147003_i + 32, this.field_147009_r + 28, this.lastClick[0], this.lastClick[1], mx - this.field_147003_i, my - this.field_147009_r, this.lastDrag[0], this.lastDrag[1], button);
            this.lastDrag = new int[]{mx - this.field_147003_i, my - this.field_147009_r};
        }
    }

    protected void func_146286_b(int mx, int my, int action) {
        super.func_146286_b(mx, my, action);
        this.lastClick = null;
        this.lastDrag = null;
    }

    @Override
    public void func_73864_a(int mx, int my, int button) throws IOException {
        super.func_73864_a(mx, my, button);
        this.lastClick = new int[]{mx, my};
    }
}

