/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import minechem.api.IVerticalScrollContainer;
import minechem.api.recipe.ISynthesisRecipe;
import minechem.client.gui.GuiContainerTabbed;
import minechem.client.gui.GuiFakeSlot;
import minechem.client.gui.GuiTextField;
import minechem.client.gui.GuiVerticalScrollBar;
import minechem.container.ChemistJournalContainer;
import minechem.init.ModGlobals;
import minechem.init.ModItems;
import minechem.init.ModNetworking;
import minechem.network.message.MessageActiveItem;
import minechem.potion.PotionChemical;
import minechem.recipe.RecipeDecomposer;
import minechem.recipe.RecipeDecomposerChance;
import minechem.recipe.RecipeDecomposerSelect;
import minechem.recipe.RecipeSynthesisShaped;
import minechem.recipe.handler.RecipeHandlerDecomposer;
import minechem.recipe.handler.RecipeHandlerSynthesis;
import minechem.utils.MinechemUtil;
import minechem.utils.RecipeUtil;
import minechem.utils.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiChemistJournal
extends GuiContainerTabbed
implements IVerticalScrollContainer {
    private static final int SYNTHESIS_X = 197;
    private static final int SYNTHESIS_Y = 121;
    private static final int DECOMPOSER_X = 197;
    private static final int DECOMPOSER_Y = 41;
    private static final int GUI_WIDTH = 302;
    private static final int GUI_HEIGHT = 191;
    GuiVerticalScrollBar scrollBar;
    GuiTextField searchBar;
    List<GuiFakeSlot> itemListSlots = new ArrayList<GuiFakeSlot>();
    int listHeight;
    GuiFakeSlot[] synthesisSlots = new GuiFakeSlot[9];
    GuiFakeSlot[] decomposerSlots = new GuiFakeSlot[9];
    EntityPlayer player;
    private int slideShowTimer = 0;
    private int currentSlide = 0;
    public ItemStack currentItemStack;
    ISynthesisRecipe currentSynthesisRecipe;
    RecipeDecomposer currentDecomposerRecipe;
    ItemStack journalStack;
    List<ItemStack> itemList;

    public GuiChemistJournal(EntityPlayer entityPlayer) {
        super(new ChemistJournalContainer(entityPlayer.field_71071_by));
        this.player = entityPlayer;
        this.journalStack = entityPlayer.field_71071_by.func_70448_g();
        this.currentItemStack = ModItems.journal.getActiveStack(this.journalStack);
        if (!this.currentItemStack.func_190926_b()) {
            this.showRecipesForStack(this.currentItemStack);
        }
        this.field_146999_f = 302;
        this.field_147000_g = 191;
        this.scrollBar = new GuiVerticalScrollBar(this, 128, 14, 157, this.field_146999_f, this.field_147000_g);
        this.searchBar = new GuiTextField(106, 12, 18, 14);
        this.itemList = ModItems.journal.getItemList(this.journalStack);
        this.populateItemList();
    }

    public void populateItemList() {
        int i = 0;
        int j = 0;
        this.itemListSlots.clear();
        if (this.itemList != null) {
            for (ItemStack itemstack : this.itemList) {
                if (!this.searchBar.getText().equals("") && !itemstack.func_190926_b() && !itemstack.func_82833_r().toLowerCase().contains(this.searchBar.getText())) continue;
                int xPos = i * 18 + 20;
                int yPos = j * 18 + 31;
                GuiFakeSlot slot = new GuiFakeSlot(this, this.player);
                slot.setXPos(xPos);
                slot.setYPos(yPos);
                slot.setItemStack(itemstack);
                this.itemListSlots.add(slot);
                if (++i != 6) continue;
                i = 0;
                ++j;
            }
        }
        this.listHeight = j * 18;
        if (this.itemListSlots.size() == 1) {
            this.showRecipesForStack(this.itemListSlots.get(0).getItemStack());
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        GuiFakeSlot clickedSlot = null;
        for (GuiFakeSlot slot : this.itemListSlots) {
            if (!slot.getMouseIsOver()) continue;
            clickedSlot = slot;
            break;
        }
        if (clickedSlot != null) {
            this.onSlotClick(clickedSlot);
        }
        if (mouseButton == 1 && this.mouseX >= 20 && this.mouseY >= 14 && this.mouseX <= 119 && this.mouseY <= 25) {
            this.searchBar.setText("");
            this.searchBar.cursorPos = 0;
            this.populateItemList();
        }
    }

    protected void func_73869_a(char character, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.searchBar.keyTyped(character, keyCode);
        this.populateItemList();
    }

    public void onSlotClick(GuiFakeSlot slot) {
        ItemStack itemstack = slot.getItemStack();
        this.showRecipesForStack(itemstack);
    }

    public void showRecipesForStack(ItemStack itemstack) {
        this.currentItemStack = itemstack;
        ModItems.journal.setActiveStack(itemstack, this.journalStack);
        MessageActiveItem message = new MessageActiveItem(itemstack, this.player);
        ModNetworking.INSTANCE.sendToServer((IMessage)message);
        ISynthesisRecipe synthesisRecipe = RecipeHandlerSynthesis.getRecipeFromOutput(itemstack);
        RecipeDecomposer decomposerRecipe = RecipeHandlerDecomposer.instance.getRecipe(itemstack);
        this.synthesisSlots = new GuiFakeSlot[9];
        this.decomposerSlots = new GuiFakeSlot[9];
        this.currentSynthesisRecipe = null;
        this.currentDecomposerRecipe = null;
        if (synthesisRecipe != null) {
            this.showSynthesisRecipe(synthesisRecipe);
            this.currentSynthesisRecipe = synthesisRecipe;
        }
        if (decomposerRecipe != null) {
            this.showDecomposerRecipe(decomposerRecipe);
            this.currentDecomposerRecipe = decomposerRecipe;
        }
    }

    public void showSynthesisRecipe(ISynthesisRecipe recipe) {
        NonNullList<ItemStack> ingredients = RecipeUtil.getRecipeAsStackList(recipe);
        this.showIngredients(ingredients, this.synthesisSlots, 197, 121);
    }

    public void showDecomposerRecipe(RecipeDecomposer recipe) {
        if (recipe instanceof RecipeDecomposerSelect) {
            this.slideShowTimer = 0;
            this.currentSlide = 0;
            return;
        }
        NonNullList<ItemStack> ingredients = MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutputRaw());
        this.showIngredients(ingredients, this.decomposerSlots, 197, 41);
    }

    private void showDecomposerRecipeSelect(RecipeDecomposerSelect recipe) {
        ArrayList<ArrayList<PotionChemical>> outputs = recipe.getAllPossibleOutputs();
        if (this.slideShowTimer >= 160) {
            this.slideShowTimer = 0;
            ++this.currentSlide;
            if (this.currentSlide >= outputs.size()) {
                this.currentSlide = 0;
            }
        }
        if (this.slideShowTimer == 0) {
            ArrayList<PotionChemical> potionChemicals = outputs.get(this.currentSlide);
            NonNullList<ItemStack> ingredients = MinechemUtil.convertChemicalsIntoItemStacks(potionChemicals);
            this.showIngredients(ingredients, this.decomposerSlots, 197, 41);
        }
        ++this.slideShowTimer;
    }

    private void showIngredients(NonNullList<ItemStack> ingredients, GuiFakeSlot[] slotArray, int xOffset, int yOffset) {
        int pos = 0;
        int i = 0;
        int j = 0;
        for (ItemStack ingredient : ingredients) {
            if (pos >= 9) break;
            slotArray[pos] = null;
            if (!ingredient.func_190926_b()) {
                int x = i * 18 + xOffset;
                int y = j * 18 + yOffset;
                GuiFakeSlot fakeSlot = new GuiFakeSlot(this, this.player);
                fakeSlot.setItemStack(ingredient);
                fakeSlot.setXPos(x);
                fakeSlot.setYPos(y);
                slotArray[pos] = fakeSlot;
            }
            ++pos;
            if (++i != 3) continue;
            i = 0;
            ++j;
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.field_146297_k.field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.JOURNAL);
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f / 2, this.field_147000_g / 2);
        GlStateManager.func_179121_F();
        if (!this.currentItemStack.func_190926_b()) {
            this.drawRecipeGrid();
            this.drawRecipeGrid();
            this.drawText();
            this.drawRecipeSlots(x, y);
        } else {
            this.drawHelp();
        }
        this.scrollBar.draw();
        this.searchBar.draw();
        this.drawSlots(x, y);
        this.drawSlotTooltips();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.field_146297_k.field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.JOURNAL);
        this.func_73729_b(4, 82, 80, 96, 10, 10);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        if (this.currentDecomposerRecipe instanceof RecipeDecomposerSelect) {
            this.showDecomposerRecipeSelect((RecipeDecomposerSelect)this.currentDecomposerRecipe);
        }
    }

    private void drawRecipeGrid() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GL11.glBlendFunc((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.JOURNAL);
        this.func_73729_b(98, 20, 25, 96, 27, 27);
        if (this.currentSynthesisRecipe != null && this.currentSynthesisRecipe instanceof RecipeSynthesisShaped) {
            this.func_73729_b(98, 60, 52, 96, 27, 27);
        } else {
            this.func_73729_b(98, 60, 25, 96, 27, 27);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
    }

    private void drawText() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        String itemname = String.format("%so%<sl%<sn%s", "\u00a7", this.currentItemStack.func_82833_r());
        if (TextFormatting.func_110646_a((String)itemname).length() > 18) {
            itemname = itemname.substring(0, 18).trim() + "...";
        }
        this.field_146289_q.func_78276_b(itemname, 175, 10, -7650029);
        this.field_146289_q.func_78276_b(MinechemUtil.getLocalString("gui.journal.decomposer"), 175, 20, 0x884400);
        float chance = 100.0f;
        if (this.currentDecomposerRecipe != null && this.currentDecomposerRecipe instanceof RecipeDecomposerChance) {
            chance = this.currentDecomposerRecipe.getChance();
            chance *= 100.0f;
        }
        if (this.currentDecomposerRecipe != null) {
            this.field_146289_q.func_78276_b(String.format("%.1f%% " + MinechemUtil.getLocalString("gui.journal.chance"), Float.valueOf(chance)), 175, 30, 0x555555);
        }
        this.field_146289_q.func_78276_b(MinechemUtil.getLocalString("gui.journal.synthesis") + (this.currentSynthesisRecipe != null ? (this.currentSynthesisRecipe.isShaped() ? " - " + MinechemUtil.getLocalString("recipes.synthesis.shaped") : " - " + MinechemUtil.getLocalString("recipes.synthesis.shapeless")) : ""), 175, 100, 0x884400);
        if (this.currentSynthesisRecipe != null) {
            int energyCost = RecipeHandlerSynthesis.getEnergyCost(this.currentSynthesisRecipe);
            this.field_146289_q.func_78276_b(String.format("%d " + MinechemUtil.getLocalString("tab.tooltip.energy"), energyCost), 175, 110, 0x555555);
        }
    }

    private void drawHelp() {
        this.field_146289_q.func_78276_b(MinechemUtil.getLocalString("item.chemist_journal.name"), 180, 18, -16777216);
        String help = MinechemUtil.getLocalString("help.journal");
        GlStateManager.func_179094_E();
        float scale = 0.5f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        this.field_146289_q.func_78279_b(help, 345, 70, 200, -1442840576);
        GlStateManager.func_179121_F();
    }

    private void drawItemBox(int x, int y) {
        int selectedBoxColor = -7650029;
        this.func_73733_a(x - 1, y - 1, x + 106, y, selectedBoxColor, selectedBoxColor);
        this.func_73733_a(x - 1, y - 1, x, y + 149, selectedBoxColor, selectedBoxColor);
        this.func_73733_a(x + 106, y - 1, x + 107, y + 149, selectedBoxColor, selectedBoxColor);
        this.func_73733_a(x - 1, y + 148, x + 107, y + 149, selectedBoxColor, selectedBoxColor);
        int selectedBoxColor2 = -1719105400;
        this.func_73733_a(++x - 1, ++y - 1, x + 106, y, selectedBoxColor2, selectedBoxColor2);
        this.func_73733_a(x - 1, y - 1, x, y + 149, selectedBoxColor2, selectedBoxColor2);
    }

    private void drawSlots(int x, int y) {
        GlStateManager.func_179094_E();
        RenderUtil.startScissor(this.field_146297_k, x + 9, y + 29, 146, 148);
        int ypos = (int)((float)(this.listHeight - 130) * this.scrollBar.getScrollValue());
        GlStateManager.func_179109_b((float)0.0f, (float)(-ypos), (float)0.0f);
        for (GuiFakeSlot slot : this.itemListSlots) {
            slot.setYOffset(ypos);
            slot.draw();
        }
        RenderUtil.endScissor();
        GlStateManager.func_179121_F();
        y = 29;
        this.drawItemBox(x - 44, 29);
    }

    private void drawSlotTooltips() {
        for (GuiFakeSlot slot : this.itemListSlots) {
            slot.drawTooltip(this.mouseX + 10, this.mouseY);
        }
    }

    private void drawRecipeSlots(int x, int y) {
        for (GuiFakeSlot slot : this.synthesisSlots) {
            if (slot == null) continue;
            slot.draw();
        }
        for (GuiFakeSlot slot : this.decomposerSlots) {
            if (slot == null) continue;
            slot.draw();
        }
        for (GuiFakeSlot slot : this.synthesisSlots) {
            if (slot == null) continue;
            slot.drawTooltip(this.mouseX + 10, this.mouseY);
        }
        for (GuiFakeSlot slot : this.decomposerSlots) {
            if (slot == null) continue;
            slot.drawTooltip(this.mouseX + 10, this.mouseY);
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = i - (this.field_146294_l - this.field_146999_f) / 2;
        this.mouseY = j - (this.field_146295_m - this.field_147000_g) / 2;
        if (this.isScrollBarActive()) {
            this.scrollBar.handleMouseInput();
        }
    }

    @Override
    public boolean isScrollBarActive() {
        return this.itemList != null && this.itemList.size() > 48;
    }

    @Override
    public int getScreenWidth() {
        return this.field_146294_l;
    }

    @Override
    public int getScreenHeight() {
        return this.field_146295_m;
    }

    @Override
    public int getGuiWidth() {
        return this.field_146999_f;
    }

    @Override
    public int getGuiHeight() {
        return this.field_147000_g;
    }

    @Override
    public int getScrollAmount() {
        return 5;
    }
}

