/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import minechem.client.gui.GuiContainerBase;
import minechem.client.gui.widget.tab.GuiTab;
import minechem.client.gui.widget.tab.GuiTabPatreon;
import minechem.utils.MinechemUtil;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public abstract class GuiContainerTabbed
extends GuiContainerBase
implements GuiYesNoCallback {
    private static Class<?> openedTab;
    private String clickedURI;
    protected static int SCALE_ENERGY;
    protected static int SCALE_LIQUID;
    protected static int SCALE_PROGRESS;
    protected static int SCALE_SPEED;
    protected ArrayList<GuiTab> tabListLeft = new ArrayList();
    protected ArrayList<GuiTab> tabListRight = new ArrayList();
    public int mouseX = 0;
    public int mouseY = 0;
    public static boolean drawBorders;
    private final int _zLevel = 3;

    public void drawTexture(int x, int y, ResourceLocation resource) {
        int w = 16;
        int h = 16;
        this.field_146297_k.func_110434_K().func_110577_a(resource);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0), (double)(y + h), 2.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 2.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + 0), 2.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(x + 0), (double)(y + 0), 2.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public GuiContainerTabbed(Container container) {
        this(container, null);
    }

    public GuiContainerTabbed(Container container, RenderItem itemRenderer) {
        super(container, itemRenderer);
    }

    public List<GuiTab> getLeftGuiTabs() {
        return this.tabListLeft;
    }

    public List<GuiTab> getRightGuiTabs() {
        return this.tabListRight;
    }

    protected void func_146979_b(int i, int j) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.drawTabs();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    @Override
    public void func_73863_a(int mX, int mY, float par3) {
        String tooltip;
        super.func_73863_a(mX, mY, par3);
        GuiTab guiTab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (guiTab != null && (tooltip = guiTab.getTooltip()) != null) {
            this.func_146279_a(tooltip, mX, mY);
        }
    }

    protected void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        GuiTab guiTab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (guiTab != null) {
            GuiTabPatreon patreonTab;
            if (guiTab.leftSide) {
                for (GuiTab other : this.tabListLeft) {
                    if (other == guiTab || !other.isOpen()) continue;
                    other.toggleOpen();
                }
            } else {
                for (GuiTab other : this.tabListRight) {
                    if (other == guiTab || !other.isOpen()) continue;
                    other.toggleOpen();
                }
            }
            if (guiTab instanceof GuiTabPatreon && (patreonTab = (GuiTabPatreon)guiTab).isFullyOpened() && patreonTab.isLinkAtOffsetPosition(x - this.field_147003_i, y - this.field_147009_r)) {
                this.clickedURI = patreonTab.getLinkURL();
                if (this.field_146297_k.field_71474_y.field_74358_q) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, this.clickedURI, 0, false));
                } else {
                    MinechemUtil.openURL(patreonTab.getLinkURL());
                }
                return;
            }
            guiTab.toggleOpen();
        }
    }

    public void func_73878_a(boolean confirm, int id) {
        if (id == 0) {
            if (confirm) {
                MinechemUtil.openURL(this.clickedURI);
            }
            this.clickedURI = null;
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = i - (this.field_146294_l - this.field_146999_f) / 2;
        this.mouseY = j - (this.field_146295_m - this.field_147000_g) / 2;
    }

    public void addTab(GuiTab guiTab) {
        if (guiTab.leftSide) {
            this.tabListLeft.add(guiTab);
        } else {
            this.tabListRight.add(guiTab);
        }
        if (GuiContainerTabbed.getOpenedTab() != null && guiTab.getClass().equals(GuiContainerTabbed.getOpenedTab())) {
            guiTab.setFullyOpen();
        }
    }

    protected void drawTabs() {
        int yPos = 4;
        for (GuiTab guiTab : this.tabListLeft) {
            guiTab.update();
            if (!guiTab.isVisible()) continue;
            guiTab.drawTab(0, yPos);
            yPos += guiTab.getHeight();
        }
        yPos = 4;
        for (GuiTab guiTab : this.tabListRight) {
            guiTab.update();
            if (!guiTab.isVisible()) continue;
            guiTab.drawTab(this.field_146999_f, yPos);
            yPos += guiTab.getHeight();
        }
    }

    protected GuiTab getTabAtPosition(int mX, int mY) {
        int xShift = 0;
        int yShift = 4;
        for (GuiTab guiTab : this.tabListLeft) {
            if (!guiTab.isVisible()) continue;
            guiTab.currentX = xShift;
            guiTab.currentY = yShift;
            if (guiTab.intersectsWith(mX, mY, xShift, yShift)) {
                return guiTab;
            }
            yShift += guiTab.getHeight();
        }
        xShift = this.field_146999_f;
        yShift = 4;
        for (GuiTab guiTab : this.tabListRight) {
            if (!guiTab.isVisible()) continue;
            guiTab.currentX = xShift;
            guiTab.currentY = yShift;
            if (guiTab.intersectsWith(mX, mY, xShift, yShift)) {
                return guiTab;
            }
            yShift += guiTab.getHeight();
        }
        return null;
    }

    public int getMouseX() {
        return Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
    }

    public int getMouseY() {
        return this.field_146295_m - (Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1);
    }

    public static Class<?> getOpenedTab() {
        return openedTab;
    }

    public static void setOpenedTab(Class<?> tabClass) {
        openedTab = tabClass;
    }

    static {
        SCALE_ENERGY = 42;
        SCALE_LIQUID = 60;
        SCALE_PROGRESS = 24;
        SCALE_SPEED = 16;
    }

    protected static enum SlotRender {
        TOP,
        BOTTOM,
        FULL;

    }

    protected static enum SlotType {
        SINGLE,
        OUTPUT,
        DOUBLEOUTPUT;

    }

    protected static enum SlotColor {
        BLUE,
        RED,
        YELLOW,
        ORANGE,
        GREEN,
        PURPLE;

    }
}

